/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio.ssl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioEmbeddedFuture;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioFutureImpl;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;

class GridNioSslHandler
extends ReentrantLock {
    private static final long serialVersionUID = 0L;
    private IgniteLogger log;
    private SSLEngine sslEngine;
    private ByteOrder order;
    private boolean directBuf;
    private GridNioSession ses;
    private boolean handshakeFinished;
    private boolean initHandshakeComplete;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private ByteBuffer outNetBuf;
    private ByteBuffer inNetBuf;
    private ByteBuffer handshakeBuf = ByteBuffer.allocate(0);
    private ByteBuffer appBuf;
    private GridNioSslFilter parent;
    private Queue<WriteRequest> deferredWriteQueue = new LinkedList<WriteRequest>();

    GridNioSslHandler(GridNioSslFilter parent, GridNioSession ses, SSLEngine engine, boolean directBuf, ByteOrder order, IgniteLogger log2, boolean handshake, ByteBuffer encBuf) throws SSLException {
        assert (parent != null);
        assert (ses != null);
        assert (engine != null);
        assert (log2 != null);
        this.parent = parent;
        this.ses = ses;
        this.order = order;
        this.directBuf = directBuf;
        this.log = log2;
        this.sslEngine = engine;
        if (handshake) {
            this.sslEngine.beginHandshake();
        } else {
            this.handshakeFinished = true;
            this.initHandshakeComplete = true;
        }
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        int netBufSize = this.sslEngine.getSession().getPacketBufferSize() + 50;
        this.outNetBuf = directBuf ? ByteBuffer.allocateDirect(netBufSize) : ByteBuffer.allocate(netBufSize);
        this.outNetBuf.order(order);
        this.inNetBuf = directBuf ? ByteBuffer.allocateDirect(netBufSize) : ByteBuffer.allocate(netBufSize);
        this.inNetBuf.order(order);
        if (encBuf != null) {
            encBuf.flip();
            this.inNetBuf.put(encBuf);
        }
        this.outNetBuf.position(0);
        this.outNetBuf.limit(0);
        int appBufSize = Math.max(this.sslEngine.getSession().getApplicationBufferSize() + 50, netBufSize * 2);
        this.appBuf = directBuf ? ByteBuffer.allocateDirect(appBufSize) : ByteBuffer.allocate(appBufSize);
        this.appBuf.order(order);
        if (log2.isDebugEnabled()) {
            log2.debug("Started SSL session [netBufSize=" + netBufSize + ", appBufSize=" + appBufSize + ']');
        }
    }

    ByteBuffer getApplicationBuffer() {
        return this.appBuf;
    }

    void shutdown() {
        block2: {
            try {
                this.sslEngine.closeInbound();
            }
            catch (SSLException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Unable to correctly close inbound data stream (will ignore) [msg=" + e.getMessage() + ", ses=" + this.ses + ']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handshake() throws IgniteCheckedException, SSLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entered handshake(): [handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ", ses=" + this.ses + ']');
        }
        this.lock();
        try {
            boolean loop2 = true;
            block9: while (loop2) {
                switch (this.handshakeStatus) {
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        SSLSession sslSes = this.sslEngine.getSession();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Finished ssl handshake [protocol=" + sslSes.getProtocol() + ", cipherSuite=" + sslSes.getCipherSuite() + ", ses=" + this.ses + ']');
                        }
                        this.handshakeFinished = true;
                        if (!this.initHandshakeComplete) {
                            this.initHandshakeComplete = true;
                            GridNioFutureImpl fut = (GridNioFutureImpl)this.ses.removeMeta(GridNioSslFilter.HANDSHAKE_FUT_META_KEY);
                            if (fut != null) {
                                fut.onDone();
                            }
                            this.parent.proceedSessionOpened(this.ses);
                        }
                        loop2 = false;
                        continue block9;
                    }
                    case NEED_TASK: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Need to run ssl tasks: " + this.ses);
                        }
                        this.handshakeStatus = this.runTasks();
                        continue block9;
                    }
                    case NEED_UNWRAP: {
                        SSLEngineResult.Status status;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Need to unwrap incoming data: " + this.ses);
                        }
                        if (((status = this.unwrapHandshake()) != SSLEngineResult.Status.BUFFER_UNDERFLOW || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) && !this.sslEngine.isInboundDone()) continue block9;
                        loop2 = false;
                        continue block9;
                    }
                    case NEED_WRAP: {
                        if (this.outNetBuf.hasRemaining()) {
                            U.warn(this.log, "Output net buffer has unsent bytes during handshake (will clear): " + this.ses);
                        }
                        this.outNetBuf.clear();
                        SSLEngineResult res = this.sslEngine.wrap(this.handshakeBuf, this.outNetBuf);
                        this.outNetBuf.flip();
                        this.handshakeStatus = res.getHandshakeStatus();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Wrapped handshake data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ", ses=" + this.ses + ']');
                        }
                        this.writeNetBuffer(null);
                        continue block9;
                    }
                }
                throw new IllegalStateException("Invalid handshake status in handshake method [handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ", ses=" + this.ses + ']');
            }
        }
        finally {
            this.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaved handshake(): [handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ", ses=" + this.ses + ']');
        }
    }

    void messageReceived(ByteBuffer buf) throws IgniteCheckedException, SSLException {
        if (buf.limit() > this.inNetBuf.remaining()) {
            this.inNetBuf = this.expandBuffer(this.inNetBuf, this.inNetBuf.capacity() + buf.limit() * 2);
            this.appBuf = this.expandBuffer(this.appBuf, this.inNetBuf.capacity() * 2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Expanded buffers [inNetBufCapacity=" + this.inNetBuf.capacity() + ", appBufCapacity=" + this.appBuf.capacity() + ", ses=" + this.ses + ", ");
            }
        }
        this.inNetBuf.put(buf);
        if (!this.handshakeFinished) {
            this.handshake();
        } else {
            this.unwrapData();
        }
        if (this.isInboundDone()) {
            int newPosition = buf.position() - this.inNetBuf.position();
            if (newPosition >= 0) {
                buf.position(newPosition);
                if (buf.hasRemaining()) {
                    U.warn(this.log, "Got unread bytes after receiving close_notify message (will ignore): " + this.ses);
                }
            }
            this.inNetBuf.clear();
        }
    }

    ByteBuffer encrypt(ByteBuffer src) throws SSLException {
        assert (this.handshakeFinished);
        assert (this.isHeldByCurrentThread());
        this.outNetBuf.clear();
        while (src.hasRemaining()) {
            int outNetRemaining = this.outNetBuf.capacity() - this.outNetBuf.position();
            if (outNetRemaining < src.remaining() * 2) {
                this.outNetBuf = this.expandBuffer(this.outNetBuf, Math.max(this.outNetBuf.position() + src.remaining() * 2, this.outNetBuf.capacity() * 2));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Expanded output net buffer [outNetBufCapacity=" + this.outNetBuf.capacity() + ", ses=" + this.ses + ']');
                }
            }
            SSLEngineResult res = this.sslEngine.wrap(src, this.outNetBuf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Encrypted data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStaus=" + (Object)((Object)res.getHandshakeStatus()) + ", ses=" + this.ses + ']');
            }
            if (res.getStatus() == SSLEngineResult.Status.OK) {
                if (res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.runTasks();
                continue;
            }
            throw new SSLException("Failed to encrypt data (SSL engine error) [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)res.getHandshakeStatus()) + ", ses=" + this.ses + ']');
        }
        this.outNetBuf.flip();
        return this.outNetBuf;
    }

    boolean isHandshakeFinished() {
        return this.handshakeFinished;
    }

    boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    boolean isOutboundDone() {
        return this.sslEngine.isOutboundDone();
    }

    GridNioFuture<?> deferredWrite(ByteBuffer buf, IgniteInClosure<IgniteException> ackC) {
        assert (this.isHeldByCurrentThread());
        GridNioEmbeddedFuture fut = new GridNioEmbeddedFuture();
        ByteBuffer cp = this.copy(buf);
        this.deferredWriteQueue.offer(new WriteRequest(fut, cp, ackC));
        return fut;
    }

    void flushDeferredWrites() throws IgniteCheckedException {
        assert (this.isHeldByCurrentThread());
        assert (this.handshakeFinished);
        while (!this.deferredWriteQueue.isEmpty()) {
            WriteRequest req = this.deferredWriteQueue.poll();
            req.future().onDone(this.parent.proceedSessionWrite(this.ses, req.buffer(), true, req.ackC));
        }
    }

    boolean closeOutbound() throws SSLException {
        assert (this.isHeldByCurrentThread());
        if (!this.sslEngine.isOutboundDone()) {
            this.sslEngine.closeOutbound();
            this.outNetBuf.clear();
            SSLEngineResult res = this.sslEngine.wrap(this.handshakeBuf, this.outNetBuf);
            if (res.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLException("Incorrect SSL engine status after closeOutbound call [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)res.getHandshakeStatus()) + ", ses=" + this.ses + ']');
            }
            this.outNetBuf.flip();
            return true;
        }
        return false;
    }

    GridNioFuture<?> writeNetBuffer(IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (this.isHeldByCurrentThread());
        ByteBuffer cp = this.copy(this.outNetBuf);
        return this.parent.proceedSessionWrite(this.ses, cp, true, ackC);
    }

    private void unwrapData() throws IgniteCheckedException, SSLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unwrapping received data: " + this.ses);
        }
        this.inNetBuf.flip();
        SSLEngineResult res = this.unwrap0();
        this.inNetBuf.compact();
        this.checkStatus(res);
        this.renegotiateIfNeeded(res);
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException, IgniteCheckedException {
        this.inNetBuf.flip();
        SSLEngineResult res = this.unwrap0();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuf.hasRemaining()) {
            res = this.unwrap0();
            this.handshakeStatus = res.getHandshakeStatus();
            this.inNetBuf.compact();
            this.renegotiateIfNeeded(res);
        } else {
            this.inNetBuf.compact();
        }
        return res.getStatus();
    }

    private void renegotiateIfNeeded(SSLEngineResult res) throws IgniteCheckedException, SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeStatus = res.getHandshakeStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Renegotiation requested [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus = " + (Object)((Object)this.handshakeStatus) + "ses=" + this.ses + ']');
            }
            this.handshakeFinished = false;
            this.handshake();
        }
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("Failed to unwrap incoming data (SSL engine error) [ses" + this.ses + ", status=" + (Object)((Object)status) + ']');
        }
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult res;
        do {
            res = this.sslEngine.unwrap(this.inNetBuf, this.appBuf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unwrapped raw data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)res.getHandshakeStatus()) + ", ses=" + this.ses + ']');
            }
            if (res.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.appBuf = this.expandBuffer(this.appBuf, this.appBuf.capacity() * 2);
        } while ((res.getStatus() == SSLEngineResult.Status.OK || res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) && (this.handshakeFinished && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private SSLEngineResult.HandshakeStatus runTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running SSL engine task [task=" + runnable + ", ses=" + this.ses + ']');
            }
            runnable.run();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished running SSL engine tasks [handshakeStatus=" + (Object)((Object)this.sslEngine.getHandshakeStatus()) + ", ses=" + this.ses + ']');
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private ByteBuffer expandBuffer(ByteBuffer original, int cap) {
        ByteBuffer res = this.directBuf ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap);
        res.order(this.order);
        original.flip();
        res.put(original);
        return res;
    }

    private ByteBuffer copy(ByteBuffer original) {
        ByteBuffer cp = this.directBuf ? ByteBuffer.allocateDirect(original.remaining()) : ByteBuffer.allocate(original.remaining());
        cp.order(this.order);
        cp.put(original);
        cp.flip();
        return cp;
    }

    private static class WriteRequest {
        private final GridNioEmbeddedFuture<Object> fut;
        private final ByteBuffer buf;
        private final IgniteInClosure<IgniteException> ackC;

        private WriteRequest(GridNioEmbeddedFuture<Object> fut, ByteBuffer buf, IgniteInClosure<IgniteException> ackC) {
            this.fut = fut;
            this.buf = buf;
            this.ackC = ackC;
        }

        public GridNioEmbeddedFuture<Object> future() {
            return this.fut;
        }

        public ByteBuffer buffer() {
            return this.buf;
        }
    }
}

