/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.SessionWriteRequest;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridNioRecoveryDescriptor {
    private static final long DESC_RESERVATION_TIMEOUT = Math.max(1000L, IgniteSystemProperties.getLong("IGNITE_NIO_RECOVERY_DESCRIPTOR_RESERVATION_TIMEOUT", 5000L));
    private long acked;
    private final ArrayDeque<SessionWriteRequest> msgReqs;
    private int resendCnt;
    private long rcvCnt;
    private long sentCnt;
    private boolean reserved;
    private long lastAck;
    private boolean nodeLeft;
    private final ClusterNode node;
    private final IgniteLogger log;
    private IgniteBiTuple<Long, IgniteInClosure<Boolean>> handshakeReq;
    private boolean connected;
    private long connectCnt;
    private final int queueLimit;
    private int reserveCnt;
    private final boolean pairedConnections;
    @GridToStringExclude
    private GridNioSession ses;

    public GridNioRecoveryDescriptor(boolean pairedConnections, int queueLimit, ClusterNode node, IgniteLogger log2) {
        assert (!node.isLocal()) : node;
        assert (queueLimit > 0);
        this.msgReqs = new ArrayDeque(queueLimit);
        this.pairedConnections = pairedConnections;
        this.queueLimit = queueLimit;
        this.node = node;
        this.log = log2;
    }

    public boolean pairedConnections() {
        return this.pairedConnections;
    }

    public long incrementConnectCount() {
        return this.connectCnt++;
    }

    public ClusterNode node() {
        return this.node;
    }

    public long onReceived() {
        ++this.rcvCnt;
        return this.rcvCnt;
    }

    public long received() {
        return this.rcvCnt;
    }

    public long sent() {
        return this.sentCnt;
    }

    public void lastAcknowledged(long lastAck) {
        this.lastAck = lastAck;
    }

    public long lastAcknowledged() {
        return this.lastAck;
    }

    public int queueLimit() {
        return this.queueLimit;
    }

    public boolean add(SessionWriteRequest req) {
        assert (req != null);
        if (!req.skipRecovery()) {
            if (this.resendCnt == 0) {
                this.msgReqs.addLast(req);
                ++this.sentCnt;
                return this.msgReqs.size() < this.queueLimit;
            }
            --this.resendCnt;
        }
        return true;
    }

    public void ackReceived(long rcvCnt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handle acknowledgment [acked=" + this.acked + ", rcvCnt=" + rcvCnt + ", msgReqs=" + this.msgReqs.size() + ']');
        }
        while (this.acked < rcvCnt) {
            SessionWriteRequest req = this.msgReqs.pollFirst();
            assert (req != null) : "Missed message [rcvCnt=" + rcvCnt + ", acked=" + this.acked + ", desc=" + this + ']';
            if (req.ackClosure() != null) {
                req.ackClosure().apply(null);
            }
            req.onAckReceived();
            ++this.acked;
        }
    }

    public long acked() {
        return this.acked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onNodeLeft() {
        SessionWriteRequest[] reqs = null;
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            this.nodeLeft = true;
            if (this.reserved) {
                return false;
            }
            if (!this.msgReqs.isEmpty()) {
                reqs = this.msgReqs.toArray(new SessionWriteRequest[this.msgReqs.size()]);
                this.msgReqs.clear();
            }
        }
        if (reqs != null) {
            this.notifyOnNodeLeft(reqs);
        }
        return true;
    }

    public Deque<SessionWriteRequest> messagesRequests() {
        return this.msgReqs;
    }

    public boolean nodeAlive(@Nullable ClusterNode node) {
        return node != null && node.order() == this.node.order();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve() throws InterruptedException {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            long t0 = System.nanoTime();
            while (!this.connected && this.reserved) {
                this.wait(DESC_RESERVATION_TIMEOUT);
                if ((System.nanoTime() - t0) / 1000000L < DESC_RESERVATION_TIMEOUT - 100L) continue;
                this.log.error("Failed to wait for recovery descriptor reservation [desc=" + this + ", ses=" + this.ses + ']');
                return false;
            }
            if (!this.connected) {
                this.reserved = true;
                ++this.reserveCnt;
            }
            return !this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshake(long rcvCnt) {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            if (!this.nodeLeft) {
                this.ackReceived(rcvCnt);
            }
            this.resendCnt = this.msgReqs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            assert (this.reserved) : this;
            assert (!this.connected) : this;
            this.connected = true;
            if (this.handshakeReq != null) {
                IgniteInClosure<Boolean> c = this.handshakeReq.get2();
                assert (c != null);
                c.apply(false);
                this.handshakeReq = null;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connected() {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserved() {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            return this.reserved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long handshakeIndex() {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            return this.handshakeReq != null ? this.handshakeReq.get1() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SessionWriteRequest[] futs = null;
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            this.ses = null;
            this.connected = false;
            if (this.handshakeReq != null) {
                IgniteInClosure<Boolean> c = this.handshakeReq.get2();
                assert (c != null);
                this.handshakeReq = null;
                c.apply(true);
            } else {
                this.reserved = false;
                this.notifyAll();
            }
            if (this.nodeLeft && !this.msgReqs.isEmpty()) {
                futs = this.msgReqs.toArray(new SessionWriteRequest[this.msgReqs.size()]);
                this.msgReqs.clear();
            }
        }
        if (futs != null) {
            this.notifyOnNodeLeft(futs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReserve(long id, IgniteInClosure<Boolean> c) {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            if (this.connected) {
                c.apply(false);
                return false;
            }
            if (this.reserved) {
                if (this.handshakeReq != null) {
                    assert (this.handshakeReq.get1() != null);
                    long id0 = this.handshakeReq.get1();
                    assert (id0 != id) : id0;
                    if (id > id0) {
                        IgniteInClosure<Boolean> c0 = this.handshakeReq.get2();
                        assert (c0 != null);
                        c0.apply(false);
                        this.handshakeReq = new IgniteBiTuple<Long, IgniteInClosure<Boolean>>(id, c);
                    } else {
                        c.apply(false);
                    }
                } else {
                    this.handshakeReq = new IgniteBiTuple<Long, IgniteInClosure<Boolean>>(id, c);
                }
                return false;
            }
            this.reserved = true;
            ++this.reserveCnt;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reserveCount() {
        GridNioRecoveryDescriptor gridNioRecoveryDescriptor = this;
        synchronized (gridNioRecoveryDescriptor) {
            return this.reserveCnt;
        }
    }

    public synchronized GridNioSession session() {
        return this.ses;
    }

    public synchronized void session(GridNioSession ses) {
        this.ses = ses;
    }

    private void notifyOnNodeLeft(SessionWriteRequest[] reqs) {
        IOException e = new IOException("Failed to send message, node has left: " + this.node.id());
        IgniteException cloErr = null;
        for (SessionWriteRequest req : reqs) {
            req.onError(e);
            if (req.ackClosure() == null) continue;
            if (cloErr == null) {
                cloErr = new IgniteException(e);
            }
            req.ackClosure().apply(cloErr);
        }
    }

    public String toString() {
        return S.toString(GridNioRecoveryDescriptor.class, this);
    }
}

