/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class GridNioDelimitedBuffer {
    private final byte[] delim;
    private byte[] data = new byte[16384];
    private int cnt;
    private int idx;

    public GridNioDelimitedBuffer(byte[] delim) {
        assert (delim != null);
        assert (delim.length > 0);
        this.delim = delim;
        this.reset();
    }

    private void reset() {
        this.cnt = 0;
        this.idx = 0;
    }

    @Nullable
    public byte[] read(ByteBuffer buf) {
        while (buf.hasRemaining()) {
            if (this.cnt == this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            byte b = buf.get();
            this.data[this.cnt++] = b;
            if (b == this.delim[this.idx]) {
                ++this.idx;
            } else if (this.idx > 0) {
                int pos = this.cnt - this.idx;
                this.idx = 0;
                for (int i = pos; i < this.cnt; ++i) {
                    if (this.data[pos] == this.delim[this.idx]) {
                        ++pos;
                        ++this.idx;
                        continue;
                    }
                    pos = this.cnt - (i - pos) - 1;
                    this.idx = 0;
                }
            }
            if (this.idx != this.delim.length) continue;
            byte[] bytes2 = Arrays.copyOfRange(this.data, 0, this.cnt - this.delim.length);
            this.reset();
            return bytes2;
        }
        return null;
    }
}

