/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioMessageReaderFactory;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.jetbrains.annotations.Nullable;

public class GridDirectParser
implements GridNioParser {
    static final int MSG_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    static final int READER_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private final IgniteLogger log;
    private final MessageFactory msgFactory;
    private final GridNioMessageReaderFactory readerFactory;

    public GridDirectParser(IgniteLogger log2, MessageFactory msgFactory, GridNioMessageReaderFactory readerFactory) {
        assert (msgFactory != null);
        assert (readerFactory != null);
        this.log = log2;
        this.msgFactory = msgFactory;
        this.readerFactory = readerFactory;
    }

    @Override
    @Nullable
    public Object decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        MessageReader reader = (MessageReader)ses.meta(READER_META_KEY);
        if (reader == null) {
            reader = this.readerFactory.reader(ses, this.msgFactory);
            ses.addMeta(READER_META_KEY, reader);
        }
        Message msg = (Message)ses.removeMeta(MSG_META_KEY);
        try {
            if (msg == null && buf.remaining() >= 2) {
                byte b0 = buf.get();
                byte b1 = buf.get();
                short type = (short)((b1 & 0xFF) << 8 | b0 & 0xFF);
                msg = this.msgFactory.create(type);
            }
            boolean finished = false;
            if (msg != null && buf.hasRemaining()) {
                if (reader != null) {
                    reader.setCurrentReadClass(msg.getClass());
                }
                finished = msg.readFrom(buf, reader);
            }
            if (finished) {
                if (reader != null) {
                    reader.reset();
                }
                return msg;
            }
            ses.addMeta(MSG_META_KEY, msg);
            return null;
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to read message [msg=" + msg + ", buf=" + buf + ", reader=" + reader + ", ses=" + ses + "]", e);
            throw e;
        }
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        throw new UnsupportedEncodingException();
    }
}

