/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.gridfunc.EntryByKeyEvaluationPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformMapView2<K, V, V1>
extends GridSerializableMap<K, V1> {
    private static final long serialVersionUID = 0L;
    private final Map<K, V> map;
    private final IgniteBiClosure<K, V, V1> clos;
    private final IgnitePredicate<? super K>[] preds;
    private IgnitePredicate<Map.Entry<K, V>> entryPred;

    public TransformMapView2(Map<K, V> map2, IgniteBiClosure<K, V, V1> clos, IgnitePredicate<? super K> ... preds) {
        this.map = map2;
        this.clos = clos;
        this.preds = preds;
        this.entryPred = new EntryByKeyEvaluationPredicate<K, V>(preds);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V1>> entrySet() {
        return new GridSerializableSet<Map.Entry<K, V1>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V1>> iterator() {
                return new Iterator<Map.Entry<K, V1>>(){
                    private Iterator<Map.Entry<K, V>> it;
                    {
                        this.it = GridFunc.iterator0(TransformMapView2.this.map.entrySet(), true, TransformMapView2.this.entryPred);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V1> next() {
                        final Map.Entry e = this.it.next();
                        return new Map.Entry<K, V1>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public V1 getValue() {
                                return TransformMapView2.this.clos.apply(e.getKey(), e.getValue());
                            }

                            @Override
                            public V1 setValue(V1 val) {
                                throw new UnsupportedOperationException("Put is not supported for readonly map view.");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                    }
                };
            }

            @Override
            public int size() {
                return F.size(TransformMapView2.this.map.keySet(), TransformMapView2.this.preds);
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Remove is not support for readonly map view.");
            }

            @Override
            public boolean contains(Object o) {
                return F.isAll((Map.Entry)o, TransformMapView2.this.entryPred) && TransformMapView2.this.map.entrySet().contains(o);
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    @Nullable
    public V1 get(Object key) {
        V v;
        if (GridFunc.isAll(key, this.preds) && (v = this.map.get(key)) != null) {
            return this.clos.apply(key, v);
        }
        return null;
    }

    @Override
    @Nullable
    public V1 put(K key, V1 val) {
        throw new UnsupportedOperationException("Put is not supported for readonly map view.");
    }

    @Override
    public V1 remove(Object key) {
        throw new UnsupportedOperationException("Remove is not supported for readonly map view.");
    }

    @Override
    public boolean containsKey(Object key) {
        return GridFunc.isAll(key, this.preds) && this.map.containsKey(key);
    }

    @Override
    public String toString() {
        return S.toString(TransformMapView2.class, this);
    }
}

