/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.gridfunc.EntryByKeyEvaluationPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformMapView<K, V1, V>
extends GridSerializableMap<K, V1> {
    private static final long serialVersionUID = 0L;
    private final Map<K, V> map;
    private final IgniteClosure<V, V1> clos;
    private final boolean hasPred;
    private final IgnitePredicate<? super K>[] preds;
    private IgnitePredicate<Map.Entry<K, V>> entryPred;

    public TransformMapView(Map<K, V> map2, IgniteClosure<V, V1> clos, IgnitePredicate<? super K> ... preds) {
        this.map = map2;
        this.clos = clos;
        this.hasPred = preds != null && preds.length > 0;
        this.preds = preds;
        this.entryPred = new EntryByKeyEvaluationPredicate<K, V>(preds);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V1>> entrySet() {
        return new GridSerializableSet<Map.Entry<K, V1>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V1>> iterator() {
                return new Iterator<Map.Entry<K, V1>>(){
                    private Iterator<Map.Entry<K, V>> iter;
                    {
                        this.iter = GridFunc.iterator0(TransformMapView.this.map.entrySet(), true, TransformMapView.this.entryPred);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V1> next() {
                        final Map.Entry e = this.iter.next();
                        return new Map.Entry<K, V1>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public V1 getValue() {
                                return TransformMapView.this.clos.apply(e.getValue());
                            }

                            @Override
                            public V1 setValue(V1 val) {
                                throw new UnsupportedOperationException("Put is not supported for readonly map view.");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                    }
                };
            }

            @Override
            public int size() {
                return TransformMapView.this.hasPred ? F.size(TransformMapView.this.map.keySet(), TransformMapView.this.preds) : TransformMapView.this.map.size();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Remove is not support for readonly map view.");
            }

            @Override
            public boolean contains(Object o) {
                return F.isAll((Map.Entry)o, TransformMapView.this.entryPred) && TransformMapView.this.map.entrySet().contains(o);
            }

            @Override
            public boolean isEmpty() {
                return TransformMapView.this.hasPred ? !this.iterator().hasNext() : TransformMapView.this.map.isEmpty();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.hasPred ? this.entrySet().isEmpty() : this.map.isEmpty();
    }

    @Override
    @Nullable
    public V1 get(Object key) {
        V v;
        if (GridFunc.isAll(key, this.preds) && (v = this.map.get(key)) != null) {
            return this.clos.apply(v);
        }
        return null;
    }

    @Override
    @Nullable
    public V1 put(K key, V1 val) {
        throw new UnsupportedOperationException("Put is not supported for readonly map view.");
    }

    @Override
    public V1 remove(Object key) {
        throw new UnsupportedOperationException("Remove is not supported for readonly map view.");
    }

    @Override
    public boolean containsKey(Object key) {
        return GridFunc.isAll(key, this.preds) && this.map.containsKey(key);
    }
}

