/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class TransformFilteringIterator<T2, T1>
extends GridIteratorAdapter<T2> {
    private static final long serialVersionUID = 0L;
    private final IgniteClosure<? super T1, T2> clos;
    private final boolean readOnly;
    private final IgnitePredicate<? super T1>[] preds;
    private T1 elem;
    private boolean more;
    private boolean moved;
    private Iterator<? extends T1> iter;

    public TransformFilteringIterator(Iterator<? extends T1> iter2, IgniteClosure<? super T1, T2> clos, boolean readOnly, IgnitePredicate<? super T1> ... preds) {
        this.clos = clos;
        this.readOnly = readOnly;
        this.preds = preds;
        this.iter = iter2;
        this.moved = true;
    }

    @Override
    public boolean hasNextX() {
        if (GridFunc.isEmpty(this.preds)) {
            return this.iter.hasNext();
        }
        if (!this.moved) {
            return this.more;
        }
        this.more = false;
        while (this.iter.hasNext()) {
            this.elem = this.iter.next();
            boolean isAll = true;
            for (IgnitePredicate<T1> ignitePredicate : this.preds) {
                if (ignitePredicate == null || ignitePredicate.apply(this.elem)) continue;
                isAll = false;
                break;
            }
            if (!isAll) continue;
            this.more = true;
            this.moved = false;
            return true;
        }
        this.elem = null;
        return false;
    }

    @Override
    @Nullable
    public T2 nextX() {
        if (GridFunc.isEmpty(this.preds)) {
            return this.clos.apply(this.iter.next());
        }
        if (this.hasNext()) {
            this.moved = true;
            return this.clos.apply(this.elem);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void removeX() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify read-only iter.");
        }
        this.iter.remove();
    }

    public String toString() {
        return S.toString(TransformFilteringIterator.class, this);
    }
}

