/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.GridSerializableIterator;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyCollectionView<T>
extends GridSerializableCollection<T> {
    private static final long serialVersionUID = 0L;
    private final Collection<T> col;
    private final T elem;

    public ReadOnlyCollectionView(@NotNull Collection<T> col, @NotNull T elem2) {
        this.col = col;
        this.elem = elem2;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new GridSerializableIterator<T>(){
            private Iterator<T> it;

            @Override
            public boolean hasNext() {
                return this.it == null || this.it.hasNext();
            }

            @Override
            @Nullable
            public T next() {
                if (this.it == null) {
                    this.it = ReadOnlyCollectionView.this.col.iterator();
                    return ReadOnlyCollectionView.this.elem;
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.col.size() + 1;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Collection && GridFunc.eqNotOrdered(this, (Collection)obj);
    }
}

