/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.gridfunc.EntryByKeyEvaluationPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredicateMapView<K, V>
extends GridSerializableMap<K, V> {
    private static final long serialVersionUID = 5531745605372387948L;
    private final Map<K, V> map;
    private final IgnitePredicate<? super K>[] preds;
    private IgnitePredicate<Map.Entry<K, V>> entryPred;

    public PredicateMapView(Map<K, V> map2, IgnitePredicate<? super K> ... preds) {
        this.map = map2;
        this.preds = preds;
        this.entryPred = new EntryByKeyEvaluationPredicate<K, V>(preds);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new GridSerializableSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return GridFunc.iterator0(PredicateMapView.this.map.entrySet(), false, PredicateMapView.this.entryPred);
            }

            @Override
            public int size() {
                return F.size(PredicateMapView.this.map.keySet(), PredicateMapView.this.preds);
            }

            @Override
            public boolean remove(Object o) {
                return F.isAll((Map.Entry)o, PredicateMapView.this.entryPred) && PredicateMapView.this.map.entrySet().remove(o);
            }

            @Override
            public boolean contains(Object o) {
                return F.isAll((Map.Entry)o, PredicateMapView.this.entryPred) && PredicateMapView.this.map.entrySet().contains(o);
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    @Nullable
    public V get(Object key) {
        return GridFunc.isAll(key, this.preds) ? (V)this.map.get(key) : null;
    }

    @Override
    @Nullable
    public V put(K key, V val) {
        V oldVal = this.get(key);
        if (GridFunc.isAll(key, this.preds)) {
            this.map.put(key, val);
        }
        return oldVal;
    }

    @Override
    public boolean containsKey(Object key) {
        return GridFunc.isAll(key, this.preds) && this.map.containsKey(key);
    }
}

