/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.io.IOException;
import java.util.List;

public abstract class GridTreePrinter<T> {
    public void print(T rootNode, Appendable a) throws IOException {
        this.printTree(rootNode, "", true, a);
    }

    public String print(T rootNode) {
        StringBuilder b = new StringBuilder();
        try {
            this.print(rootNode, b);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return b.toString();
    }

    private void printTree(T treeNode, String prefix, boolean tail, Appendable a) throws IOException {
        List<T> children2 = this.getChildren(treeNode);
        int cnt = children2 == null ? 0 : children2.size();
        a.append(prefix).append(tail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.formatTreeNode(treeNode)).append('\n');
        String childPrefix = prefix + (tail ? "    " : "\u2502   ");
        if (children2 == null) {
            a.append(childPrefix).append("\u2514\u2500\u2500 <list of children is not accessible>\n");
        } else {
            for (int i = 0; i < cnt; ++i) {
                this.printTree(children2.get(i), childPrefix, i == cnt - 1, a);
            }
        }
    }

    protected abstract List<T> getChildren(T var1);

    protected abstract String formatTreeNode(T var1);
}

