/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class GridMetadataAwareAdapter {
    @GridToStringInclude(sensitive=true)
    private Object[] data = null;

    public void copyMeta(GridMetadataAwareAdapter from2) {
        assert (from2 != null);
        this.copyMeta(from2.allMeta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMeta(Object[] data) {
        assert (data != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            if (this.data.length < data.length) {
                this.data = Arrays.copyOf(this.data, data.length);
            }
            for (int k = 0; k < data.length; ++k) {
                if (data[k] == null) continue;
                this.data[k] = data[k];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V addMeta(int key, V val) {
        assert (val != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            if (this.data == null) {
                this.data = new Object[key + 1];
            } else if (this.data.length <= key) {
                this.data = Arrays.copyOf(this.data, key + 1);
            }
            Object old = this.data[key];
            this.data[key] = val;
            return (V)old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V meta(int key) {
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            return (V)(this.data != null && this.data.length > key ? this.data[key] : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V removeMeta(int key) {
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            if (this.data == null || this.data.length <= key) {
                return null;
            }
            Object old = this.data[key];
            this.data[key] = null;
            return (V)old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> boolean removeMeta(int key, V val) {
        assert (val != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            if (this.data == null || this.data.length <= key) {
                return false;
            }
            Object old = this.data[key];
            if (old != null && old.equals(val)) {
                this.data[key] = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Object[] allMeta() {
        Object[] cp;
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            cp = Arrays.copyOf(this.data, this.data.length);
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMeta() {
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            this.data = null;
        }
    }

    public boolean hasMeta(int key) {
        return this.meta(key) != null;
    }

    public <V> boolean hasMeta(int key, V val) {
        V v = this.meta(key);
        return v != null && v.equals(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V putMetaIfAbsent(int key, V val) {
        assert (val != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            V v = this.meta(key);
            if (v == null) {
                return this.addMeta(key, val);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V addMetaIfAbsent(int key, V val) {
        assert (val != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            V v = this.meta(key);
            if (v == null) {
                v = val;
                this.addMeta(key, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V addMetaIfAbsent(int key, @Nullable Callable<V> c) {
        assert (c != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            V v = this.meta(key);
            if (v == null && c != null) {
                try {
                    v = c.call();
                    this.addMeta(key, v);
                }
                catch (Exception e) {
                    throw F.wrap(e);
                }
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> boolean replaceMeta(int key, V curVal, V newVal) {
        assert (newVal != null);
        assert (curVal != null);
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            V val;
            if (this.hasMeta(key) && (val = this.meta(key)) != null && val.equals(curVal)) {
                this.addMeta(key, newVal);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeExternalMeta(ObjectOutput out) throws IOException {
        Object[] cp;
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            cp = Arrays.copyOf(this.data, this.data.length);
        }
        out.writeObject(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readExternalMeta(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] cp = (Object[])in.readObject();
        GridMetadataAwareAdapter gridMetadataAwareAdapter = this;
        synchronized (gridMetadataAwareAdapter) {
            this.data = cp;
        }
    }

    public Object clone() {
        try {
            GridMetadataAwareAdapter clone2 = (GridMetadataAwareAdapter)super.clone();
            clone2.copyMeta(this);
            return clone2;
        }
        catch (CloneNotSupportedException ignore) {
            throw new InternalError();
        }
    }

    public static enum EntryKey {
        CACHE_STORE_MANAGER_KEY(0),
        CACHE_EVICTABLE_ENTRY_KEY(1),
        CACHE_EVICTION_MANAGER_KEY(2);

        private int key;

        private EntryKey(int key) {
            this.key = key;
        }

        public int key() {
            return this.key;
        }
    }
}

