/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryOperationTimedoutException;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IpcSharedMemorySpace
implements Closeable {
    private static final boolean DEBUG = Boolean.getBoolean("IGNITE_IPC_SHMEM_SPACE_DEBUG");
    private final int opSize;
    private final long shmemPtr;
    private final int shmemId;
    private final int semId;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean isReader;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final int writerPid;
    private final int readerPid;
    private final String tokFileName;
    private final IgniteLogger log;

    public IpcSharedMemorySpace(String tokFileName, int writerPid, int readerPid, int size2, boolean reader, IgniteLogger parent) throws IgniteCheckedException {
        assert (size2 > 0) : "Size cannot be less than 1 byte";
        this.log = parent.getLogger(IpcSharedMemorySpace.class);
        this.opSize = size2;
        this.shmemPtr = IpcSharedMemoryUtils.allocateSystemResources(tokFileName, size2, DEBUG && this.log.isDebugEnabled());
        this.shmemId = IpcSharedMemoryUtils.sharedMemoryId(this.shmemPtr);
        this.semId = IpcSharedMemoryUtils.semaphoreId(this.shmemPtr);
        this.isReader = reader;
        this.tokFileName = tokFileName;
        this.readerPid = readerPid;
        this.writerPid = writerPid;
        if (DEBUG && this.log.isDebugEnabled()) {
            this.log.debug("Shared memory space has been created: " + this);
        }
    }

    public IpcSharedMemorySpace(String tokFileName, int writerPid, int readerPid, int size2, boolean reader, int shmemId, IgniteLogger parent) throws IgniteCheckedException {
        assert (size2 > 0) : "Size cannot be less than 1 byte";
        this.log = parent.getLogger(IpcSharedMemorySpace.class);
        this.opSize = size2;
        this.isReader = reader;
        this.shmemId = shmemId;
        this.writerPid = writerPid;
        this.readerPid = readerPid;
        this.tokFileName = tokFileName;
        this.shmemPtr = IpcSharedMemoryUtils.attach(shmemId, DEBUG && this.log.isDebugEnabled());
        this.semId = IpcSharedMemoryUtils.semaphoreId(this.shmemPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len, long timeout) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException {
        assert (buf != null);
        assert (len > 0);
        assert (buf.length >= off + len);
        assert (timeout >= 0L);
        assert (!this.isReader);
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IgniteCheckedException("Shared memory segment has been closed: " + this);
            }
            IpcSharedMemoryUtils.writeSharedMemory(this.shmemPtr, buf, off, len, timeout);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buf, int off, int len, long timeout) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException {
        assert (buf != null);
        assert (len > 0);
        assert (buf.limit() >= off + len);
        assert (timeout >= 0L);
        assert (!this.isReader);
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IgniteCheckedException("Shared memory segment has been closed: " + this);
            }
            IpcSharedMemoryUtils.writeSharedMemoryByteBuffer(this.shmemPtr, buf, off, len, timeout);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len, long timeout) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException {
        assert (buf != null);
        assert (len > 0);
        assert (buf.length >= off + len);
        assert (this.isReader);
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IgniteCheckedException("Shared memory segment has been closed: " + this);
            }
            int n = (int)IpcSharedMemoryUtils.readSharedMemory(this.shmemPtr, buf, off, len, timeout);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, int off, int len, long timeout) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException {
        assert (buf != null);
        assert (len > 0);
        assert (buf.capacity() >= off + len);
        assert (this.isReader);
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IgniteCheckedException("Shared memory segment has been closed: " + this);
            }
            int n = (int)IpcSharedMemoryUtils.readSharedMemoryByteBuffer(this.shmemPtr, buf, off, len, timeout);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.close0(false);
    }

    public void forceClose() {
        this.close0(true);
    }

    public int sharedMemoryId() {
        return this.shmemId;
    }

    public int semaphoreId() {
        return this.semId;
    }

    private void close0(boolean force) {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        IpcSharedMemoryUtils.ipcClose(this.shmemPtr);
        this.lock.writeLock().lock();
        try {
            IpcSharedMemoryUtils.freeSystemResources(this.tokFileName, this.shmemPtr, force);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (DEBUG && this.log.isDebugEnabled()) {
            this.log.debug("Shared memory space has been closed: " + this);
        }
    }

    public int unreadCount() throws IgniteCheckedException {
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IgniteCheckedException("Shared memory segment has been closed: " + this);
            }
            int n = IpcSharedMemoryUtils.unreadCount(this.shmemPtr);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long sharedMemPointer() {
        return this.shmemPtr;
    }

    public int readerPid() {
        return this.readerPid;
    }

    public int writerPid() {
        return this.writerPid;
    }

    public int otherPartyPid() {
        return this.isReader ? this.writerPid : this.readerPid;
    }

    public String tokenFileName() {
        return this.tokFileName;
    }

    public int size() {
        return this.opSize;
    }

    public String toString() {
        return S.toString(IpcSharedMemorySpace.class, this, "closed", (Object)this.closed.get());
    }
}

