/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryInitRequest;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryInitResponse;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryInputStream;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryNativeLoader;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryOutputStream;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemorySpace;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IpcSharedMemoryClientEndpoint
implements IpcEndpoint {
    private final IpcSharedMemorySpace inSpace;
    private final IpcSharedMemorySpace outSpace;
    private final IpcSharedMemoryInputStream in;
    private final IpcSharedMemoryOutputStream out;
    private boolean checkIn = true;
    private boolean checkOut = true;
    private final Thread checker;
    private final IgniteLogger log;

    public IpcSharedMemoryClientEndpoint(IpcSharedMemorySpace inSpace, IpcSharedMemorySpace outSpace, IgniteLogger parent) {
        assert (inSpace != null);
        assert (outSpace != null);
        this.log = parent.getLogger(IpcSharedMemoryClientEndpoint.class);
        this.inSpace = inSpace;
        this.outSpace = outSpace;
        this.in = new IpcSharedMemoryInputStream(inSpace);
        this.out = new IpcSharedMemoryOutputStream(outSpace);
        this.checker = null;
    }

    public IpcSharedMemoryClientEndpoint(int port, IgniteLogger parent) throws IgniteCheckedException {
        this(port, 0, parent);
    }

    public IpcSharedMemoryClientEndpoint(int port, int timeout, IgniteLogger parent) throws IgniteCheckedException {
        assert (port > 0);
        assert (port < 65535);
        this.log = parent.getLogger(IpcSharedMemoryClientEndpoint.class);
        IpcSharedMemorySpace inSpace = null;
        IpcSharedMemorySpace outSpace = null;
        Socket sock = new Socket();
        Exception err2 = null;
        boolean clear2 = true;
        try {
            IpcSharedMemoryNativeLoader.load(this.log);
            sock.connect(new InetSocketAddress("127.0.0.1", port), timeout);
            ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
            int pid = IpcSharedMemoryUtils.pid();
            out.writeObject(new IpcSharedMemoryInitRequest(pid));
            ObjectInputStream in = new ObjectInputStream(sock.getInputStream());
            IpcSharedMemoryInitResponse res = (IpcSharedMemoryInitResponse)in.readObject();
            err2 = res.error();
            if (err2 == null) {
                String inTokFileName = res.inTokenFileName();
                assert (inTokFileName != null);
                inSpace = new IpcSharedMemorySpace(inTokFileName, res.pid(), pid, res.size(), true, res.inSharedMemoryId(), this.log);
                String outTokFileName = res.outTokenFileName();
                assert (outTokFileName != null);
                outSpace = new IpcSharedMemorySpace(outTokFileName, pid, res.pid(), res.size(), false, res.outSharedMemoryId(), this.log);
                out.writeBoolean(true);
                out.flush();
                clear2 = false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw IpcSharedMemoryUtils.linkError(e);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to connect shared memory endpoint to port (is shared memory server endpoint up and running?): " + port, e);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IgniteCheckedException(e);
        }
        finally {
            U.closeQuiet(sock);
            if (clear2) {
                if (inSpace != null) {
                    inSpace.forceClose();
                }
                if (outSpace != null) {
                    outSpace.forceClose();
                }
            }
        }
        if (err2 != null) {
            throw new IgniteCheckedException(err2);
        }
        this.inSpace = inSpace;
        this.outSpace = outSpace;
        this.in = new IpcSharedMemoryInputStream(inSpace);
        this.out = new IpcSharedMemoryOutputStream(outSpace);
        this.checker = new Thread(new AliveChecker());
        this.checker.setDaemon(true);
        this.checker.start();
    }

    @Override
    public InputStream inputStream() {
        return this.in;
    }

    @Override
    public OutputStream outputStream() {
        return this.out;
    }

    @Override
    public void close() {
        U.closeQuiet(this.in);
        U.closeQuiet(this.out);
        this.stopChecker();
    }

    public void forceClose() {
        this.in.forceClose();
        this.out.forceClose();
        this.stopChecker();
    }

    private void stopChecker() {
        if (this.checker != null) {
            this.checker.interrupt();
            try {
                this.checker.join();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    boolean checkOtherPartyAlive() {
        File tokFile;
        if (this.checkIn && !(tokFile = new File(this.inSpace.tokenFileName())).exists()) {
            this.checkIn = false;
        }
        if (this.checkOut && !(tokFile = new File(this.outSpace.tokenFileName())).exists()) {
            this.checkOut = false;
        }
        if (!this.checkIn && !this.checkOut) {
            return false;
        }
        if (!IpcSharedMemoryUtils.alive(this.inSpace.otherPartyPid())) {
            U.warn(this.log, "Remote process is considered to be dead (shared memory space will be forcibly closed): " + this.inSpace.otherPartyPid());
            this.closeSpace(this.inSpace);
            this.closeSpace(this.outSpace);
            return false;
        }
        return true;
    }

    IpcSharedMemorySpace inSpace() {
        return this.inSpace;
    }

    IpcSharedMemorySpace outSpace() {
        return this.outSpace;
    }

    private void closeSpace(IpcSharedMemorySpace space) {
        assert (space != null);
        space.forceClose();
        File tokFile = new File(space.tokenFileName());
        IpcSharedMemoryUtils.freeSystemResources(tokFile.getAbsolutePath(), space.size());
        tokFile.delete();
    }

    public String toString() {
        return S.toString(IpcSharedMemoryClientEndpoint.class, this);
    }

    private class AliveChecker
    implements Runnable {
        private static final long CHECK_FREQ = 10000L;

        private AliveChecker() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignored) {
                    return;
                }
                if (IpcSharedMemoryClientEndpoint.this.checkOtherPartyAlive()) continue;
                return;
            }
        }
    }
}

