/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.loopback.IpcClientTcpEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryClientEndpoint;
import org.apache.ignite.internal.util.typedef.internal.A;

public class IpcEndpointFactory {
    public static IpcEndpoint connectEndpoint(String endpointAddr, IgniteLogger log2) throws IgniteCheckedException {
        int port;
        A.notNull(endpointAddr, "endpointAddr");
        String[] split2 = endpointAddr.split(":");
        if (split2.length == 2) {
            try {
                port = Integer.parseInt(split2[1]);
            }
            catch (NumberFormatException e) {
                throw new IgniteCheckedException("Failed to parse port number: " + endpointAddr, e);
            }
        } else {
            port = -1;
        }
        return "shmem".equalsIgnoreCase(split2[0]) ? IpcEndpointFactory.connectSharedMemoryEndpoint(port > 0 ? port : 10500, log2) : IpcEndpointFactory.connectTcpEndpoint(split2[0], port > 0 ? port : 10500);
    }

    private static IpcEndpoint connectTcpEndpoint(String host, int port) throws IgniteCheckedException {
        return new IpcClientTcpEndpoint(host, port);
    }

    private static IpcEndpoint connectSharedMemoryEndpoint(int port, IgniteLogger log2) throws IgniteCheckedException {
        return new IpcSharedMemoryClientEndpoint(port, log2);
    }
}

