/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridByteArrayOutputStream
extends OutputStream {
    private byte[] buf;
    private int cnt;

    public GridByteArrayOutputStream() {
        this(32);
    }

    public GridByteArrayOutputStream(int size2) {
        this(size2, 0);
    }

    public GridByteArrayOutputStream(int size2, int off) {
        if (size2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size2);
        }
        if (off > size2) {
            throw new IllegalArgumentException("Invalid offset: " + off);
        }
        this.buf = new byte[size2];
        this.cnt = off;
    }

    @Override
    public void write(int b) {
        int newCnt = this.cnt + 1;
        if (newCnt > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newCnt));
        }
        this.buf[this.cnt] = (byte)b;
        this.cnt = newCnt;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newCnt = this.cnt + len;
        if (newCnt > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newCnt));
        }
        U.arrayCopy(b, off, this.buf, this.cnt, len);
        this.cnt = newCnt;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.cnt);
    }

    public void reset() {
        this.cnt = 0;
    }

    public byte[] internalArray() {
        return this.buf;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.cnt);
    }

    public int size() {
        return this.cnt;
    }

    public String toString() {
        return S.toString(GridByteArrayOutputStream.class, this);
    }
}

