/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class CountDownFuture
extends GridFutureAdapter<Void> {
    private AtomicInteger remaining;
    private AtomicReference<Exception> errCollector;

    public CountDownFuture(int cnt) {
        this.remaining = new AtomicInteger(cnt);
        this.errCollector = new AtomicReference();
    }

    @Override
    public boolean onDone(@Nullable Void res, @Nullable Throwable err2) {
        int left;
        boolean done;
        if (err2 != null) {
            this.addError(err2);
        }
        boolean bl = done = (left = this.remaining.decrementAndGet()) == 0 && super.onDone(res, this.errCollector.get());
        if (done) {
            this.afterDone();
        }
        return done;
    }

    protected void afterDone() {
    }

    private void addError(Throwable err2) {
        Exception ex = this.errCollector.get();
        if (ex == null) {
            IgniteCheckedException compound = new IgniteCheckedException("Compound exception for CountDownFuture.");
            Exception exception = ex = this.errCollector.compareAndSet(null, compound) ? compound : this.errCollector.get();
        }
        assert (ex != null);
        ex.addSuppressed(err2);
    }
}

