/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class UUIDCollectionMessage
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=UUID.class)
    private Collection<UUID> uuids;

    public UUIDCollectionMessage() {
    }

    public UUIDCollectionMessage(Collection<UUID> uuids) {
        this.uuids = uuids;
    }

    public static UUIDCollectionMessage of(UUID ... uuids) {
        if (uuids == null || uuids.length == 0) {
            return null;
        }
        List<UUID> list2 = uuids.length == 1 ? Collections.singletonList(uuids[0]) : Arrays.asList(uuids);
        return new UUIDCollectionMessage(list2);
    }

    public Collection<UUID> uuids() {
        return this.uuids;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("uuids", this.uuids, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.uuids = reader.readCollection("uuids", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UUIDCollectionMessage.class);
    }

    @Override
    public short directType() {
        return 115;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UUIDCollectionMessage that = (UUIDCollectionMessage)o;
        return this.uuids == that.uuids || this.uuids != null && this.uuids.equals(that.uuids);
    }

    public int hashCode() {
        return this.uuids != null ? this.uuids.hashCode() : 0;
    }

    public String toString() {
        return S.toString(UUIDCollectionMessage.class, this, "uuidsSize", this.uuids == null ? null : Integer.valueOf(this.uuids.size()));
    }
}

