/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;

public class StripedExecutor
implements ExecutorService {
    private final Stripe[] stripes;
    private final long[] completedCntrs;
    private final IgniteLogger log;

    public StripedExecutor(int cnt, String igniteInstanceName, String poolName, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
        this(cnt, igniteInstanceName, poolName, log2, errHnd, false, gridWorkerLsnr);
    }

    public StripedExecutor(int cnt, String igniteInstanceName, String poolName, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, boolean stealTasks, GridWorkerListener gridWorkerLsnr) {
        A.ensure(cnt > 0, "cnt > 0");
        boolean success2 = false;
        this.stripes = new Stripe[cnt];
        this.completedCntrs = new long[cnt];
        Arrays.fill(this.completedCntrs, -1L);
        this.log = log2;
        try {
            int i;
            for (i = 0; i < cnt; ++i) {
                this.stripes[i] = stealTasks ? new StripeConcurrentQueue(igniteInstanceName, poolName, i, log2, this.stripes, errHnd, gridWorkerLsnr) : new StripeConcurrentQueue(igniteInstanceName, poolName, i, log2, errHnd, gridWorkerLsnr);
            }
            for (i = 0; i < cnt; ++i) {
                this.stripes[i].start();
            }
            success2 = true;
        }
        catch (Error | RuntimeException e) {
            U.error(log2, "Failed to initialize striped pool.", e);
            throw e;
        }
        finally {
            if (!success2) {
                for (Stripe stripe : this.stripes) {
                    U.cancel(stripe);
                }
                for (Stripe stripe : this.stripes) {
                    U.join(stripe, log2);
                }
            }
        }
    }

    public void checkStarvation() {
        for (int i = 0; i < this.stripes.length; ++i) {
            Stripe stripe = this.stripes[i];
            long completedCnt = stripe.completedCnt;
            boolean active = stripe.active;
            if (this.completedCntrs[i] != -1L && this.completedCntrs[i] == completedCnt && active) {
                boolean deadlockPresent = U.deadlockPresent();
                GridStringBuilder sb = new GridStringBuilder();
                sb.a(">>> Possible starvation in striped pool.").a(U.nl()).a("    Thread name: ").a(stripe.thread.getName()).a(U.nl()).a("    Queue: ").a(stripe.queueToString()).a(U.nl()).a("    Deadlock: ").a(deadlockPresent).a(U.nl()).a("    Completed: ").a(completedCnt).a(U.nl());
                U.printStackTrace(stripe.thread.getId(), sb);
                String msg = sb.toString();
                U.warn(this.log, msg);
            }
            if (!active && completedCnt <= 0L) continue;
            this.completedCntrs[i] = completedCnt;
        }
    }

    public int stripes() {
        return this.stripes.length;
    }

    public void execute(int idx, Runnable cmd) {
        if (idx == -1) {
            this.execute(cmd);
        } else {
            assert (idx >= 0) : idx;
            this.stripes[idx % this.stripes.length].execute(cmd);
        }
    }

    @Override
    public void shutdown() {
        this.signalStop();
    }

    @Override
    public void execute(@NotNull Runnable cmd) {
        this.stripes[ThreadLocalRandom.current().nextInt(this.stripes.length)].execute(cmd);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.signalStop();
        return Collections.emptyList();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.awaitStop();
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (Stripe stripe : this.stripes) {
            if (stripe == null || !stripe.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTerminated() {
        for (Stripe stripe : this.stripes) {
            if (stripe.thread.getState() == Thread.State.TERMINATED) continue;
            return false;
        }
        return true;
    }

    public void stop() {
        this.signalStop();
        this.awaitStop();
    }

    private void signalStop() {
        for (Stripe stripe : this.stripes) {
            U.cancel(stripe);
        }
    }

    private void awaitStop() {
        for (Stripe stripe : this.stripes) {
            U.join(stripe, this.log);
        }
    }

    public int queueSize() {
        int size2 = 0;
        for (Stripe stripe : this.stripes) {
            size2 += stripe.queueSize();
        }
        return size2;
    }

    public long completedTasks() {
        long cnt = 0L;
        for (Stripe stripe : this.stripes) {
            cnt += stripe.completedCnt;
        }
        return cnt;
    }

    public long[] stripesCompletedTasks() {
        long[] res = new long[this.stripes()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].completedCnt;
        }
        return res;
    }

    public boolean[] stripesActiveStatuses() {
        boolean[] res = new boolean[this.stripes()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].active;
        }
        return res;
    }

    public int activeStripesCount() {
        int res = 0;
        for (boolean status : this.stripesActiveStatuses()) {
            if (!status) continue;
            ++res;
        }
        return res;
    }

    public int[] stripesQueueSizes() {
        int[] res = new int[this.stripes()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].queueSize();
        }
        return res;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task2, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(StripedExecutor.class, this);
    }

    private static class StripeConcurrentBlockingQueue
    extends Stripe {
        private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

        public StripeConcurrentBlockingQueue(String igniteInstanceName, String poolName, int idx, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
            super(igniteInstanceName, poolName, idx, log2, errHnd, gridWorkerLsnr);
        }

        @Override
        Runnable take() throws InterruptedException {
            return this.queue.take();
        }

        @Override
        void execute(Runnable cmd) {
            this.queue.add(cmd);
        }

        @Override
        int queueSize() {
            return this.queue.size();
        }

        @Override
        String queueToString() {
            return String.valueOf(this.queue);
        }

        @Override
        public String toString() {
            return S.toString(StripeConcurrentBlockingQueue.class, this, super.toString());
        }
    }

    private static class StripeConcurrentQueueNoPark
    extends Stripe {
        private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

        public StripeConcurrentQueueNoPark(String igniteInstanceName, String poolName, int idx, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
            super(igniteInstanceName, poolName, idx, log2, errHnd, gridWorkerLsnr);
        }

        @Override
        Runnable take() {
            Runnable r;
            while ((r = this.queue.poll()) == null) {
            }
            return r;
        }

        @Override
        void execute(Runnable cmd) {
            this.queue.add(cmd);
        }

        @Override
        int queueSize() {
            return this.queue.size();
        }

        @Override
        String queueToString() {
            return String.valueOf(this.queue);
        }

        @Override
        public String toString() {
            return S.toString(StripeConcurrentQueueNoPark.class, this, super.toString());
        }
    }

    private static class StripeConcurrentQueue
    extends Stripe {
        private static final int IGNITE_TASKS_STEALING_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_DATA_STREAMING_EXECUTOR_SERVICE_TASKS_STEALING_THRESHOLD", 4);
        private final Queue<Runnable> queue;
        @GridToStringExclude
        private final Stripe[] others;
        private volatile boolean parked;

        StripeConcurrentQueue(String igniteInstanceName, String poolName, int idx, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
            this(igniteInstanceName, poolName, idx, log2, null, errHnd, gridWorkerLsnr);
        }

        StripeConcurrentQueue(String igniteInstanceName, String poolName, int idx, IgniteLogger log2, Stripe[] others, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
            super(igniteInstanceName, poolName, idx, log2, errHnd, gridWorkerLsnr);
            this.others = others;
            this.queue = others == null ? new ConcurrentLinkedQueue() : new ConcurrentLinkedDeque();
        }

        @Override
        Runnable take() throws InterruptedException {
            Runnable r;
            for (int i = 0; i < 2048; ++i) {
                r = this.queue.poll();
                if (r == null) continue;
                return r;
            }
            this.parked = true;
            try {
                do {
                    if ((r = this.queue.poll()) != null) {
                        Runnable i = r;
                        return i;
                    }
                    if (this.others != null) {
                        int init2;
                        int len = this.others.length;
                        int cur = init2 = ThreadLocalRandom.current().nextInt(len);
                        do {
                            Deque queue;
                            if (cur == this.idx || (queue = (Deque)((StripeConcurrentQueue)this.others[cur]).queue).size() <= IGNITE_TASKS_STEALING_THRESHOLD || (r = (Runnable)queue.pollLast()) == null) continue;
                            Runnable runnable = r;
                            return runnable;
                        } while ((cur = (cur + 1) % len) != init2);
                    }
                    LockSupport.park();
                } while (!Thread.interrupted());
                throw new InterruptedException();
            }
            finally {
                this.parked = false;
            }
        }

        @Override
        void execute(Runnable cmd) {
            this.queue.add(cmd);
            if (this.parked) {
                LockSupport.unpark(this.thread);
            }
            if (this.others != null && this.queueSize() > IGNITE_TASKS_STEALING_THRESHOLD) {
                for (Stripe other : this.others) {
                    if (!((StripeConcurrentQueue)other).parked) continue;
                    LockSupport.unpark(other.thread);
                }
            }
        }

        @Override
        String queueToString() {
            return String.valueOf(this.queue);
        }

        @Override
        int queueSize() {
            return this.queue.size();
        }

        @Override
        public String toString() {
            return S.toString(StripeConcurrentQueue.class, this, super.toString());
        }
    }

    private static abstract class Stripe
    extends GridWorker {
        private final String igniteInstanceName;
        protected final int idx;
        private final IgniteLogger log;
        private volatile long completedCnt;
        private volatile boolean active;
        protected Thread thread;
        private IgniteInClosure<Throwable> errHnd;

        public Stripe(String igniteInstanceName, String poolName, int idx, IgniteLogger log2, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr) {
            super(igniteInstanceName, poolName + "-stripe-" + idx, log2, gridWorkerLsnr);
            this.igniteInstanceName = igniteInstanceName;
            this.idx = idx;
            this.log = log2;
            this.errHnd = errHnd;
        }

        void start() {
            this.thread = new IgniteThread(this.igniteInstanceName, this.name(), this, -1, this.idx, -1);
            this.thread.start();
        }

        @Override
        public void body() {
            while (!this.isCancelled()) {
                try {
                    Runnable cmd;
                    this.blockingSectionBegin();
                    try {
                        cmd = this.take();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (cmd != null) {
                        this.active = true;
                        this.updateHeartbeat();
                        try {
                            cmd.run();
                        }
                        finally {
                            this.active = false;
                            ++this.completedCnt;
                        }
                    }
                    this.onIdle();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Throwable e) {
                    this.errHnd.apply(e);
                    U.error(this.log, "Failed to execute runnable.", e);
                }
            }
            if (!this.isCancelled) {
                this.errHnd.apply(new IllegalStateException("Thread " + Thread.currentThread().getName() + " is terminated unexpectedly"));
            }
        }

        abstract void execute(Runnable var1);

        abstract Runnable take() throws InterruptedException;

        abstract int queueSize();

        abstract String queueToString();

        @Override
        public String toString() {
            return S.toString(Stripe.class, this);
        }
    }
}

