/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.management.CompilationMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskCancelledException;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.compute.ComputeTaskTimeoutException;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.compute.ComputeTaskCancelledCheckedException;
import org.apache.ignite.internal.compute.ComputeTaskTimeoutCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.mxbean.IgniteStandardMXBean;
import org.apache.ignite.internal.processors.cache.CacheClassLoaderMarker;
import org.apache.ignite.internal.processors.cache.GridCacheAttributes;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.ClassCache;
import org.apache.ignite.internal.util.GridClassLoaderCache;
import org.apache.ignite.internal.util.GridClientByteUtils;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridLeanIdentitySet;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUuidCache;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.io.GridFilenameUtils;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryNativeLoader;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionHeuristicException;
import org.apache.ignite.transactions.TransactionOptimisticException;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public abstract class IgniteUtils {
    private static final long GB = 0x40000000L;
    public static final Long DFLT_MIN_CHECKPOINTING_PAGE_BUFFER_SIZE;
    public static final Long DFLT_MAX_CHECKPOINTING_PAGE_BUFFER_SIZE;
    private static final boolean UNSAFE_BYTE_ARR_CP;
    private static final Method CTOR_FACTORY;
    private static final Object SUN_REFLECT_FACTORY;
    private static final Constructor OBJECT_CTOR;
    private static final Map<Integer, String> GRID_EVT_NAMES;
    private static final int[] GRID_EVTS;
    public static final int[] EMPTY_INTS;
    public static final long[] EMPTY_LONGS;
    public static final Field[] EMPTY_FIELDS;
    private static final String NL;
    public static final String DFLT_USER_VERSION = "0";
    private static final ConcurrentMap<String, IgniteBiTuple<Class<?>, Collection<Field>>> p2pFields;
    private static final String HTTPS_PROTOCOL = "TLS";
    private static final String DEFAULT_WORK_DIR = "work";
    private static Pattern MBEAN_CACHE_NAME_PATTERN;
    private static volatile GridTuple<String> ggHome;
    private static String osJdkStr;
    private static String osStr;
    private static String jdkStr;
    private static boolean win95;
    private static boolean win98;
    private static boolean winNt;
    private static boolean winVista;
    private static boolean win7;
    private static boolean win8;
    private static boolean win81;
    private static boolean unknownWin;
    private static boolean win2k;
    private static boolean winXp;
    private static boolean win2003;
    private static boolean win2008;
    private static boolean unix;
    private static boolean solaris;
    private static boolean linux;
    private static boolean netware;
    private static boolean mac;
    private static boolean redHat;
    private static boolean sparc;
    private static boolean x86;
    private static String osName;
    private static String osVer;
    private static String osArch;
    private static String javaRtName;
    private static String javaRtVer;
    private static String jdkVendor;
    private static String jdkName;
    private static String jdkVer;
    private static String jvmSpecName;
    private static String jvmImplVer;
    private static String jvmImplVendor;
    private static String jvmImplName;
    private static boolean jvm32Bit;
    public static final String JMX_DOMAIN;
    public static final byte[] IGNITE_HEADER;
    private static final int BUF_SIZE = 4096;
    private static final int MASK = 15;
    private static final SimpleDateFormat LONG_DATE_FMT;
    private static final SimpleDateFormat SHORT_DATE_FMT;
    private static final SimpleDateFormat DEBUG_DATE_FMT;
    private static InetAddress locHost;
    static volatile long curTimeMillis;
    private static final Map<String, Class<?>> primitiveMap;
    private static final Map<Class<?>, Class<?>> boxedClsMap;
    private static final ClassLoader gridClassLoader;
    public static final String MAC_INVALID_ARG_MSG = "On MAC OS you may have too many file descriptors open (simple restart usually solves the issue)";
    public static final String IGNITE_LOG_DIR;
    public static final String IGNITE_WORK_DIR;
    private static final Random RND;
    private static Thread timer;
    static int gridCnt;
    static final Object mux;
    private static final Map<Class<? extends IgniteCheckedException>, C1<IgniteCheckedException, IgniteException>> exceptionConverters;
    private static volatile IgniteBiTuple<Collection<String>, Collection<String>> cachedLocalAddr;
    private static volatile IgniteBiTuple<Collection<String>, Collection<String>> cachedLocalAddrAllHostNames;
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<String, Class>> classCache;
    private static volatile Boolean hasShmem;
    private static Method hashCodeMtd;
    private static Method equalsMtd;
    private static Method toStringMtd;
    public static final String LOC_IGNITE_NAME_EMPTY;
    private static final ThreadLocal<String> LOC_IGNITE_NAME;
    public static boolean IGNITE_MBEANS_DISABLED;
    public static boolean IGNITE_TEST_FEATURES_ENABLED;
    private static final boolean assertionsEnabled;
    private static final URL[] EMPTY_URL_ARR;
    private static final Class bltClsLdrCls;
    private static final Field urlClsLdrField;
    private static boolean devOnlyLogDisabled;
    private static Class clsURLClassPath;
    private static Method mthdURLClassPathGetUrls;

    public static C1<IgniteCheckedException, IgniteException> getExceptionConverter(Class<? extends IgniteCheckedException> clazz2) {
        return exceptionConverters.get(clazz2);
    }

    private static Map<Class<? extends IgniteCheckedException>, C1<IgniteCheckedException, IgniteException>> exceptionConverters() {
        HashMap<Class<? extends IgniteCheckedException>, C1<IgniteCheckedException, IgniteException>> m = new HashMap<Class<? extends IgniteCheckedException>, C1<IgniteCheckedException, IgniteException>>();
        m.put(IgniteInterruptedCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new IgniteInterruptedException(e.getMessage(), (InterruptedException)e.getCause());
            }
        });
        m.put(IgniteFutureCancelledCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new IgniteFutureCancelledException(e.getMessage(), e);
            }
        });
        m.put(IgniteFutureTimeoutCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new IgniteFutureTimeoutException(e.getMessage(), e);
            }
        });
        m.put(ClusterGroupEmptyCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new ClusterGroupEmptyException(e.getMessage(), e);
            }
        });
        m.put(ClusterTopologyCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                ClusterTopologyException topEx = new ClusterTopologyException(e.getMessage(), e);
                ClusterTopologyCheckedException checked = (ClusterTopologyCheckedException)e;
                if (checked.retryReadyFuture() != null) {
                    topEx.retryReadyFuture(new IgniteFutureImpl(checked.retryReadyFuture()));
                }
                return topEx;
            }
        });
        m.put(IgniteDeploymentCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new IgniteDeploymentException(e.getMessage(), e);
            }
        });
        m.put(ComputeTaskTimeoutCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new ComputeTaskTimeoutException(e.getMessage(), e);
            }
        });
        m.put(ComputeTaskCancelledCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new ComputeTaskCancelledException(e.getMessage(), e);
            }
        });
        m.put(IgniteTxRollbackCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new TransactionRollbackException(e.getMessage(), e);
            }
        });
        m.put(IgniteTxHeuristicCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new TransactionHeuristicException(e.getMessage(), e);
            }
        });
        m.put(IgniteTxTimeoutCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                if (e.getCause() instanceof TransactionDeadlockException) {
                    return new TransactionTimeoutException(e.getMessage(), e.getCause());
                }
                return new TransactionTimeoutException(e.getMessage(), e);
            }
        });
        m.put(IgniteTxOptimisticCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new TransactionOptimisticException(e.getMessage(), e);
            }
        });
        m.put(IgniteClientDisconnectedCheckedException.class, new C1<IgniteCheckedException, IgniteException>(){

            @Override
            public IgniteException apply(IgniteCheckedException e) {
                return new IgniteClientDisconnectedException(((IgniteClientDisconnectedCheckedException)e).reconnectFuture(), e.getMessage(), e);
            }
        });
        return m;
    }

    public static List<PluginProvider> allPluginProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<List<PluginProvider>>(){

            @Override
            public List<PluginProvider> run() {
                ArrayList<PluginProvider> providers = new ArrayList<PluginProvider>();
                ServiceLoader<PluginProvider> ldr = ServiceLoader.load(PluginProvider.class);
                for (PluginProvider provider : ldr) {
                    providers.add(provider);
                }
                return providers;
            }
        });
    }

    public static Exception convertExceptionNoWrap(IgniteCheckedException e) {
        C1<IgniteCheckedException, IgniteException> converter = exceptionConverters.get(e.getClass());
        if (converter != null) {
            return (Exception)converter.apply(e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (Exception)e.getCause();
        }
        return e;
    }

    public static IgniteException convertException(IgniteCheckedException e) {
        C1<IgniteCheckedException, IgniteException> converter;
        IgniteClientDisconnectedException e0 = e.getCause(IgniteClientDisconnectedException.class);
        if (e0 != null) {
            assert (e0.reconnectFuture() != null) : e0;
            throw e0;
        }
        IgniteClientDisconnectedCheckedException disconnectedErr = e.getCause(IgniteClientDisconnectedCheckedException.class);
        if (disconnectedErr != null) {
            assert (disconnectedErr.reconnectFuture() != null) : disconnectedErr;
            e = disconnectedErr;
        }
        if ((converter = exceptionConverters.get(e.getClass())) != null) {
            return (IgniteException)converter.apply(e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (IgniteException)e.getCause();
        }
        return new IgniteException(e.getMessage(), e);
    }

    public static long currentTimeMillis() {
        return curTimeMillis;
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static int ceilPow2(int v) {
        int i = v - 1;
        return Integer.highestOneBit(i) << 1 - (i >>> 30 ^ v >> 31);
    }

    public static boolean isPow2(int i) {
        return i > 0 && (i & i - 1) == 0;
    }

    @Nullable
    public static Method ctorFactory() {
        return CTOR_FACTORY;
    }

    public static Constructor objectConstructor() {
        return OBJECT_CTOR;
    }

    @Nullable
    public static Object sunReflectionFactory() {
        return SUN_REFLECT_FACTORY;
    }

    public static String gridEventName(int type) {
        String name = GRID_EVT_NAMES.get(type);
        return name != null ? name : Integer.toString(type);
    }

    public static int[] gridEvents(final int ... excl) {
        if (F.isEmpty(excl)) {
            return GRID_EVTS;
        }
        List<Integer> evts = IgniteUtils.toIntList(GRID_EVTS, new P1<Integer>(){

            @Override
            public boolean apply(Integer i) {
                return !IgniteUtils.containsIntArray(excl, i);
            }
        });
        return IgniteUtils.toIntArray(evts);
    }

    public static boolean discoOrdered(DiscoverySpi discoSpi) {
        DiscoverySpiOrderSupport ann = U.getAnnotation(discoSpi.getClass(), DiscoverySpiOrderSupport.class);
        return ann != null && ann.value();
    }

    public static boolean relaxDiscoveryOrdered() {
        return "true".equalsIgnoreCase(System.getProperty("IGNITE_NO_DISCO_ORDER"));
    }

    @Deprecated
    public static void debug(Object msg) {
        X.error(IgniteUtils.debugPrefix() + msg, new Object[0]);
    }

    @Deprecated
    public static void debugx(String msg) {
        X.printerrln(IgniteUtils.debugPrefix() + msg, new Object[0]);
    }

    @Deprecated
    public static void debug(IgniteLogger log2, String msg) {
        log2.info(msg);
    }

    @Deprecated
    public static void dumpStack() {
        IgniteUtils.dumpStack("Dumping stack.");
    }

    @Deprecated
    public static void dumpStack(String msg) {
        new Exception(IgniteUtils.debugPrefix() + msg).printStackTrace(System.err);
    }

    public static void dumpStack(@Nullable IgniteLogger log2, String msg) {
        U.error(log2, "Dumping stack.", new Exception(msg));
    }

    @Deprecated
    public static void dumpStack(String msg, PrintStream out) {
        new Exception(msg).printStackTrace(out);
    }

    @Deprecated
    public static void debugStack(IgniteLogger log2, String msg) {
        log2.error(msg, new Exception(IgniteUtils.debugPrefix() + msg));
    }

    private static String debugPrefix() {
        return '<' + DEBUG_DATE_FMT.format(new Date(System.currentTimeMillis())) + "><DEBUG><" + Thread.currentThread().getName() + '>' + ' ';
    }

    public static void debugHeapUsage() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        X.println('<' + DEBUG_DATE_FMT.format(new Date(System.currentTimeMillis())) + "><DEBUG><" + Thread.currentThread().getName() + "> Heap stats [free=" + runtime.freeMemory() / 0x100000L + "M, total=" + runtime.totalMemory() / 0x100000L + "M]", new Object[0]);
    }

    public static double heapSize(ClusterNode node, int precision) {
        return IgniteUtils.heapSize(Collections.singleton(node), precision);
    }

    public static double heapSize(Iterable<ClusterNode> nodes2, int precision) {
        double heap = 0.0;
        for (ClusterNode n : IgniteUtils.nodesPerJvm(nodes2)) {
            ClusterMetrics m = n.metrics();
            heap += (double)Math.max(m.getHeapMemoryInitialized(), m.getHeapMemoryMaximum());
        }
        return IgniteUtils.roundedHeapSize(heap, precision);
    }

    public static double offheapSize(Iterable<ClusterNode> nodes2, int precision) {
        double totalOffheap = 0.0;
        for (ClusterNode n : IgniteUtils.nodesPerJvm(nodes2)) {
            Long val = (Long)n.attribute("org.apache.ignite.data.regions.offheap.size");
            if (val == null) continue;
            totalOffheap += (double)val.longValue();
        }
        return IgniteUtils.roundedHeapSize(totalOffheap, precision);
    }

    private static Iterable<ClusterNode> nodesPerJvm(Iterable<ClusterNode> nodes2) {
        HashMap<String, ClusterNode> grpMap = new HashMap<String, ClusterNode>();
        for (ClusterNode node : nodes2) {
            String grpId = node.attribute("org.apache.ignite.macs") + "|" + node.attribute("org.apache.ignite.jvm.pid");
            if (grpMap.containsKey(grpId)) continue;
            grpMap.put(grpId, node);
        }
        return grpMap.values();
    }

    public static double heapSize(int precision) {
        return IgniteUtils.roundedHeapSize(Runtime.getRuntime().maxMemory(), precision);
    }

    private static double roundedHeapSize(double heap, int precision) {
        double rounded = new BigDecimal(heap / 1.073741824E9).round(new MathContext(precision)).doubleValue();
        return rounded < 0.1 ? 0.1 : rounded;
    }

    public static void dumpThreads(@Nullable IgniteLogger log2) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        Set<Long> deadlockedThreadsIds = IgniteUtils.getDeadlockedThreadIds(mxBean);
        if (deadlockedThreadsIds.isEmpty()) {
            IgniteUtils.warn(log2, "No deadlocked threads detected.");
        } else {
            IgniteUtils.warn(log2, "Deadlocked threads detected (see thread dump below) [deadlockedThreadsCnt=" + deadlockedThreadsIds.size() + ']');
        }
        ThreadInfo[] threadInfos = mxBean.dumpAllThreads(mxBean.isObjectMonitorUsageSupported(), mxBean.isSynchronizerUsageSupported());
        GridStringBuilder sb = new GridStringBuilder("Thread dump at ").a(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").format(new Date(U.currentTimeMillis()))).a(NL);
        for (ThreadInfo info2 : threadInfos) {
            IgniteUtils.printThreadInfo(info2, sb, deadlockedThreadsIds);
            sb.a(NL);
            if (info2.getLockedSynchronizers() == null || info2.getLockedSynchronizers().length <= 0) continue;
            IgniteUtils.printSynchronizersInfo(info2.getLockedSynchronizers(), sb);
            sb.a(NL);
        }
        sb.a(NL);
        IgniteUtils.warn(log2, sb.toString());
    }

    public static void dumpThread(Thread t, @Nullable IgniteLogger log2) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        GridStringBuilder sb = new GridStringBuilder();
        IgniteUtils.printThreadInfo(mxBean.getThreadInfo(t.getId()), sb, Collections.emptySet());
        IgniteUtils.warn(log2, sb.toString());
    }

    private static Set<Long> getDeadlockedThreadIds(ThreadMXBean mxBean) {
        Set<Long> deadlockedThreadsIds;
        long[] deadlockedIds = mxBean.findDeadlockedThreads();
        if (!F.isEmpty(deadlockedIds)) {
            HashSet<Long> set = new HashSet<Long>();
            for (long id : deadlockedIds) {
                set.add(id);
            }
            deadlockedThreadsIds = Collections.unmodifiableSet(set);
        } else {
            deadlockedThreadsIds = Collections.emptySet();
        }
        return deadlockedThreadsIds;
    }

    public static void printStackTrace(long threadId, GridStringBuilder sb) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = mxBean.getThreadInfo(threadId, Integer.MAX_VALUE);
        IgniteUtils.printThreadInfo(threadInfo, sb, Collections.emptySet());
    }

    public static boolean deadlockPresent() {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        return !F.isEmpty(mxBean.findDeadlockedThreads());
    }

    private static void printThreadInfo(ThreadInfo threadInfo, GridStringBuilder sb, Set<Long> deadlockedIdSet) {
        long id = threadInfo.getThreadId();
        if (deadlockedIdSet.contains(id)) {
            sb.a("##### DEADLOCKED ");
        }
        sb.a("Thread [name=\"").a(threadInfo.getThreadName()).a("\", id=").a(threadInfo.getThreadId()).a(", state=").a((Object)threadInfo.getThreadState()).a(", blockCnt=").a(threadInfo.getBlockedCount()).a(", waitCnt=").a(threadInfo.getWaitedCount()).a("]").a(NL);
        LockInfo lockInfo = threadInfo.getLockInfo();
        if (lockInfo != null) {
            sb.a("    Lock [object=").a(lockInfo).a(", ownerName=").a(threadInfo.getLockOwnerName()).a(", ownerId=").a(threadInfo.getLockOwnerId()).a("]").a(NL);
        }
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        StackTraceElement[] elements2 = threadInfo.getStackTrace();
        for (int i = 0; i < elements2.length; ++i) {
            StackTraceElement e = elements2[i];
            sb.a("        at ").a(e.toString());
            for (MonitorInfo monitor : monitors) {
                if (monitor.getLockedStackDepth() != i) continue;
                sb.a(NL).a("        - locked ").a(monitor);
            }
            sb.a(NL);
        }
    }

    private static void printSynchronizersInfo(LockInfo[] syncs, GridStringBuilder sb) {
        sb.a("    Locked synchronizers:");
        for (LockInfo info2 : syncs) {
            sb.a(NL).a("        ").a(info2);
        }
    }

    @Nullable
    public static Constructor<?> forceEmptyConstructor(Class<?> cls) throws IgniteCheckedException {
        Constructor ctor = null;
        try {
            return cls.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception ignore) {
            Method ctorFac = U.ctorFactory();
            Object sunRefFac = U.sunReflectionFactory();
            if (ctorFac != null && sunRefFac != null) {
                try {
                    ctor = (Constructor)ctorFac.invoke(sunRefFac, cls, U.objectConstructor());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IgniteCheckedException("Failed to get object constructor for class: " + cls, e);
                }
            }
            return ctor;
        }
    }

    @Nullable
    public static Class<?> classForName(@Nullable String cls, @Nullable Class<?> dflt) {
        return IgniteUtils.classForName(cls, dflt, false);
    }

    @Nullable
    public static Class<?> classForName(@Nullable String cls, @Nullable Class<?> dflt, boolean includePrimitiveTypes) {
        Class<?> clazz2;
        if (cls == null) {
            clazz2 = dflt;
        } else if (!includePrimitiveTypes || cls.length() > 7 || (clazz2 = primitiveMap.get(cls)) == null) {
            try {
                clazz2 = Class.forName(cls);
            }
            catch (ClassNotFoundException ignore) {
                clazz2 = dflt;
            }
        }
        return clazz2;
    }

    @Nullable
    public static <T> T newInstance(String cls) throws IgniteCheckedException {
        Class<?> cls0;
        try {
            cls0 = Class.forName(cls);
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
        return (T)IgniteUtils.newInstance(cls0);
    }

    @Nullable
    public static <T> T newInstance(Class<T> cls) throws IgniteCheckedException {
        boolean set = false;
        Constructor<T> ctor = null;
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
            if (ctor == null) {
                T t = null;
                return t;
            }
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
                set = true;
            }
            T t = ctor.newInstance(new Object[0]);
            return t;
        }
        catch (NoSuchMethodException e) {
            throw new IgniteCheckedException("Failed to find empty constructor for class: " + cls, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to create new instance for class: " + cls, e);
        }
        finally {
            if (ctor != null && set) {
                ctor.setAccessible(false);
            }
        }
    }

    @Nullable
    public static <T> T forceNewInstance(Class<?> cls) throws IgniteCheckedException {
        Constructor<?> ctor = IgniteUtils.forceEmptyConstructor(cls);
        if (ctor == null) {
            return null;
        }
        boolean set = false;
        try {
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
                set = true;
            }
            Object obj = ctor.newInstance(new Object[0]);
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to create new instance for class: " + cls, e);
        }
        finally {
            if (set) {
                ctor.setAccessible(false);
            }
        }
    }

    public static String formatMins(long mins) {
        long hh;
        assert (mins >= 0L);
        if (mins == 0L) {
            return "< 1 min";
        }
        SB sb = new SB();
        long dd2 = mins / 1440L;
        if (dd2 > 0L) {
            sb.a(dd2).a(dd2 == 1L ? " day " : " days ");
        }
        if ((hh = (mins %= 1440L) / 60L) > 0L) {
            sb.a(hh).a(hh == 1L ? " hour " : " hours ");
        }
        if ((mins %= 60L) > 0L) {
            sb.a(mins).a(mins == 1L ? " min " : " mins ");
        }
        return sb.toString().trim();
    }

    public static String id8(UUID id) {
        return id.toString().substring(0, 8);
    }

    public static String id8(IgniteUuid id) {
        String s2 = id.toString();
        return s2.substring(0, 4) + s2.substring(s2.length() - 4);
    }

    public static String filler(int len, char ch) {
        char[] a = new char[len];
        Arrays.fill(a, ch);
        return new String(a);
    }

    public static <T> void writeArray(ObjectOutput out, T[] arr) throws IOException {
        int len = arr == null ? 0 : arr.length;
        out.writeInt(len);
        if (arr != null && arr.length > 0) {
            for (T t : arr) {
                out.writeObject(t);
            }
        }
    }

    @Nullable
    public static Object[] readArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        Object[] arr = null;
        if (len > 0) {
            arr = new Object[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = in.readObject();
            }
        }
        return arr;
    }

    @Nullable
    public static Class<?>[] readClassArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        Class[] arr = null;
        if (len > 0) {
            arr = new Class[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Class)in.readObject();
            }
        }
        return arr;
    }

    public static void writeCollection(ObjectOutput out, Collection<?> col) throws IOException {
        if (col != null) {
            out.writeInt(col.size());
            for (Object o : col) {
                out.writeObject(o);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public static void writeIntCollection(DataOutput out, Collection<Integer> col) throws IOException {
        if (col != null) {
            out.writeInt(col.size());
            for (Integer i : col) {
                out.writeInt(i);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static <E> Collection<E> readCollection(ObjectInput in) throws IOException, ClassNotFoundException {
        return IgniteUtils.readList(in);
    }

    @Nullable
    public static Collection<Integer> readIntCollection(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        ArrayList<Integer> col = new ArrayList<Integer>(size2);
        for (int i = 0; i < size2; ++i) {
            col.add(in.readInt());
        }
        return col;
    }

    public static <K, V> Map<K, V> copyMap(Map<K, V> m) {
        return new HashMap<K, V>(m);
    }

    public static <K, V> Map<K, V> sealMap(Map<K, V> m) {
        assert (m != null);
        return Collections.unmodifiableMap(new HashMap<K, V>(m));
    }

    public static <E> List<E> sealList(Collection<E> c) {
        return Collections.unmodifiableList(new ArrayList<E>(c));
    }

    public static <E> List<E> sealList(E ... a) {
        return Collections.unmodifiableList(Arrays.asList(a));
    }

    @Nullable
    public static String getNetworkInterfaceName(String addr) {
        assert (addr != null);
        try {
            InetAddress inetAddr = InetAddress.getByName(addr);
            for (NetworkInterface itf : IgniteUtils.asIterable(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress itfAddr : IgniteUtils.asIterable(itf.getInetAddresses())) {
                    if (!itfAddr.equals(inetAddr)) continue;
                    return itf.getDisplayName();
                }
            }
        }
        catch (UnknownHostException ignore) {
            return null;
        }
        catch (SocketException ignore) {
            return null;
        }
        return null;
    }

    public static InetAddress resolveLocalHost(@Nullable String hostName) throws IOException {
        return F.isEmpty(hostName) ? new InetSocketAddress(0).getAddress() : InetAddress.getByName(hostName);
    }

    public static synchronized boolean isLocalHostChanged() throws IOException {
        InetAddress locHost0 = locHost;
        return locHost0 != null && !IgniteUtils.resetLocalHost().equals(locHost0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<InetAddress> filterReachable(Collection<InetAddress> addrs) {
        if (addrs.isEmpty()) {
            return Collections.emptyList();
        }
        int reachTimeout = 2000;
        if (addrs.size() == 1) {
            InetAddress addr = F.first(addrs);
            if (!IgniteUtils.reachable(addr, 2000)) return Collections.emptyList();
            return Collections.singletonList(addr);
        }
        final ArrayList<InetAddress> res = new ArrayList<InetAddress>(addrs.size());
        ArrayList futs = new ArrayList(addrs.size());
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(10, addrs.size()));
        try {
            for (final InetAddress inetAddress : addrs) {
                futs.add(executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (IgniteUtils.reachable(inetAddress, 2000)) {
                            List list2 = res;
                            synchronized (list2) {
                                res.add(inetAddress);
                            }
                        }
                    }
                }));
            }
            for (Future future : futs) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IgniteException("Thread has been interrupted.", e);
                }
                catch (ExecutionException e) {
                    throw new IgniteException(e);
                    return res;
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    public static IgniteBiTuple<Collection<String>, Collection<String>> resolveLocalAddresses(InetAddress locAddr) throws IOException, IgniteCheckedException {
        return IgniteUtils.resolveLocalAddresses(locAddr, false);
    }

    public static IgniteBiTuple<Collection<String>, Collection<String>> resolveLocalAddresses(InetAddress locAddr, boolean allHostNames) throws IOException, IgniteCheckedException {
        assert (locAddr != null);
        ArrayList<String> addrs = new ArrayList<String>();
        ArrayList<String> hostNames = new ArrayList<String>();
        if (locAddr.isAnyLocalAddress()) {
            IgniteBiTuple<Collection<String>, Collection<String>> res;
            IgniteBiTuple<Collection<String>, Collection<String>> igniteBiTuple = res = allHostNames ? cachedLocalAddrAllHostNames : cachedLocalAddr;
            if (res == null) {
                List<InetAddress> locAddrs = new ArrayList<InetAddress>();
                for (NetworkInterface itf : IgniteUtils.asIterable(NetworkInterface.getNetworkInterfaces())) {
                    for (InetAddress addr : IgniteUtils.asIterable(itf.getInetAddresses())) {
                        if (addr.isLinkLocalAddress()) continue;
                        locAddrs.add(addr);
                    }
                }
                locAddrs = IgniteUtils.filterReachable(locAddrs);
                for (InetAddress addr : locAddrs) {
                    IgniteUtils.addresses(addr, addrs, hostNames, allHostNames);
                }
                if (F.isEmpty(addrs)) {
                    throw new IgniteCheckedException("No network addresses found (is networking enabled?).");
                }
                res = F.t(addrs, hostNames);
                if (allHostNames) {
                    cachedLocalAddrAllHostNames = res;
                } else {
                    cachedLocalAddr = res;
                }
            }
            return res;
        }
        IgniteUtils.addresses(locAddr, addrs, hostNames, allHostNames);
        return F.t(addrs, hostNames);
    }

    private static void addresses(InetAddress addr, Collection<String> addrs, Collection<String> hostNames, boolean allHostNames) {
        String hostName = addr.getHostName();
        String ipAddr = addr.getHostAddress();
        addrs.add(ipAddr);
        if (allHostNames) {
            hostNames.add(hostName);
        } else if (!F.isEmpty(hostName) && !addr.isLoopbackAddress()) {
            hostNames.add(hostName);
        }
    }

    public static synchronized InetAddress getLocalHost() throws IOException {
        if (locHost == null) {
            IgniteUtils.resetLocalHost();
        }
        return locHost;
    }

    private static synchronized InetAddress resetLocalHost() throws IOException {
        locHost = null;
        String sysLocHost = IgniteSystemProperties.getString("IGNITE_LOCAL_HOST");
        if (sysLocHost != null) {
            sysLocHost = sysLocHost.trim();
        }
        if (!F.isEmpty(sysLocHost)) {
            locHost = InetAddress.getByName(sysLocHost);
        } else {
            ArrayList<NetworkInterface> itfs = new ArrayList<NetworkInterface>();
            for (NetworkInterface itf : IgniteUtils.asIterable(NetworkInterface.getNetworkInterfaces())) {
                itfs.add(itf);
            }
            Collections.sort(itfs, new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface itf1, NetworkInterface itf2) {
                    return itf1.getName().compareTo(itf2.getName());
                }
            });
            int reachTimeout = 2000;
            for (NetworkInterface itf : itfs) {
                boolean found = false;
                for (InetAddress addr : IgniteUtils.asIterable(itf.getInetAddresses())) {
                    if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || !IgniteUtils.reachable(itf, addr, reachTimeout)) continue;
                    locHost = addr;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        if (locHost == null) {
            locHost = InetAddress.getLocalHost();
        }
        return locHost;
    }

    public static boolean reachable(NetworkInterface itf, InetAddress addr, int reachTimeout) {
        try {
            return addr.isReachable(itf, 0, reachTimeout);
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static boolean reachable(InetAddress addr, int reachTimeout) {
        try {
            return addr.isReachable(reachTimeout);
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static boolean sameMacs(ClusterNode loc, ClusterNode rmt) {
        assert (loc != null);
        assert (rmt != null);
        String locMacs = (String)loc.attribute("org.apache.ignite.macs");
        String rmtMacs = (String)rmt.attribute("org.apache.ignite.macs");
        return locMacs != null && locMacs.equals(rmtMacs);
    }

    public static synchronized Collection<String> allLocalIps() {
        ArrayList<String> ips = new ArrayList<String>(4);
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            if (itfs != null) {
                for (NetworkInterface itf : IgniteUtils.asIterable(itfs)) {
                    if (itf.isLoopback()) continue;
                    Enumeration<InetAddress> addrs = itf.getInetAddresses();
                    for (InetAddress addr : IgniteUtils.asIterable(addrs)) {
                        String hostAddr = addr.getHostAddress();
                        if (addr.isLoopbackAddress() || ips.contains(hostAddr)) continue;
                        ips.add(hostAddr);
                    }
                }
            }
        }
        catch (SocketException ignore) {
            return Collections.emptyList();
        }
        Collections.sort(ips);
        return ips;
    }

    public static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static synchronized Collection<String> allLocalMACs() {
        ArrayList<String> macs = new ArrayList<String>(3);
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            if (itfs != null) {
                for (NetworkInterface itf : IgniteUtils.asIterable(itfs)) {
                    String mac;
                    byte[] hwAddr = itf.getHardwareAddress();
                    if (hwAddr == null || hwAddr.length <= 0 || macs.contains(mac = IgniteUtils.byteArray2HexString(hwAddr))) continue;
                    macs.add(mac);
                }
            }
        }
        catch (SocketException ignore) {
            return Collections.emptyList();
        }
        Collections.sort(macs);
        return macs;
    }

    public static File downloadUrl(URL url, File file) throws IOException {
        assert (url != null);
        assert (file != null);
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection https = (HttpsURLConnection)conn;
                https.setHostnameVerifier(new DeploymentHostnameVerifier());
                SSLContext ctx = SSLContext.getInstance(HTTPS_PROTOCOL);
                ctx.init(null, IgniteUtils.getTrustManagers(), null);
                https.setSSLSocketFactory(ctx.getSocketFactory());
            }
            if ((in = conn.getInputStream()) == null) {
                throw new IOException("Failed to open connection: " + url.toString());
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            IgniteUtils.copy(in, out);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            try {
                throw new IOException("Failed to open HTTPs connection [url=" + url.toString() + ", msg=" + e + ']', e);
            }
            catch (Throwable throwable2) {
                IgniteUtils.close(in, null);
                IgniteUtils.close(out, null);
                throw throwable2;
            }
        }
        IgniteUtils.close(in, null);
        IgniteUtils.close(out, null);
        return file;
    }

    private static TrustManager[] getTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            @Nullable
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    @Nullable
    public static String hidePassword(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        if (Pattern.matches(".*://(.*:.*)@.*", uri)) {
            int userInfoLastIdx = uri.indexOf(64);
            assert (userInfoLastIdx != -1);
            String str = uri.substring(0, userInfoLastIdx);
            int userInfoStartIdx = str.lastIndexOf(47);
            str = str.substring(userInfoStartIdx + 1);
            String[] params2 = str.split(";");
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < params2.length; ++i) {
                int idx = params2[i].indexOf(58);
                if (idx != -1) {
                    params2[i] = params2[i].substring(0, idx + 1) + '*';
                }
                builder.append(params2[i]);
                if (i == params2.length - 1) continue;
                builder.append(';');
            }
            return new StringBuilder(uri).replace(userInfoStartIdx + 1, userInfoLastIdx, builder.toString()).toString();
        }
        return uri;
    }

    public static ClassLoader gridClassLoader() {
        return gridClassLoader;
    }

    public static ClassLoader resolveClassLoader(IgniteConfiguration cfg) {
        return IgniteUtils.resolveClassLoader(null, cfg);
    }

    public static ClassLoader resolveClassLoader(ClassLoader ldr, IgniteConfiguration cfg) {
        assert (cfg != null);
        return ldr != null && ldr != gridClassLoader ? ldr : (cfg.getClassLoader() != null ? cfg.getClassLoader() : gridClassLoader);
    }

    public static boolean hasParent(@Nullable ClassLoader parent, ClassLoader ldr) {
        if (parent != null) {
            while (ldr != null) {
                if (ldr.equals(parent)) {
                    return true;
                }
                ldr = ldr.getParent();
            }
            return false;
        }
        return true;
    }

    public static void writeBytesCollection(DataOutput out, Collection<byte[]> bytes2) throws IOException {
        if (bytes2 != null) {
            out.writeInt(bytes2.size());
            for (byte[] b : bytes2) {
                IgniteUtils.writeByteArray(out, b);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public static List<byte[]> readBytesList(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 < 0) {
            return null;
        }
        ArrayList<byte[]> res = new ArrayList<byte[]>(size2);
        for (int i = 0; i < size2; ++i) {
            res.add(IgniteUtils.readByteArray(in));
        }
        return res;
    }

    public static void writeByteArray(DataOutput out, @Nullable byte[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(arr.length);
            out.write(arr);
        }
    }

    public static void writeByteArray(DataOutput out, @Nullable byte[] arr, int maxLen) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            int len = Math.min(arr.length, maxLen);
            out.writeInt(len);
            out.write(arr, 0, len);
        }
    }

    @Nullable
    public static byte[] readByteArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        byte[] res = new byte[len];
        in.readFully(res);
        return res;
    }

    public static byte[] readByteArray(ByteBuffer ... bufs) {
        assert (!F.isEmpty(bufs));
        int size2 = 0;
        for (ByteBuffer buf : bufs) {
            size2 += buf.remaining();
        }
        byte[] res = new byte[size2];
        int off = 0;
        for (ByteBuffer buf : bufs) {
            int len = buf.remaining();
            if (len == 0) continue;
            buf.get(res, off, len);
            off += len;
        }
        assert (off == res.length);
        return res;
    }

    public static void writeByteCollection(DataOutput out, Collection<Byte> col) throws IOException {
        if (col != null) {
            out.writeInt(col.size());
            for (Byte i : col) {
                out.writeByte(i.byteValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static List<Byte> readByteList(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        ArrayList<Byte> col = new ArrayList<Byte>(size2);
        for (int i = 0; i < size2; ++i) {
            col.add(in.readByte());
        }
        return col;
    }

    public static byte[] join(byte[] ... bufs) {
        int size2 = 0;
        for (byte[] buf : bufs) {
            size2 += buf.length;
        }
        byte[] res = new byte[size2];
        int position2 = 0;
        for (byte[] buf : bufs) {
            IgniteUtils.arrayCopy(buf, 0, res, position2, buf.length);
            position2 += buf.length;
        }
        return res;
    }

    public static String byteArray2String(byte[] arr, String hdrFmt, String bodyFmt) {
        assert (arr != null);
        assert (hdrFmt != null);
        assert (bodyFmt != null);
        SB sb = new SB();
        sb.a('{');
        boolean first = true;
        for (byte b : arr) {
            if (first) {
                sb.a(String.format(hdrFmt, b));
                first = false;
                continue;
            }
            sb.a(String.format(bodyFmt, b));
        }
        sb.a('}');
        return sb.toString();
    }

    public static byte[] hexString2ByteArray(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            hex = '0' + hex;
        }
        char[] chars = hex.toCharArray();
        byte[] bytes2 = new byte[chars.length / 2];
        int byteCnt = 0;
        for (int i = 0; i < chars.length; i += 2) {
            int newByte = 0;
            newByte |= IgniteUtils.hexCharToByte(chars[i]);
            newByte <<= 4;
            bytes2[byteCnt] = (byte)(newByte |= IgniteUtils.hexCharToByte(chars[i + 1]));
            ++byteCnt;
        }
        return bytes2;
    }

    public static String hexLong(long val) {
        return new SB().appendHex(val).toString();
    }

    public static String hexInt(int val) {
        return new SB().appendHex(val).toString();
    }

    private static byte hexCharToByte(char ch) throws IllegalArgumentException {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(ch - 48);
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Hex decoding wrong input character [character=" + ch + ']');
    }

    public static byte[] doubleToBytes(double d) {
        return IgniteUtils.longToBytes(Double.doubleToLongBits(d));
    }

    public static int doubleToBytes(double d, byte[] bytes2, int off) {
        return IgniteUtils.longToBytes(Double.doubleToLongBits(d), bytes2, off);
    }

    public static byte[] floatToBytes(float f2) {
        return IgniteUtils.intToBytes(Float.floatToIntBits(f2));
    }

    public static int floatToBytes(float f2, byte[] bytes2, int off) {
        return IgniteUtils.intToBytes(Float.floatToIntBits(f2), bytes2, off);
    }

    public static byte[] longToBytes(long l) {
        return GridClientByteUtils.longToBytes(l);
    }

    public static int longToBytes(long l, byte[] bytes2, int off) {
        return off + GridClientByteUtils.longToBytes(l, bytes2, off);
    }

    public static byte[] intToBytes(int i) {
        return GridClientByteUtils.intToBytes(i);
    }

    public static int intToBytes(int i, byte[] bytes2, int off) {
        return off + GridClientByteUtils.intToBytes(i, bytes2, off);
    }

    public static byte[] shortToBytes(short s2) {
        return GridClientByteUtils.shortToBytes(s2);
    }

    public static int shortToBytes(short s2, byte[] bytes2, int off) {
        return off + GridClientByteUtils.shortToBytes(s2, bytes2, off);
    }

    public static int uuidToBytes(@Nullable UUID uuid, byte[] arr, int off) {
        return off + GridClientByteUtils.uuidToBytes(uuid, arr, off);
    }

    public static byte[] uuidToBytes(@Nullable UUID uuid) {
        return GridClientByteUtils.uuidToBytes(uuid);
    }

    public static short bytesToShort(byte[] bytes2, int off) {
        assert (bytes2 != null);
        int bytesCnt = 2;
        if (off + bytesCnt > bytes2.length) {
            bytesCnt = bytes2.length - off;
        }
        short res = 0;
        for (int i = 0; i < bytesCnt; ++i) {
            int shift = bytesCnt - i - 1 << 3;
            res = (short)((long)res | (0xFFL & (long)bytes2[off++]) << shift);
        }
        return res;
    }

    public static int bytesToInt(byte[] bytes2, int off) {
        assert (bytes2 != null);
        int bytesCnt = 4;
        if (off + bytesCnt > bytes2.length) {
            bytesCnt = bytes2.length - off;
        }
        int res = 0;
        for (int i = 0; i < bytesCnt; ++i) {
            int shift = bytesCnt - i - 1 << 3;
            res = (int)((long)res | (0xFFL & (long)bytes2[off++]) << shift);
        }
        return res;
    }

    public static long bytesToLong(byte[] bytes2, int off) {
        assert (bytes2 != null);
        int bytesCnt = 8;
        if (off + bytesCnt > bytes2.length) {
            bytesCnt = bytes2.length - off;
        }
        long res = 0L;
        for (int i = 0; i < bytesCnt; ++i) {
            int shift = bytesCnt - i - 1 << 3;
            res |= (0xFFL & (long)bytes2[off++]) << shift;
        }
        return res;
    }

    public static UUID bytesToUuid(byte[] bytes2, int off) {
        return GridClientByteUtils.bytesToUuid(bytes2, off);
    }

    public static double bytesToDouble(byte[] bytes2, int off) {
        return Double.longBitsToDouble(IgniteUtils.bytesToLong(bytes2, off));
    }

    public static float bytesToFloat(byte[] bytes2, int off) {
        return Float.intBitsToFloat(IgniteUtils.bytesToInt(bytes2, off));
    }

    public static boolean bytesEqual(byte[] a, int aOff, byte[] b, int bOff, int len) {
        if (aOff + len > a.length || bOff + len > b.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[aOff + i] == b[bOff + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] decodeHex(char[] data) throws IgniteCheckedException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IgniteCheckedException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f2 = IgniteUtils.toDigit(data[j], j) << 4;
            f2 |= IgniteUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f2 & 0xFF);
            ++i;
        }
        return out;
    }

    public static String readableSize(long bytes2, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes2 < (long)unit) {
            return bytes2 + " B";
        }
        int exp = (int)(Math.log(bytes2) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes2 / Math.pow(unit, exp), pre);
    }

    public static String dash(int len) {
        char[] dash = new char[len];
        Arrays.fill(dash, '-');
        dash[len - 1] = 43;
        dash[0] = 43;
        return new String(dash);
    }

    public static String pad(int len) {
        char[] dash = new char[len];
        Arrays.fill(dash, ' ');
        return new String(dash);
    }

    public static String format(long sysTime) {
        return LONG_DATE_FMT.format(new Date(sysTime));
    }

    public static <T> Iterable<T> asIterable(final Enumeration<T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest, boolean overwrite) throws IOException {
        assert (src != null);
        assert (dest != null);
        if (!src.exists()) {
            throw new FileNotFoundException("Source can't be found: " + src);
        }
        if (src.getAbsoluteFile().equals(dest.getAbsoluteFile())) {
            throw new IOException("Source and destination are the same [src=" + src + ", dest=" + dest + ']');
        }
        if (dest.exists()) {
            if (!dest.isDirectory() && !overwrite) {
                throw new IOException("Destination already exists: " + dest);
            }
            if (!dest.canWrite()) {
                throw new IOException("Destination is not writable:" + dest);
            }
        } else {
            File parent = dest.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (src.isDirectory()) {
                dest.mkdir();
            }
        }
        if (src.isDirectory()) {
            File[] files2;
            for (File file : files2 = src.listFiles()) {
                if (file.isDirectory()) {
                    File dir = new File(dest, file.getName());
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("Can't create directory: " + dir);
                    }
                    IgniteUtils.copy(file, dir, overwrite);
                    continue;
                }
                IgniteUtils.copy(file, dest, overwrite);
            }
        } else {
            File file;
            File file2 = file = dest.exists() && dest.isDirectory() ? new File(dest, src.getName()) : dest;
            if (!overwrite && file.exists()) {
                throw new IOException("Destination already exists: " + file);
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(file);
                IgniteUtils.copy(in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.getFD().sync();
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onGridStart() {
        Object object = mux;
        synchronized (object) {
            if (gridCnt == 0) {
                assert (timer == null);
                timer = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            curTimeMillis = System.currentTimeMillis();
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ignored) {
                                return;
                            }
                        }
                    }
                }, "ignite-clock");
                timer.setDaemon(true);
                timer.setPriority(10);
                timer.start();
            }
            ++gridCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onGridStop() throws InterruptedException {
        Object object = mux;
        synchronized (object) {
            if (gridCnt == 0) {
                return;
            }
            Thread timer0 = timer;
            if (--gridCnt == 0 && timer0 != null) {
                timer = null;
                timer0.interrupt();
                timer0.join();
            }
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        assert (in != null);
        assert (out != null);
        byte[] buf = new byte[4096];
        int cnt = 0;
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
            cnt += n;
        }
        return cnt;
    }

    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        assert (in != null);
        assert (out != null);
        char[] buf = new char[4096];
        int cnt = 0;
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
            cnt += n;
        }
        return cnt;
    }

    public static void writeStringToFile(File file, String s2) throws IOException {
        IgniteUtils.writeStringToFile(file, s2, Charset.defaultCharset().toString(), false);
    }

    public static void writeStringToFile(File file, String s2, String charset) throws IOException {
        IgniteUtils.writeStringToFile(file, s2, charset, false);
    }

    public static String readFileToString(String fileName, String charset) throws IOException {
        try (InputStreamReader input2 = new InputStreamReader((InputStream)new FileInputStream(fileName), charset);){
            int n;
            StringWriter output = new StringWriter();
            char[] buf = new char[4096];
            while ((n = input2.read(buf)) != -1) {
                output.write(buf, 0, n);
            }
            String string2 = output.toString();
            return string2;
        }
    }

    public static void writeStringToFile(File file, String s2, String charset, boolean append2) throws IOException {
        if (s2 == null) {
            return;
        }
        try (FileOutputStream out = new FileOutputStream(file, append2);){
            ((OutputStream)out).write(s2.getBytes(charset));
        }
    }

    public static <E extends Throwable> E withCause(E e, @Nullable Throwable cause) {
        assert (e != null);
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    public static boolean delete(@Nullable File file) {
        return file != null && IgniteUtils.delete(file.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean delete(Path path2) {
        if (Files.isDirectory(path2, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2);){
                for (Path innerPath : stream) {
                    boolean res = IgniteUtils.delete(innerPath);
                    if (res) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        if (path2.endsWith("jar")) {
            try {
                new JarFile(path2.toString(), false).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            Files.delete(path2);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean mkdirs(File dir) {
        assert (dir != null);
        return dir.mkdirs() || dir.exists();
    }

    @Nullable
    private static String resolveProjectHome() {
        File classesFile;
        URI classesUri;
        assert (Thread.holdsLock(IgniteUtils.class));
        String ggHome0 = IgniteSystemProperties.getString("IGNITE_HOME");
        if (!F.isEmpty(ggHome0)) {
            return ggHome0;
        }
        String appWorkDir = System.getProperty("user.dir");
        if (appWorkDir != null && (ggHome0 = IgniteUtils.findProjectHome(new File(appWorkDir))) != null) {
            return ggHome0;
        }
        Class<IgniteUtils> cls = IgniteUtils.class;
        try {
            ProtectionDomain domain = cls.getProtectionDomain();
            if (domain == null || domain.getCodeSource() == null || domain.getCodeSource().getLocation() == null) {
                IgniteUtils.logResolveFailed(cls, null);
                return null;
            }
            classesUri = domain.getCodeSource().getLocation().toURI();
            if (IgniteUtils.isWindows() && classesUri.getAuthority() != null) {
                classesUri = new URI(classesUri.toString().replace("file://", "file:/"));
            }
        }
        catch (SecurityException | URISyntaxException e) {
            IgniteUtils.logResolveFailed(cls, e);
            return null;
        }
        try {
            classesFile = new File(classesUri);
        }
        catch (IllegalArgumentException e) {
            IgniteUtils.logResolveFailed(cls, e);
            return null;
        }
        return IgniteUtils.findProjectHome(classesFile);
    }

    private static String findProjectHome(File startDir) {
        for (File cur = startDir.getAbsoluteFile(); cur != null; cur = cur.getParentFile()) {
            if (!new File(cur, "bin").isDirectory() || !new File(cur, "config").isDirectory()) continue;
            return cur.getPath();
        }
        return null;
    }

    private static void logResolveFailed(Class cls, Exception e) {
        IgniteUtils.warn(null, "Failed to resolve IGNITE_HOME automatically for class codebase [class=" + cls + (e == null ? "" : ", e=" + e.getMessage()) + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getIgniteHome() {
        String ggHome0;
        GridTuple<String> ggHomeTup = ggHome;
        if (ggHomeTup == null) {
            Class<IgniteUtils> clazz2 = IgniteUtils.class;
            synchronized (IgniteUtils.class) {
                ggHomeTup = ggHome;
                if (ggHomeTup == null) {
                    ggHome0 = IgniteUtils.resolveProjectHome();
                    ggHome = F.t(ggHome0);
                    if (ggHome0 != null) {
                        System.setProperty("IGNITE_HOME", ggHome0);
                    }
                } else {
                    ggHome0 = ggHomeTup.get();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
        } else {
            ggHome0 = ggHomeTup.get();
        }
        return ggHome0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIgniteHome(@Nullable String path2) {
        String ggHome0;
        GridTuple<String> ggHomeTup = ggHome;
        if (ggHomeTup == null) {
            Class<IgniteUtils> clazz2 = IgniteUtils.class;
            synchronized (IgniteUtils.class) {
                ggHomeTup = ggHome;
                if (ggHomeTup == null) {
                    if (F.isEmpty(path2)) {
                        System.clearProperty("IGNITE_HOME");
                    } else {
                        System.setProperty("IGNITE_HOME", path2);
                    }
                    ggHome = F.t(path2);
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                ggHome0 = ggHomeTup.get();
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        } else {
            ggHome0 = ggHomeTup.get();
        }
        {
            if (ggHome0 != null && !ggHome0.equals(path2)) {
                try {
                    Path path0 = new File(ggHome0).toPath();
                    Path path1 = new File(path2).toPath();
                    if (!Files.isSameFile(path0, path1)) {
                        throw new IgniteException("Failed to set IGNITE_HOME after it has been already resolved [igniteHome=" + path0 + ", newIgniteHome=" + path1 + ']');
                    }
                }
                catch (IOException ignore) {
                    throw new IgniteException("Failed to set IGNITE_HOME after it has been already resolved [igniteHome=" + ggHome0 + ", newIgniteHome=" + path2 + ']');
                }
            }
            return;
        }
    }

    @Nullable
    public static File resolveIgnitePath(String path2) {
        File file;
        assert (path2 != null);
        String home = IgniteUtils.getIgniteHome();
        if (home != null && (file = new File(home, path2)).exists()) {
            return file;
        }
        file = new File(path2);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public static URL resolveIgniteUrl(String path2) {
        return IgniteUtils.resolveIgniteUrl(path2, true);
    }

    public static URL resolveSpringUrl(String springCfgPath) throws IgniteCheckedException {
        URL url;
        block3: {
            A.notNull(springCfgPath, "springCfgPath");
            try {
                url = new URL(springCfgPath);
            }
            catch (MalformedURLException e) {
                url = U.resolveIgniteUrl(springCfgPath);
                if (url == null) {
                    url = IgniteUtils.resolveInClasspath(springCfgPath);
                }
                if (url != null) break block3;
                throw new IgniteCheckedException("Spring XML configuration path is invalid: " + springCfgPath + ". Note that this path should be either absolute or a relative local file system path, relative to META-INF in classpath or valid URL to IGNITE_HOME.", e);
            }
        }
        return url;
    }

    @Nullable
    private static URL resolveInClasspath(String path2) {
        ClassLoader clsLdr = Thread.currentThread().getContextClassLoader();
        if (clsLdr == null) {
            return null;
        }
        return clsLdr.getResource(path2.replaceAll("\\\\", "/"));
    }

    @Nullable
    public static URL resolveIgniteUrl(String path2, boolean metaInf) {
        ClassLoader clsLdr;
        File f2 = IgniteUtils.resolveIgnitePath(path2);
        if (f2 != null) {
            try {
                return f2.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((clsLdr = Thread.currentThread().getContextClassLoader()) != null) {
            String locPath = (metaInf ? "META-INF/" : "") + path2.replaceAll("\\\\", "/");
            return clsLdr.getResource(locPath);
        }
        return null;
    }

    public static String byteArray2HexString(byte[] arr) {
        SB sb = new SB(arr.length << 1);
        for (byte b : arr) {
            sb.a(Integer.toHexString(0xF & b >>> 4)).a(Integer.toHexString(0xF & b));
        }
        return sb.toString().toUpperCase();
    }

    public static boolean containsObjectArray(@Nullable Object[] arr, Object val, Object ... vals) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (Object o : arr) {
            if (F.eq(o, val)) {
                return true;
            }
            if (vals == null || vals.length <= 0) continue;
            for (Object v : vals) {
                if (!F.eq(o, v)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIntArray(int[] arr, int val) {
        assert (arr != null);
        if (arr.length == 0) {
            return false;
        }
        for (int i : arr) {
            if (i != val) continue;
            return true;
        }
        return false;
    }

    public static boolean containsStringArray(String[] arr, @Nullable String val, boolean ignoreCase) {
        assert (arr != null);
        for (String s2 : arr) {
            if (s2 == null && val == null) {
                return true;
            }
            if (s2 == null || val == null || !(ignoreCase ? s2.equalsIgnoreCase(val) : s2.equals(val))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsStringCollection(Iterable<String> c, @Nullable String val, boolean ignoreCase) {
        assert (c != null);
        for (String s2 : c) {
            if (s2 == null && val == null) {
                return true;
            }
            if (s2 == null || val == null || !(ignoreCase ? s2.equalsIgnoreCase(val) : s2.equals(val))) continue;
            return true;
        }
        return false;
    }

    public static void close(@Nullable AutoCloseable rsrc, @Nullable IgniteLogger log2) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (Exception e) {
                IgniteUtils.warn(log2, "Failed to close resource: " + e.getMessage());
            }
        }
    }

    public static void closeWithSuppressingException(@Nullable AutoCloseable rsrc, @NotNull Exception e) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
        }
    }

    public static void closeQuiet(@Nullable AutoCloseable rsrc) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable SelectionKey rsrc, @Nullable IgniteLogger log2) {
        if (rsrc != null) {
            IgniteUtils.close(rsrc.channel(), log2);
        }
    }

    public static void closeQuiet(@Nullable SelectionKey rsrc) {
        if (rsrc != null) {
            IgniteUtils.closeQuiet(rsrc.channel());
        }
    }

    public static void close(@Nullable DatagramSocket rsrc) {
        if (rsrc != null) {
            rsrc.close();
        }
    }

    public static void close(@Nullable Selector rsrc, @Nullable IgniteLogger log2) {
        if (rsrc != null) {
            try {
                if (rsrc.isOpen()) {
                    rsrc.close();
                }
            }
            catch (IOException e) {
                IgniteUtils.warn(log2, "Failed to close resource: " + e.getMessage());
            }
        }
    }

    public static void closeQuiet(@Nullable Selector rsrc) {
        if (rsrc != null) {
            try {
                if (rsrc.isOpen()) {
                    rsrc.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable Context rsrc, @Nullable IgniteLogger log2) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (NamingException e) {
                IgniteUtils.warn(log2, "Failed to close resource: " + e.getMessage());
            }
        }
    }

    public static void closeQuiet(@Nullable Context rsrc) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable URLClassLoader clsLdr, @Nullable IgniteLogger log2) {
        if (clsLdr != null) {
            try {
                clsLdr.close();
            }
            catch (Exception e) {
                IgniteUtils.warn(log2, "Failed to close resource: " + e.getMessage());
            }
        }
    }

    public static void releaseQuiet(@Nullable FileLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void rollbackConnection(@Nullable Connection rsrc, @Nullable IgniteLogger log2) {
        if (rsrc != null) {
            try {
                rsrc.rollback();
            }
            catch (SQLException e) {
                IgniteUtils.warn(log2, "Failed to rollback JDBC connection: " + e.getMessage());
            }
        }
    }

    public static void courtesy(@Nullable IgniteLogger log2, Object msg) {
        assert (msg != null);
        String s2 = msg.toString();
        IgniteUtils.courtesy(log2, s2, s2);
    }

    public static void courtesy(@Nullable IgniteLogger log2, Object longMsg, Object shortMsg) {
        assert (longMsg != null);
        assert (shortMsg != null);
        if (log2 != null) {
            log2.getLogger("org.apache.ignite.CourtesyConfigNotice").warning(IgniteUtils.compact(longMsg.toString()));
        } else {
            X.println("[" + SHORT_DATE_FMT.format(new Date()) + "] (courtesy) " + IgniteUtils.compact(shortMsg.toString()), new Object[0]);
        }
    }

    public static void warn(@Nullable IgniteLogger log2, Object msg) {
        assert (msg != null);
        String s2 = msg.toString();
        IgniteUtils.warn(log2, s2, null);
    }

    public static void quietAndWarn(IgniteLogger log2, Object msg) {
        IgniteUtils.quietAndWarn(log2, msg, msg);
    }

    public static void quietAndWarn(IgniteLogger log2, Object msg, Object shortMsg) {
        IgniteUtils.warn(log2, msg);
        if (log2.isQuiet()) {
            IgniteUtils.quiet(false, shortMsg);
        }
    }

    public static void error(@Nullable IgniteLogger log2, Object msg) {
        assert (msg != null);
        if (msg instanceof Throwable) {
            Throwable t = (Throwable)msg;
            IgniteUtils.error(log2, t.getMessage(), t);
        } else {
            String s2 = msg.toString();
            IgniteUtils.error(log2, s2, s2, null);
        }
    }

    public static void warn(@Nullable IgniteLogger log2, Object msg, @Nullable Throwable e) {
        assert (msg != null);
        if (log2 != null) {
            log2.warning(IgniteUtils.compact(msg.toString()), e);
        } else {
            X.println("[" + SHORT_DATE_FMT.format(new Date()) + "] (wrn) " + IgniteUtils.compact(msg.toString()), new Object[0]);
            if (e != null) {
                e.printStackTrace(System.err);
            } else {
                X.printerrln();
            }
        }
    }

    public static void warnDevOnly(@Nullable IgniteLogger log2, Object msg) {
        assert (msg != null);
        if (devOnlyLogDisabled) {
            return;
        }
        if (log2 != null) {
            log2.warning("DEV_ONLY", IgniteUtils.compact(msg.toString()), null);
        } else {
            X.println("[" + SHORT_DATE_FMT.format(new Date()) + "] (wrn) " + IgniteUtils.compact(msg.toString()), new Object[0]);
        }
    }

    public static void log(@Nullable IgniteLogger log2, Object longMsg, Object shortMsg) {
        assert (longMsg != null);
        assert (shortMsg != null);
        if (log2 != null) {
            if (log2.isInfoEnabled()) {
                log2.info(IgniteUtils.compact(longMsg.toString()));
            }
        } else {
            IgniteUtils.quiet(false, shortMsg);
        }
    }

    public static void log(@Nullable IgniteLogger log2, Object msg) {
        assert (msg != null);
        String s2 = msg.toString();
        IgniteUtils.log(log2, s2, s2);
    }

    public static void error(@Nullable IgniteLogger log2, Object longMsg, Object shortMsg, @Nullable Throwable e) {
        assert (longMsg != null);
        assert (shortMsg != null);
        if (log2 != null) {
            if (e == null) {
                log2.error(IgniteUtils.compact(longMsg.toString()));
            } else {
                log2.error(IgniteUtils.compact(longMsg.toString()), e);
            }
        } else {
            X.printerr("[" + SHORT_DATE_FMT.format(new Date()) + "] (err) " + IgniteUtils.compact(shortMsg.toString()), new Object[0]);
            if (e != null) {
                e.printStackTrace(System.err);
            } else {
                X.printerrln();
            }
        }
    }

    public static void error(@Nullable IgniteLogger log2, Object shortMsg, @Nullable Throwable e) {
        assert (shortMsg != null);
        String s2 = shortMsg.toString();
        IgniteUtils.error(log2, s2, s2, e);
    }

    public static void quiet(boolean err2, Object ... objs) {
        assert (objs != null);
        String time = SHORT_DATE_FMT.format(new Date());
        SB sb = new SB();
        for (Object obj : objs) {
            sb.a('[').a(time).a("] ").a(obj.toString()).a(NL);
        }
        PrintStream ps = err2 ? System.err : System.out;
        ps.print(IgniteUtils.compact(sb.toString()));
    }

    public static void quietAndInfo(IgniteLogger log2, String msg) {
        if (log2.isQuiet()) {
            U.quiet(false, msg);
        }
        if (log2.isInfoEnabled()) {
            log2.info(msg);
        }
    }

    public static void rollbackConnectionQuiet(@Nullable Connection rsrc) {
        if (rsrc != null) {
            try {
                rsrc.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static ObjectName makeMBeanName(@Nullable String igniteInstanceName, @Nullable String grp, String name) throws MalformedObjectNameException {
        SB sb = new SB(JMX_DOMAIN + ':');
        IgniteUtils.appendClassLoaderHash(sb);
        IgniteUtils.appendJvmId(sb);
        if (igniteInstanceName != null && !igniteInstanceName.isEmpty()) {
            sb.a("igniteInstanceName=").a(igniteInstanceName).a(',');
        }
        if (grp != null) {
            sb.a("group=").a(IgniteUtils.escapeObjectNameValue(grp)).a(',');
        }
        sb.a("name=").a(IgniteUtils.escapeObjectNameValue(name));
        return new ObjectName(sb.toString());
    }

    private static void appendClassLoaderHash(SB sb) {
        if (IgniteSystemProperties.getBoolean("IGNITE_MBEAN_APPEND_CLASS_LOADER_ID", true)) {
            String clsLdrHash = Integer.toHexString(Ignite.class.getClassLoader().hashCode());
            sb.a("clsLdr=").a(clsLdrHash).a(',');
        }
    }

    private static void appendJvmId(SB sb) {
        if (IgniteSystemProperties.getBoolean("IGNITE_MBEAN_APPEND_JVM_ID")) {
            String jvmId = ManagementFactory.getRuntimeMXBean().getName();
            sb.a("jvmId=").a(jvmId).a(',');
        }
    }

    public static String maskName(@Nullable String name) {
        return name == null ? "default" : name;
    }

    private static String escapeObjectNameValue(String s2) {
        if (MBEAN_CACHE_NAME_PATTERN.matcher(s2).matches()) {
            return s2;
        }
        return '\"' + s2.replaceAll("[\\\\\"?*]", "\\\\$0") + '\"';
    }

    public static <T> ObjectName registerMBean(MBeanServer mbeanSrv, @Nullable String igniteInstanceName, @Nullable String grp, String name, T impl2, @Nullable Class<T> itf) throws JMException {
        return IgniteUtils.registerMBean(mbeanSrv, IgniteUtils.makeMBeanName(igniteInstanceName, grp, name), impl2, itf);
    }

    public static <T> ObjectName registerMBean(MBeanServer mbeanSrv, ObjectName name, T impl2, Class<T> itf) throws JMException {
        if (IGNITE_MBEANS_DISABLED) {
            throw new MBeanRegistrationException(new IgniteIllegalStateException("MBeans are disabled."));
        }
        assert (mbeanSrv != null);
        assert (name != null);
        assert (itf != null);
        IgniteStandardMXBean mbean = new IgniteStandardMXBean(impl2, itf);
        mbean.getMBeanInfo();
        return mbeanSrv.registerMBean(mbean, name).getObjectName();
    }

    public static void interrupt(@Nullable Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    public static void interrupt(Iterable<? extends Thread> workers) {
        if (workers != null) {
            for (Thread thread : workers) {
                thread.interrupt();
            }
        }
    }

    public static boolean join(@Nullable Thread t, @Nullable IgniteLogger log2) {
        return IgniteUtils.join(t, log2, 0L);
    }

    public static boolean join(@Nullable Thread t, @Nullable IgniteLogger log2, long timeout) {
        if (t != null) {
            try {
                t.join(timeout);
                return !t.isAlive();
            }
            catch (InterruptedException ignore) {
                IgniteUtils.warn(log2, "Got interrupted while waiting for completion of a thread: " + t);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public static boolean joinThreads(Iterable<? extends Thread> workers, @Nullable IgniteLogger log2) {
        boolean retval = true;
        if (workers != null) {
            for (Thread thread : workers) {
                if (IgniteUtils.join(thread, log2)) continue;
                retval = false;
            }
        }
        return retval;
    }

    public static void startThreads(Iterable<? extends Thread> threads) {
        if (threads != null) {
            for (Thread thread : threads) {
                if (thread == null) continue;
                thread.start();
            }
        }
    }

    public static void cancel(@Nullable GridWorker w) {
        if (w != null) {
            w.cancel();
        }
    }

    public static void cancel(Iterable<? extends GridWorker> ws) {
        if (ws != null) {
            for (GridWorker gridWorker : ws) {
                gridWorker.cancel();
            }
        }
    }

    public static boolean join(@Nullable GridWorker w, @Nullable IgniteLogger log2) {
        if (w != null) {
            try {
                w.join();
            }
            catch (InterruptedException ignore) {
                IgniteUtils.warn(log2, "Got interrupted while waiting for completion of runnable: " + w);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public static boolean join(Iterable<? extends GridWorker> ws, IgniteLogger log2) {
        boolean retval = true;
        if (ws != null) {
            for (GridWorker gridWorker : ws) {
                if (IgniteUtils.join(gridWorker, log2)) continue;
                retval = false;
            }
        }
        return retval;
    }

    public static void shutdownNow(Class<?> owner2, @Nullable ExecutorService exec2, @Nullable IgniteLogger log2) {
        if (exec2 != null) {
            List<Runnable> tasks = exec2.shutdownNow();
            if (!F.isEmpty(tasks)) {
                U.warn(log2, "Runnable tasks outlived thread pool executor service [owner=" + IgniteUtils.getSimpleName(owner2) + ", tasks=" + tasks + ']');
            }
            try {
                exec2.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                IgniteUtils.warn(log2, "Got interrupted while waiting for executor service to stop.");
                exec2.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static ClusterGroupEmptyCheckedException emptyTopologyException() {
        return new ClusterGroupEmptyCheckedException("Cluster group is empty.");
    }

    public static void writeUuids(DataOutput out, @Nullable Collection<UUID> col) throws IOException {
        if (col != null) {
            out.writeInt(col.size());
            for (UUID id : col) {
                IgniteUtils.writeUuid(out, id);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static List<UUID> readUuids(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        ArrayList<UUID> col = new ArrayList<UUID>(size2);
        for (int i = 0; i < size2; ++i) {
            col.add(IgniteUtils.readUuid(in));
        }
        return col;
    }

    public static void writeGridUuids(DataOutput out, @Nullable Collection<IgniteUuid> col) throws IOException {
        if (col != null) {
            out.writeBoolean(true);
            out.writeInt(col.size());
            for (IgniteUuid id : col) {
                IgniteUtils.writeGridUuid(out, id);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static List<IgniteUuid> readGridUuids(DataInput in) throws IOException {
        ArrayList<IgniteUuid> col = null;
        if (in.readBoolean()) {
            int size2 = in.readInt();
            col = new ArrayList<IgniteUuid>(size2);
            for (int i = 0; i < size2; ++i) {
                col.add(IgniteUtils.readGridUuid(in));
            }
        }
        return col;
    }

    public static void writeUuid(DataOutput out, UUID uid) throws IOException {
        out.writeBoolean(uid == null);
        if (uid != null) {
            out.writeLong(uid.getMostSignificantBits());
            out.writeLong(uid.getLeastSignificantBits());
        }
    }

    @Nullable
    public static UUID readUuid(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            long most = in.readLong();
            long least = in.readLong();
            return IgniteUuidCache.onIgniteUuidRead(new UUID(most, least));
        }
        return null;
    }

    public static void writeUuid(BinaryRawWriter out, UUID uid) {
        if (uid != null) {
            out.writeBoolean(true);
            out.writeLong(uid.getMostSignificantBits());
            out.writeLong(uid.getLeastSignificantBits());
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static UUID readUuid(BinaryRawReader in) {
        if (in.readBoolean()) {
            long most = in.readLong();
            long least = in.readLong();
            return new UUID(most, least);
        }
        return null;
    }

    public static void writeGridUuid(DataOutput out, IgniteUuid uid) throws IOException {
        out.writeBoolean(uid == null);
        if (uid != null) {
            out.writeLong(uid.globalId().getMostSignificantBits());
            out.writeLong(uid.globalId().getLeastSignificantBits());
            out.writeLong(uid.localId());
        }
    }

    @Nullable
    public static IgniteUuid readGridUuid(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            long most = in.readLong();
            long least = in.readLong();
            UUID globalId = IgniteUuidCache.onIgniteUuidRead(new UUID(most, least));
            long locId = in.readLong();
            return new IgniteUuid(globalId, locId);
        }
        return null;
    }

    public static byte[] igniteUuidToBytes(IgniteUuid uuid) {
        assert (uuid != null);
        byte[] out = new byte[24];
        IgniteUtils.igniteUuidToBytes(uuid, out, 0);
        return out;
    }

    public static void igniteUuidToBytes(IgniteUuid uuid, byte[] out, int off) {
        assert (uuid != null);
        IgniteUtils.longToBytes(uuid.globalId().getMostSignificantBits(), out, off);
        IgniteUtils.longToBytes(uuid.globalId().getLeastSignificantBits(), out, off + 8);
        IgniteUtils.longToBytes(uuid.localId(), out, off + 16);
    }

    public static IgniteUuid bytesToIgniteUuid(byte[] in, int off) {
        long most = IgniteUtils.bytesToLong(in, off);
        long least = IgniteUtils.bytesToLong(in, off + 8);
        long locId = IgniteUtils.bytesToLong(in, off + 16);
        return new IgniteUuid(IgniteUuidCache.onIgniteUuidRead(new UUID(most, least)), locId);
    }

    public static void writeBooleanArray(DataOutput out, @Nullable boolean[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(arr.length);
            for (boolean b : arr) {
                out.writeBoolean(b);
            }
        }
    }

    public static void writeIntArray(DataOutput out, @Nullable int[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(arr.length);
            for (int b : arr) {
                out.writeInt(b);
            }
        }
    }

    @Nullable
    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        boolean[] res = new boolean[len];
        for (int i = 0; i < len; ++i) {
            res[i] = in.readBoolean();
        }
        return res;
    }

    @Nullable
    public static int[] readIntArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = in.readInt();
        }
        return res;
    }

    public static int hashCode(ByteBuffer ... bufs) {
        int res = 1;
        for (ByteBuffer buf : bufs) {
            int pos = buf.position();
            while (buf.hasRemaining()) {
                res = 31 * res + buf.get();
            }
            buf.position(pos);
        }
        return res;
    }

    public static void writeMap(ObjectOutput out, Map<?, ?> map2) throws IOException {
        if (map2 != null) {
            out.writeInt(map2.size());
            for (Map.Entry<?, ?> e : map2.entrySet()) {
                out.writeObject(e.getKey());
                out.writeObject(e.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static <K, V> Map<K, V> readMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>(size2, 1.0f);
        for (int i = 0; i < size2; ++i) {
            map2.put(in.readObject(), in.readObject());
        }
        return map2;
    }

    @Nullable
    public static <K, V> TreeMap<K, V> readTreeMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        TreeMap<Object, Object> map2 = new TreeMap<Object, Object>();
        for (int i = 0; i < size2; ++i) {
            map2.put(in.readObject(), in.readObject());
        }
        return map2;
    }

    @Nullable
    public static <K, V> HashMap<K, V> readHashMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashMap<Object, Object> map2 = U.newHashMap(size2);
        for (int i = 0; i < size2; ++i) {
            map2.put(in.readObject(), in.readObject());
        }
        return map2;
    }

    @Nullable
    public static <K, V> LinkedHashMap<K, V> readLinkedMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>(size2, 1.0f);
        for (int i = 0; i < size2; ++i) {
            map2.put(in.readObject(), in.readObject());
        }
        return map2;
    }

    public static void writeIntKeyMap(ObjectOutput out, Map<Integer, ?> map2) throws IOException {
        if (map2 != null) {
            out.writeInt(map2.size());
            for (Map.Entry<Integer, ?> e : map2.entrySet()) {
                out.writeInt(e.getKey());
                out.writeObject(e.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static <V> Map<Integer, V> readIntKeyMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashMap<Integer, Object> map2 = new HashMap<Integer, Object>(size2, 1.0f);
        for (int i = 0; i < size2; ++i) {
            map2.put(in.readInt(), in.readObject());
        }
        return map2;
    }

    public static void writeIntKeyIntValueMap(DataOutput out, Map<Integer, Integer> map2) throws IOException {
        if (map2 != null) {
            out.writeBoolean(true);
            out.writeInt(map2.size());
            for (Map.Entry<Integer, Integer> e : map2.entrySet()) {
                out.writeInt(e.getKey());
                out.writeInt(e.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static Map<Integer, Integer> readIntKeyIntValueMap(DataInput in) throws IOException {
        HashMap<Integer, Integer> map2 = null;
        if (in.readBoolean()) {
            int size2 = in.readInt();
            map2 = new HashMap<Integer, Integer>(size2, 1.0f);
            for (int i = 0; i < size2; ++i) {
                map2.put(in.readInt(), in.readInt());
            }
        }
        return map2;
    }

    @Nullable
    public static <E> List<E> readList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        ArrayList<Object> col = new ArrayList<Object>(size2);
        for (int i = 0; i < size2; ++i) {
            col.add(in.readObject());
        }
        return col;
    }

    @Nullable
    public static List<Integer> readIntList(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        ArrayList<Integer> col = new ArrayList<Integer>(size2);
        for (int i = 0; i < size2; ++i) {
            col.add(in.readInt());
        }
        return col;
    }

    @Nullable
    public static <E> Set<E> readSet(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>(size2, 1.0f);
        for (int i = 0; i < size2; ++i) {
            set.add(in.readObject());
        }
        return set;
    }

    @Nullable
    public static Set<Integer> readIntSet(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashSet<Integer> set = new HashSet<Integer>(size2, 1.0f);
        for (int i = 0; i < size2; ++i) {
            set.add(in.readInt());
        }
        return set;
    }

    public static void writeString(DataOutput out, String s2) throws IOException {
        out.writeBoolean(s2 == null);
        if (s2 != null) {
            out.writeUTF(s2);
        }
    }

    @Nullable
    public static String readString(DataInput in) throws IOException {
        return !in.readBoolean() ? in.readUTF() : null;
    }

    public static <E extends Enum> void writeEnum(DataOutput out, E e) throws IOException {
        out.writeByte(e == null ? -1 : e.ordinal());
    }

    public static <T> T getByIndex(Collection<T> vals, int idx) {
        assert (idx < vals.size());
        int i = 0;
        for (T val : vals) {
            if (idx == i) {
                return val;
            }
            ++i;
        }
        assert (false) : "Should never be reached.";
        return null;
    }

    @Nullable
    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annCls) {
        if (cls == Object.class) {
            return null;
        }
        T ann = cls.getAnnotation(annCls);
        if (ann != null) {
            return ann;
        }
        for (Class<?> itf : cls.getInterfaces()) {
            ann = IgniteUtils.getAnnotation(itf, annCls);
            if (ann == null) continue;
            return ann;
        }
        if (!cls.isInterface() && (ann = IgniteUtils.getAnnotation(cls.getSuperclass(), annCls)) != null) {
            return ann;
        }
        return null;
    }

    @Nullable
    public static <T extends Annotation> T getDeclaredAnnotation(Class<?> cls, Class<T> annCls) {
        if (cls == Object.class) {
            return null;
        }
        return cls.getDeclaredAnnotation(annCls);
    }

    public static <T extends Annotation> boolean hasDeclaredAnnotation(Class<?> cls, Class<T> annCls) {
        return IgniteUtils.getDeclaredAnnotation(cls, annCls) != null;
    }

    public static <T extends Annotation> boolean hasDeclaredAnnotation(Object o, Class<T> annCls) {
        return o != null && IgniteUtils.hasDeclaredAnnotation(o.getClass(), annCls);
    }

    public static <T extends Annotation> boolean hasAnnotation(Class<?> cls, Class<T> annCls) {
        return IgniteUtils.getAnnotation(cls, annCls) != null;
    }

    public static <T extends Annotation> boolean hasAnnotation(Object o, Class<T> annCls) {
        return o != null && IgniteUtils.hasAnnotation(o.getClass(), annCls);
    }

    public static String getSimpleName(Class<?> cls) {
        String name = cls.getSimpleName();
        if (F.isEmpty(name)) {
            name = cls.getName().substring(cls.getPackage().getName().length() + 1);
        }
        return name;
    }

    public static boolean containsAll(Map<?, ?> base, Map<?, ?> map2) {
        assert (base != null);
        assert (map2 != null);
        for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
            if (base.containsKey(entry2.getKey())) {
                Object val = base.get(entry2.getKey());
                if (val == null && entry2.getValue() == null || val != null && entry2.getValue() != null && val.equals(entry2.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String getTaskName(Class<? extends ComputeTask<?, ?>> taskCls) {
        ComputeTaskName nameAnn = IgniteUtils.getAnnotation(taskCls, ComputeTaskName.class);
        return nameAnn == null ? taskCls.getName() : nameAnn.value();
    }

    public static String spiAttribute(IgniteSpi spi, String attrName) {
        assert (spi != null);
        assert (spi.getName() != null);
        return spi.getName() + '.' + attrName;
    }

    public static String classNameToResourceName(String clsName) {
        return clsName.replaceAll("\\.", "/") + ".class";
    }

    public static RuntimeMXBean getRuntimeMx() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static ThreadMXBean getThreadMx() {
        return ManagementFactory.getThreadMXBean();
    }

    public static OperatingSystemMXBean getOsMx() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static MemoryMXBean getMemoryMx() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static long getTotalMemoryAvailable() {
        Object attr;
        MBeanServer mBeanSrv = ManagementFactory.getPlatformMBeanServer();
        try {
            attr = mBeanSrv.getAttribute(ObjectName.getInstance("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        }
        catch (Exception e) {
            return -1L;
        }
        return attr instanceof Long ? (Long)attr : -1L;
    }

    public static CompilationMXBean getCompilerMx() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static Class<?> detectClass(Object obj) {
        Map.Entry e;
        assert (obj != null);
        if (obj instanceof GridPeerDeployAware) {
            return ((GridPeerDeployAware)obj).deployClass();
        }
        if (U.isPrimitiveArray(obj)) {
            return obj.getClass();
        }
        if (!U.isJdk(obj.getClass())) {
            return obj.getClass();
        }
        if (obj instanceof Iterable) {
            Object o = F.first((Iterable)obj);
            return o != null ? o.getClass() : obj.getClass();
        }
        if (obj instanceof Map && (e = F.firstEntry((Map)obj)) != null) {
            Object k = e.getKey();
            if (k != null && !U.isJdk(k.getClass())) {
                return k.getClass();
            }
            Object v = e.getValue();
            return v != null ? v.getClass() : obj.getClass();
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            if (len > 0) {
                Object o = Array.get(obj, 0);
                return o != null ? o.getClass() : obj.getClass();
            }
            return obj.getClass().getComponentType();
        }
        return obj.getClass();
    }

    public static ClassLoader detectClassLoader(Class<?> cls) {
        return GridClassLoaderCache.classLoader(cls);
    }

    @Nullable
    public static ClassLoader detectObjectClassLoader(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GridPeerDeployAware) {
            return ((GridPeerDeployAware)obj).classLoader();
        }
        return IgniteUtils.detectClassLoader(obj.getClass());
    }

    public static boolean isLoadableBy(String clsName, @Nullable ClassLoader ldr) {
        assert (clsName != null);
        if (ldr == null) {
            ldr = gridClassLoader;
        }
        String lambdaParent = U.lambdaEnclosingClassName(clsName);
        try {
            ldr.loadClass(lambdaParent == null ? clsName : lambdaParent);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static GridPeerDeployAware peerDeployAware0(@Nullable Iterable<?> c) {
        if (!F.isEmpty(c)) {
            assert (c != null);
            ArrayList<Object> tmpC = new ArrayList<Object>();
            for (Object e : c) {
                tmpC.add(e);
            }
            tmpC.add(c);
            boolean notAllNulls = false;
            for (Object e : tmpC) {
                if (e == null) continue;
                notAllNulls = true;
                if (!IgniteUtils.hasCommonClassLoader(e, tmpC)) continue;
                return e == c ? IgniteUtils.peerDeployAware(e) : IgniteUtils.peerDeployAware0(e);
            }
            if (notAllNulls) {
                throw new IllegalArgumentException("Failed to find common class loader for all elements in given collection. Peer deployment cannot be performed for such collection.");
            }
        }
        return IgniteUtils.peerDeployAware(c);
    }

    private static boolean hasCommonClassLoader(Object obj, Iterable<?> c) {
        assert (obj != null);
        assert (c != null);
        ClassLoader ldr = obj instanceof GridPeerDeployAware ? ((GridPeerDeployAware)obj).classLoader() : IgniteUtils.detectClassLoader(obj.getClass());
        boolean found = true;
        for (Object obj2 : c) {
            String clsName;
            if (obj2 == null || obj2 == obj || IgniteUtils.isLoadableBy(clsName = obj2 instanceof GridPeerDeployAware ? ((GridPeerDeployAware)obj2).deployClass().getName() : obj2.getClass().getName(), ldr)) continue;
            found = false;
            break;
        }
        return found;
    }

    public static GridPeerDeployAware peerDeployAware0(Object ... c) {
        if (!F.isEmpty(c)) {
            assert (c != null);
            boolean notAllNulls = false;
            for (Object obj : c) {
                if (obj == null) continue;
                notAllNulls = true;
                ClassLoader ldr = obj instanceof GridPeerDeployAware ? ((GridPeerDeployAware)obj).classLoader() : obj.getClass().getClassLoader();
                boolean found = true;
                for (Object obj2 : c) {
                    String clsName;
                    if (obj2 == null || obj2 == obj) continue;
                    String string2 = clsName = obj2 instanceof GridPeerDeployAware ? ((GridPeerDeployAware)obj2).deployClass().getName() : obj2.getClass().getName();
                    if (IgniteUtils.isLoadableBy(clsName, ldr)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return IgniteUtils.peerDeployAware0(obj);
            }
            if (notAllNulls) {
                throw new IllegalArgumentException("Failed to find common class loader for all elements in given collection. Peer deployment cannot be performed for such collection.");
            }
        }
        return IgniteUtils.peerDeployAware(new Object[0]);
    }

    public static GridPeerDeployAware peerDeployAware0(Object obj) {
        if (obj instanceof Iterable) {
            return IgniteUtils.peerDeployAware0((Iterable)obj);
        }
        if (obj.getClass().isArray() && !U.isPrimitiveArray(obj)) {
            return IgniteUtils.peerDeployAware0((Object[])obj);
        }
        return IgniteUtils.peerDeployAware(obj);
    }

    public static GridPeerDeployAware peerDeployAware(Object obj) {
        assert (obj != null);
        if (obj instanceof GridPeerDeployAware) {
            return (GridPeerDeployAware)obj;
        }
        final Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        return new GridPeerDeployAware(){
            private ClassLoader ldr;

            @Override
            public Class<?> deployClass() {
                return cls;
            }

            @Override
            public ClassLoader classLoader() {
                if (this.ldr == null) {
                    this.ldr = IgniteUtils.detectClassLoader(cls);
                }
                return this.ldr;
            }
        };
    }

    public static GridPeerDeployAware detectPeerDeployAware(GridPeerDeployAware obj) {
        GridPeerDeployAware p = IgniteUtils.nestedPeerDeployAware(obj, true, new GridLeanIdentitySet<Object>());
        return p != null ? p : IgniteUtils.peerDeployAware(obj.getClass());
    }

    @Nullable
    private static GridPeerDeployAware nestedPeerDeployAware(Object obj, boolean top, Set<Object> processed) {
        block14: {
            Object[] arr;
            Class<?> type;
            block15: {
                block13: {
                    if (!processed.add(obj)) {
                        return null;
                    }
                    if (!(obj instanceof GridPeerDeployAware)) break block13;
                    GridPeerDeployAware p = (GridPeerDeployAware)obj;
                    if (!top && p.deployClass() != null) {
                        return p;
                    }
                    Class<?> cls = obj.getClass();
                    while (!cls.equals(Object.class)) {
                        List<Field> fields;
                        IgniteBiTuple tup = (IgniteBiTuple)p2pFields.get(cls.getName());
                        boolean cached = tup != null && ((Class)tup.get1()).equals(cls);
                        List<Field> list2 = fields = cached ? (List<Field>)tup.get2() : Arrays.asList(cls.getDeclaredFields());
                        if (!cached) {
                            tup = new IgniteBiTuple();
                            tup.set1(cls);
                        }
                        for (Field f2 : fields) {
                            if (!cached && !f2.getName().startsWith("this$") && !f2.getName().startsWith("val$")) continue;
                            if (!cached) {
                                f2.setAccessible(true);
                                if (tup.get2() == null) {
                                    tup.set2(new LinkedList());
                                }
                                ((Collection)tup.get2()).add(f2);
                            }
                            try {
                                Object o = f2.get(obj);
                                if (o == null || (p = IgniteUtils.nestedPeerDeployAware(o, false, processed)) == null) continue;
                                if (!cached) {
                                    p2pFields.put(cls.getName(), tup);
                                }
                                return p;
                            }
                            catch (IllegalAccessException ignored) {
                                return null;
                            }
                        }
                        cls = cls.getSuperclass();
                    }
                    break block14;
                }
                if (IgniteUtils.isIgnite(obj.getClass())) {
                    return null;
                }
                if (!(obj instanceof Iterable)) break block15;
                for (Object o : (Iterable)obj) {
                    GridPeerDeployAware p = IgniteUtils.nestedPeerDeployAware(o, false, processed);
                    if (p == null) continue;
                    return p;
                }
                break block14;
            }
            if (!obj.getClass().isArray() || (type = obj.getClass().getComponentType()).isPrimitive() || IgniteUtils.isJdk(type)) break block14;
            for (Object o : arr = (Object[])obj) {
                GridPeerDeployAware p = IgniteUtils.nestedPeerDeployAware(o, false, processed);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    public static boolean isIgnite(Class<?> cls) {
        String name = cls.getName();
        return name.startsWith("org.apache.ignite") || name.startsWith("org.jsr166");
    }

    public static boolean isGrid(Class<?> cls) {
        return cls.getName().startsWith("org.apache.ignite.internal");
    }

    public static String compact(String s2) {
        return s2.replace("org.apache.ignite.internal.visor.", "o.a.i.i.v.").replace("org.apache.ignite.internal.", "o.a.i.i.").replace("org.apache.ignite.scalar.", "o.a.i.s.").replace("org.apache.ignite.", "o.a.i.");
    }

    public static boolean isJdk(Class<?> cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        String s2 = cls.getName();
        return s2.startsWith("java.") || s2.startsWith("javax.");
    }

    public static boolean isEnum(Class cls) {
        if (cls.isEnum()) {
            return true;
        }
        Class sCls = cls.getSuperclass();
        return sCls != null && sCls.isEnum();
    }

    public static void wait(Object mux) throws IgniteInterruptedCheckedException {
        try {
            mux.wait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(File zipFile, File toDir, @Nullable IgniteLogger log2) throws IOException {
        try (ZipFile zip2 = null;){
            zip2 = new ZipFile(zipFile);
            for (ZipEntry zipEntry : IgniteUtils.asIterable(zip2.entries())) {
                if (zipEntry.isDirectory()) {
                    new File(toDir, zipEntry.getName()).mkdirs();
                    continue;
                }
                InputStream in = null;
                BufferedOutputStream out = null;
                try {
                    in = zip2.getInputStream(zipEntry);
                    File outFile = new File(toDir, zipEntry.getName());
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outFile));
                    IgniteUtils.copy(in, out);
                }
                catch (Throwable throwable2) {
                    IgniteUtils.close(in, log2);
                    IgniteUtils.close(out, log2);
                    throw throwable2;
                    return;
                }
                IgniteUtils.close(in, log2);
                IgniteUtils.close(out, log2);
            }
        }
    }

    public static boolean assertionsEnabled() {
        return assertionsEnabled;
    }

    public static String osJdkString() {
        return osJdkStr;
    }

    public static String osString() {
        return osStr;
    }

    public static String jdkString() {
        return jdkStr;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static String jdkName() {
        return jdkName;
    }

    public static String jdkVendor() {
        return jdkVendor;
    }

    public static String jdkVersion() {
        return jdkVer;
    }

    public static String osArchitecture() {
        return osArch;
    }

    public static String osName() {
        return osName;
    }

    public static String osVersion() {
        return osVer;
    }

    public static boolean isMacOs() {
        return mac;
    }

    public static boolean isRedHat() {
        return redHat;
    }

    public static boolean isNetWare() {
        return netware;
    }

    public static boolean isSolaris() {
        return solaris;
    }

    public static boolean isSolarisSparc() {
        return solaris && sparc;
    }

    public static boolean isSolarisX86() {
        return solaris && x86;
    }

    public static boolean isUnix() {
        return unix;
    }

    public static boolean isWindows() {
        return win7 || win8 || win81 || winXp || win95 || win98 || winNt || win2k || win2003 || win2008 || winVista || unknownWin;
    }

    public static boolean isWindowsVista() {
        return winVista;
    }

    public static boolean isWindows7() {
        return win7;
    }

    public static boolean isWindows8() {
        return win8;
    }

    public static boolean isWindows81() {
        return win81;
    }

    public static boolean isWindows2k() {
        return win2k;
    }

    public static boolean isWindows2003() {
        return win2003;
    }

    public static boolean isWindows2008() {
        return win2008;
    }

    public static boolean isWindows95() {
        return win95;
    }

    public static boolean isWindows98() {
        return win98;
    }

    public static boolean isWindowsNt() {
        return winNt;
    }

    public static boolean isSufficientlyTestedOs() {
        return win7 || win8 || win81 || winXp || winVista || mac || linux || solaris;
    }

    public static boolean isWindowsXp() {
        return winXp;
    }

    public static String jvmSpec() {
        return jvmSpecName;
    }

    public static String jvmVersion() {
        return jvmImplVer;
    }

    public static String jvmVendor() {
        return jvmImplVendor;
    }

    public static String jvmName() {
        return jvmImplName;
    }

    public static boolean jvm32Bit() {
        return jvm32Bit;
    }

    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            int cmp;
            String p1 = part1[idx];
            String p2 = part2[idx];
            int n = cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : p1.compareTo(p2);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        return part1.length > idx ? 1 : -1;
    }

    public static IgniteProductVersion productVersion(ClusterNode node) {
        String verStr = (String)node.attribute("org.apache.ignite.build.ver");
        String buildDate = (String)node.attribute("org.apache.ignite.build.date");
        if (buildDate != null) {
            verStr = verStr + '-' + buildDate;
        }
        return IgniteProductVersion.fromString(verStr);
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return IgniteUtils.compareVersionNumbers(javaRtVer, v) >= 0;
    }

    public static String jreName() {
        return javaRtName;
    }

    public static String jreVersion() {
        return javaRtVer;
    }

    public static int majorJavaVersion(String verStr) {
        if (F.isEmpty(verStr)) {
            return 0;
        }
        try {
            String[] parts = verStr.split("\\.");
            int major = Integer.parseInt(parts[0]);
            if (parts.length == 1) {
                return major;
            }
            int minor = Integer.parseInt(parts[1]);
            return major == 1 ? minor : major;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isHotSpot() {
        return jvmImplName.contains("Java HotSpot(TM)");
    }

    @Nullable
    public static <R> R wrapThreadLoader(ClassLoader ldr, Callable<R> c) throws IgniteCheckedException {
        Thread curThread = Thread.currentThread();
        ClassLoader ctxLdr = curThread.getContextClassLoader();
        try {
            curThread.setContextClassLoader(ldr);
            R r = c.call();
            return r;
        }
        catch (RuntimeException | IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
        finally {
            curThread.setContextClassLoader(ctxLdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <R> R wrapThreadLoader(ClassLoader ldr, IgniteOutClosure<R> c) {
        Thread curThread = Thread.currentThread();
        ClassLoader ctxLdr = curThread.getContextClassLoader();
        try {
            curThread.setContextClassLoader(ldr);
            R r = c.apply();
            return r;
        }
        finally {
            curThread.setContextClassLoader(ctxLdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapThreadLoader(ClassLoader ldr, Runnable c) {
        Thread curThread = Thread.currentThread();
        ClassLoader ctxLdr = curThread.getContextClassLoader();
        try {
            curThread.setContextClassLoader(ldr);
            c.run();
        }
        finally {
            curThread.setContextClassLoader(ctxLdr);
        }
    }

    public static String toShortString(ClusterNode n) {
        return "ClusterNode [id=" + n.id() + ", order=" + n.order() + ", addr=" + n.addresses() + ", daemon=" + n.isDaemon() + ']';
    }

    public static String toShortString(Collection<? extends ClusterNode> ns) {
        SB sb = new SB("Grid nodes [cnt=" + ns.size());
        for (ClusterNode clusterNode : ns) {
            sb.a(", ").a(IgniteUtils.toShortString(clusterNode));
        }
        return sb.a(']').toString();
    }

    public static int[] toIntArray(@Nullable Collection<Integer> c) {
        if (c == null || c.isEmpty()) {
            return EMPTY_INTS;
        }
        int[] arr = new int[c.size()];
        int idx = 0;
        for (Integer i : c) {
            arr[idx++] = i;
        }
        return arr;
    }

    public static int[] addAll(int[] arr1, int[] arr2) {
        int[] all = new int[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, all, 0, arr1.length);
        System.arraycopy(arr2, 0, all, arr1.length, arr2.length);
        return all;
    }

    public static List<Integer> toIntList(@Nullable int[] arr, IgnitePredicate<Integer> ... p) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(arr.length);
        if (F.isEmpty(p)) {
            for (int i : arr) {
                ret.add(i);
            }
        } else {
            for (int i : arr) {
                if (!F.isAll(i, p)) continue;
                ret.add(i);
            }
        }
        return ret;
    }

    public static long[] toLongArray(@Nullable Collection<Long> c) {
        if (c == null || c.isEmpty()) {
            return EMPTY_LONGS;
        }
        long[] arr = new long[c.size()];
        int idx = 0;
        for (Long l : c) {
            arr[idx++] = l;
        }
        return arr;
    }

    public static List<Long> toLongList(@Nullable long[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> ret = new ArrayList<Long>(arr.length);
        for (long l : arr) {
            ret.add(l);
        }
        return ret;
    }

    public static <T> T[] toArray(Collection<? extends T> c, T[] arr) {
        T[] a = c.toArray(arr);
        assert (a == arr);
        return arr;
    }

    public static void swap(Object[] arr, int a, int b) {
        Object tmp = arr[a];
        arr[a] = arr[b];
        arr[b] = tmp;
    }

    public static int[] unique(int[] a, int aLen, int[] b, int bLen) {
        assert (a != null);
        assert (b != null);
        assert (IgniteUtils.isIncreasingArray(a, aLen));
        assert (IgniteUtils.isIncreasingArray(b, bLen));
        int[] res = new int[aLen + bLen];
        int resLen = 0;
        int i = 0;
        int j = 0;
        while (i < aLen && j < bLen) {
            if (a[i] == b[j]) {
                ++i;
                continue;
            }
            if (a[i] < b[j]) {
                res[resLen++] = a[i++];
                continue;
            }
            res[resLen++] = b[j++];
        }
        while (i < aLen) {
            res[resLen++] = a[i++];
        }
        while (j < bLen) {
            res[resLen++] = b[j++];
        }
        return IgniteUtils.copyIfExceeded(res, resLen);
    }

    public static int[] difference(int[] a, int aLen, int[] b, int bLen) {
        assert (a != null);
        assert (b != null);
        assert (IgniteUtils.isIncreasingArray(a, aLen));
        assert (IgniteUtils.isIncreasingArray(b, bLen));
        int[] res = new int[aLen];
        int resLen = 0;
        int i = 0;
        int j = 0;
        while (i < aLen && j < bLen) {
            if (a[i] == b[j]) {
                ++i;
                continue;
            }
            if (a[i] < b[j]) {
                res[resLen++] = a[i++];
                continue;
            }
            ++j;
        }
        while (i < aLen) {
            res[resLen++] = a[i++];
        }
        return IgniteUtils.copyIfExceeded(res, resLen);
    }

    public static boolean isIncreasingArray(int[] arr, int len) {
        assert (arr != null);
        assert (0 <= len && len <= arr.length);
        if (arr.length == 0) {
            return true;
        }
        for (int i = 1; i < len; ++i) {
            if (arr[i - 1] < arr[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNonDecreasingArray(int[] arr, int len) {
        assert (arr != null);
        assert (0 <= len && len <= arr.length);
        if (arr.length == 0) {
            return true;
        }
        for (int i = 1; i < len; ++i) {
            if (arr[i - 1] <= arr[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] copyIfExceeded(int[] arr, int len) {
        assert (arr != null);
        assert (0 <= len && len <= arr.length);
        return len == arr.length ? arr : Arrays.copyOf(arr, len);
    }

    private static boolean checkNextToken(StringTokenizer t, String str, String date) throws IgniteCheckedException {
        try {
            if (t.nextToken().equals(str)) {
                return true;
            }
            throw new IgniteCheckedException("Invalid date format: " + date);
        }
        catch (NoSuchElementException ignored) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Calendar parseIsoDate(String str) throws IgniteCheckedException {
        StringTokenizer t = new StringTokenizer(str, "+-:.TZ", true);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        try {
            if (!t.hasMoreTokens()) {
                return cal;
            }
            cal.set(1, Integer.parseInt(t.nextToken()));
            if (!IgniteUtils.checkNextToken(t, "-", str) || !t.hasMoreTokens()) {
                return cal;
            }
            cal.set(2, Integer.parseInt(t.nextToken()) - 1);
            if (!IgniteUtils.checkNextToken(t, "-", str) || !t.hasMoreTokens()) {
                return cal;
            }
            cal.set(5, Integer.parseInt(t.nextToken()));
            if (!IgniteUtils.checkNextToken(t, "T", str) || !t.hasMoreTokens()) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal;
            }
            cal.set(11, Integer.parseInt(t.nextToken()));
            if (!IgniteUtils.checkNextToken(t, ":", str) || !t.hasMoreTokens()) {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal;
            }
            cal.set(12, Integer.parseInt(t.nextToken()));
            if (!t.hasMoreTokens()) {
                return cal;
            }
            String tok = t.nextToken();
            if (":".equals(tok)) {
                if (!t.hasMoreTokens()) throw new IgniteCheckedException("Invalid date format: " + str);
                cal.set(13, Integer.parseInt(t.nextToken()));
                if (!t.hasMoreTokens()) {
                    return cal;
                }
                tok = t.nextToken();
                if (".".equals(tok)) {
                    String nt = t.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + DFLT_USER_VERSION;
                    }
                    nt = nt.substring(0, 3);
                    cal.set(14, Integer.parseInt(nt));
                    if (!t.hasMoreTokens()) {
                        return cal;
                    }
                    tok = t.nextToken();
                } else {
                    cal.set(14, 0);
                }
            } else {
                cal.set(13, 0);
                cal.set(14, 0);
            }
            if (!"Z".equals(tok)) {
                int tzMin;
                int tzHour;
                if (!"+".equals(tok) && !"-".equals(tok)) {
                    throw new IgniteCheckedException("Invalid date format: " + str);
                }
                boolean plus2 = "+".equals(tok);
                if (!t.hasMoreTokens()) {
                    throw new IgniteCheckedException("Invalid date format: " + str);
                }
                tok = t.nextToken();
                if (tok.length() == 4) {
                    tzHour = Integer.parseInt(tok.substring(0, 2));
                    tzMin = Integer.parseInt(tok.substring(2, 4));
                } else {
                    tzHour = Integer.parseInt(tok);
                    if (!IgniteUtils.checkNextToken(t, ":", str) || !t.hasMoreTokens()) throw new IgniteCheckedException("Invalid date format: " + str);
                    tzMin = Integer.parseInt(t.nextToken());
                }
                if (plus2) {
                    cal.set(15, (tzHour * 60 + tzMin) * 60 * 1000);
                    return cal;
                } else {
                    cal.set(15, -(tzHour * 60 + tzMin) * 60 * 1000);
                }
                return cal;
            } else {
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            return cal;
        }
        catch (NumberFormatException ex) {
            throw new IgniteCheckedException("Invalid date format: " + str, ex);
        }
    }

    public static <V, C extends Collection<? super V>> C addAll(C c, V ... vals) {
        Collections.addAll(c, vals);
        return c;
    }

    public static <K, V, M extends Map<K, V>> M addAll(M m, Map.Entry<K, V> ... entries) {
        for (Map.Entry<K, V> e : entries) {
            m.put(e.getKey(), e.getValue());
        }
        return m;
    }

    public static <K, V, M extends Map<K, V>> M addAll(M m, IgniteBiTuple<K, V> ... entries) {
        for (IgniteBiTuple<K, V> t : entries) {
            m.put(t.get1(), t.get2());
        }
        return m;
    }

    public static JMException jmException(Throwable e) {
        JMException x = new JMException();
        x.initCause(e);
        return x;
    }

    public static Exception unwrap(Throwable t) {
        assert (t != null);
        while (true) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof GridClosureException)) break;
            t = ((GridClosureException)t).unwrap();
        }
        return (Exception)t;
    }

    public static IgniteCheckedException cast(Throwable t) {
        assert (t != null);
        return (t = IgniteUtils.unwrap(t)) instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException(t);
    }

    public static Date parse(String src, String ptrn) throws ParseException {
        SimpleDateFormat format2 = new SimpleDateFormat(ptrn);
        return format2.parse(src);
    }

    public static boolean p2pLoader(Object o) {
        return o != null && IgniteUtils.p2pLoader(o.getClass().getClassLoader());
    }

    public static boolean p2pLoader(ClassLoader ldr) {
        return ldr instanceof GridDeploymentInfo;
    }

    public static String format(Date date, String ptrn) {
        SimpleDateFormat format2 = new SimpleDateFormat(ptrn);
        return format2.format(date);
    }

    public static IgniteClosure<UUID, ClusterNode> id2Node(final GridKernalContext ctx) {
        assert (ctx != null);
        return new C1<UUID, ClusterNode>(){

            @Override
            @Nullable
            public ClusterNode apply(UUID id) {
                return ctx.discovery().node(id);
            }
        };
    }

    @Deprecated
    public static void dumpStack(Thread t) {
        IgniteUtils.dumpStack(t, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void dumpStack(Thread t, PrintStream s2) {
        PrintStream printStream = s2;
        synchronized (printStream) {
            s2.println("Dumping stack trace for thread: " + t);
            for (StackTraceElement trace : t.getStackTrace()) {
                s2.println("\tat " + trace);
            }
        }
    }

    public static boolean isPrimitiveArray(Object obj) {
        Class<?> cls = obj.getClass();
        return cls.isArray() && cls.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveOrWrapper(Class<?> cls) {
        return cls.isPrimitive() || Boolean.class.equals(cls) || Byte.class.equals(cls) || Character.class.equals(cls) || Short.class.equals(cls) || Integer.class.equals(cls) || Long.class.equals(cls) || Float.class.equals(cls) || Double.class.equals(cls) || Void.class.equals(cls);
    }

    public static void await(Condition cond) throws IgniteInterruptedCheckedException {
        try {
            cond.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static void awaitQuiet(Condition cond) {
        cond.awaitUninterruptibly();
    }

    public static boolean await(Condition cond, long time, TimeUnit unit) throws IgniteInterruptedCheckedException {
        try {
            return cond.await(time, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static void await(CountDownLatch latch) throws IgniteInterruptedCheckedException {
        try {
            if (latch.getCount() > 0L) {
                latch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static boolean await(CountDownLatch latch, long timeout, TimeUnit unit) throws IgniteInterruptedCheckedException {
        try {
            return latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static void awaitQuiet(CountDownLatch latch) {
        boolean interrupted = false;
        while (true) {
            try {
                latch.await();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void awaitQuiet(CyclicBarrier barrier) {
        boolean interrupted = false;
        while (true) {
            try {
                barrier.await();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
                continue;
            }
            catch (BrokenBarrierException ignored) {
                // empty catch block
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL[] classLoaderUrls(ClassLoader clsLdr) {
        if (clsLdr == null) {
            return EMPTY_URL_ARR;
        }
        if (clsLdr instanceof URLClassLoader) {
            return ((URLClassLoader)clsLdr).getURLs();
        }
        if (bltClsLdrCls != null && urlClsLdrField != null && bltClsLdrCls.isAssignableFrom(clsLdr.getClass())) {
            try {
                Field field2 = urlClsLdrField;
                synchronized (field2) {
                    boolean accessible = urlClsLdrField.isAccessible();
                    try {
                        Object ucp;
                        if (!accessible) {
                            urlClsLdrField.setAccessible(true);
                        }
                        if ((ucp = urlClsLdrField.get(clsLdr)) instanceof URLClassLoader) {
                            URL[] uRLArray = ((URLClassLoader)ucp).getURLs();
                            return uRLArray;
                        }
                        if (clsURLClassPath != null && clsURLClassPath.isInstance(ucp)) {
                            URL[] uRLArray = (URL[])mthdURLClassPathGetUrls.invoke(ucp, new Object[0]);
                            return uRLArray;
                        }
                        throw new RuntimeException("Unknown classloader: " + clsLdr.getClass());
                    }
                    finally {
                        if (!accessible) {
                            urlClsLdrField.setAccessible(false);
                        }
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace(System.err);
                return EMPTY_URL_ARR;
            }
        }
        return EMPTY_URL_ARR;
    }

    @Nullable
    private static Class defaultClassLoaderClass() {
        try {
            return Class.forName("jdk.internal.loader.BuiltinClassLoader");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Field urlClassLoaderField() {
        try {
            Class cls = IgniteUtils.defaultClassLoaderClass();
            return cls == null ? null : cls.getDeclaredField("ucp");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static void sleep(long ms) throws IgniteInterruptedCheckedException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static void join(GridWorker w) throws IgniteInterruptedCheckedException {
        try {
            if (w != null) {
                w.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static <T> T get(Future<T> fut) throws IgniteCheckedException {
        try {
            return fut.get();
        }
        catch (ExecutionException e) {
            throw new IgniteCheckedException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
        catch (CancellationException e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static void join(@Nullable Thread t) throws IgniteInterruptedCheckedException {
        if (t == null) {
            return;
        }
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static void acquire(Semaphore sem) throws IgniteInterruptedCheckedException {
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static boolean tryAcquire(Semaphore sem, long timeout, TimeUnit unit) throws IgniteInterruptedCheckedException {
        try {
            return sem.tryAcquire(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static GridCacheAttributes[] cacheAttributes(ClusterNode n) {
        return (GridCacheAttributes[])n.attribute("org.apache.ignite.cache");
    }

    public static boolean hasNearCache(ClusterNode n, String cacheName) {
        GridCacheAttributes[] caches = (GridCacheAttributes[])n.attribute("org.apache.ignite.cache");
        if (caches != null) {
            for (GridCacheAttributes attrs : caches) {
                if (!F.eq(cacheName, attrs.cacheName())) continue;
                return attrs.nearCacheEnabled();
            }
        }
        return false;
    }

    public static void asyncLogError(IgniteInternalFuture<?> f2, final IgniteLogger log2) {
        if (f2 != null) {
            f2.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f2) {
                    try {
                        f2.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log2, "Failed to execute future: " + f2, e);
                    }
                }
            });
        }
    }

    public static Collection<UUID> nodeIds(@Nullable Collection<? extends ClusterNode> nodes2) {
        return F.viewReadOnly(nodes2, F.node2id(), new IgnitePredicate[0]);
    }

    public static Collection<UUID> gridIds(@Nullable Collection<? extends Ignite> grids) {
        return F.viewReadOnly(grids, new C1<Ignite, UUID>(){

            @Override
            public UUID apply(Ignite g) {
                return g.cluster().localNode().id();
            }
        }, new IgnitePredicate[0]);
    }

    public static Collection<String> grids2names(@Nullable Collection<? extends Ignite> grids) {
        return F.viewReadOnly(grids, new C1<Ignite, String>(){

            @Override
            public String apply(Ignite g) {
                return g.name();
            }
        }, new IgnitePredicate[0]);
    }

    public static Collection<String> nodes2names(@Nullable Collection<? extends ClusterNode> nodes2) {
        return F.viewReadOnly(nodes2, new C1<ClusterNode, String>(){

            @Override
            public String apply(ClusterNode n) {
                return G.ignite(n.id()).name();
            }
        }, new IgnitePredicate[0]);
    }

    public static boolean addLastCause(@Nullable Throwable e, @Nullable Throwable cause, IgniteLogger log2) {
        if (e == null || cause == null) {
            return false;
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (t == cause) {
                return false;
            }
            if (t.getCause() != null && t.getCause() != t) continue;
            try {
                t.initCause(cause);
            }
            catch (IllegalStateException ignored) {
                IgniteUtils.error(log2, "Failed to add cause to the end of cause chain (cause is printed here but will not be propagated to callee): " + e, "Failed to add cause to the end of cause chain: " + e, cause);
            }
            return true;
        }
        return false;
    }

    public static String nl() {
        return NL;
    }

    public static IgniteLogger logger(GridKernalContext ctx, AtomicReference<IgniteLogger> logRef, Object obj) {
        IgniteLogger log2 = logRef.get();
        if (log2 == null) {
            logRef.compareAndSet(null, ctx.log(obj.getClass()));
            log2 = logRef.get();
        }
        return log2;
    }

    public static IgniteLogger logger(GridKernalContext ctx, AtomicReference<IgniteLogger> logRef, Class<?> cls) {
        IgniteLogger log2 = logRef.get();
        if (log2 == null) {
            logRef.compareAndSet(null, ctx.log(cls));
            log2 = logRef.get();
        }
        return log2;
    }

    public static int concurrentMapSegment(int hash, int concurLvl) {
        int size2;
        hash += hash << 15 ^ 0xFFFFCD7D;
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += (hash << 2) + (hash << 14);
        int shift = 0;
        for (size2 = 1; size2 < concurLvl; size2 <<= 1) {
            ++shift;
        }
        int segmentShift = 32 - shift;
        int segmentMask = size2 - 1;
        return hash >>> segmentShift & segmentMask;
    }

    public static <K, V> void printConcurrentHashMapInfo(ConcurrentHashMap<K, V> map2) {
        assert (map2 != null);
        Object[] segs = (Object[])IgniteUtils.field(map2, "segments");
        X.println("Concurrent map stats [identityHash= " + System.identityHashCode(map2) + ", segsCnt=" + segs.length + ']', new Object[0]);
        int emptySegsCnt = 0;
        int totalCollisions = 0;
        for (int i = 0; i < segs.length; ++i) {
            int segCnt = (Integer)IgniteUtils.field(segs[i], "count");
            if (segCnt == 0) {
                ++emptySegsCnt;
                continue;
            }
            Object[] tab = (Object[])IgniteUtils.field(segs[i], "table");
            int tabLen = tab.length;
            X.println("    Segment-" + i + " [count=" + segCnt + ", len=" + tabLen + ']', new Object[0]);
            TreeMap<Integer, Integer> bucketsStats = new TreeMap<Integer, Integer>();
            for (Object entry2 : tab) {
                int cnt = 0;
                while (entry2 != null) {
                    ++cnt;
                    entry2 = IgniteUtils.field(entry2, "next");
                }
                Integer bucketCnt = (Integer)bucketsStats.get(cnt);
                if (bucketCnt == null) {
                    bucketCnt = 0;
                }
                Integer n = bucketCnt;
                Integer n2 = bucketCnt = Integer.valueOf(bucketCnt + 1);
                bucketsStats.put(cnt, bucketCnt);
                if (cnt <= 1) continue;
                totalCollisions += cnt - 1;
            }
            for (Map.Entry entry2 : bucketsStats.entrySet()) {
                X.println("        Buckets with count " + entry2.getKey() + ": " + entry2.getValue(), new Object[0]);
            }
        }
        X.println("    Map summary [emptySegs=" + emptySegsCnt + ", collisions=" + totalCollisions + ']', new Object[0]);
    }

    public static <T> T field(Object obj, String fieldName) {
        assert (obj != null);
        assert (fieldName != null);
        try {
            for (Class<?> cls = obj.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                for (Field field2 : cls.getDeclaredFields()) {
                    if (!field2.getName().equals(fieldName)) continue;
                    boolean accessible = field2.isAccessible();
                    field2.setAccessible(true);
                    Object val = field2.get(obj);
                    if (!accessible) {
                        field2.setAccessible(false);
                    }
                    return (T)val;
                }
            }
        }
        catch (Exception e) {
            throw new IgniteException("Failed to get field value [fieldName=" + fieldName + ", obj=" + obj + ']', e);
        }
        throw new IgniteException("Failed to get field value [fieldName=" + fieldName + ", obj=" + obj + ']');
    }

    public static boolean hasField(Object obj, String fieldName) {
        try {
            IgniteUtils.field(obj, fieldName);
            return true;
        }
        catch (IgniteException e) {
            return false;
        }
    }

    public static long fieldOffset(Class<?> cls, String fieldName) {
        try {
            return GridUnsafe.objectFieldOffset(cls.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isFinal(Class<?> cls) {
        return Modifier.isFinal(cls.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T field(Class<?> cls, String fieldName) throws IgniteCheckedException {
        assert (cls != null);
        assert (fieldName != null);
        try {
            Class<?> c = cls;
            while (cls != Object.class) {
                for (Field field2 : c.getDeclaredFields()) {
                    Object val;
                    if (!field2.getName().equals(fieldName)) continue;
                    if (!Modifier.isStatic(field2.getModifiers())) {
                        throw new IgniteCheckedException("Failed to get class field (field is not static) [cls=" + cls + ", fieldName=" + fieldName + ']');
                    }
                    boolean accessible = field2.isAccessible();
                    try {
                        field2.setAccessible(true);
                        val = field2.get(null);
                    }
                    finally {
                        if (!accessible) {
                            field2.setAccessible(false);
                        }
                    }
                    return (T)val;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to get field value [fieldName=" + fieldName + ", cls=" + cls + ']', e);
        }
        throw new IgniteCheckedException("Failed to get field value (field was not found) [fieldName=" + fieldName + ", cls=" + cls + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(@Nullable Class<?> cls, @Nullable Object obj, String mtdName, Object ... params2) throws IgniteCheckedException {
        assert (cls != null || obj != null);
        assert (mtdName != null);
        try {
            Class<?> clazz2 = cls = cls != null ? cls : obj.getClass();
            while (cls != Object.class) {
                AccessibleObject mtd = null;
                for (Method declaredMtd : cls.getDeclaredMethods()) {
                    if (!declaredMtd.getName().equals(mtdName)) continue;
                    if (mtd == null) {
                        mtd = declaredMtd;
                        continue;
                    }
                    throw new IgniteCheckedException("Failed to invoke (ambigous method name) [mtdName=" + mtdName + ", cls=" + cls + ']');
                }
                if (mtd != null) {
                    Object res;
                    boolean accessible = mtd.isAccessible();
                    try {
                        ((Method)mtd).setAccessible(true);
                        res = ((Method)mtd).invoke(obj, params2);
                    }
                    finally {
                        if (!accessible) {
                            ((Method)mtd).setAccessible(false);
                        }
                    }
                    return (T)res;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to invoke [mtdName=" + mtdName + ", cls=" + cls + ']', e);
        }
        throw new IgniteCheckedException("Failed to invoke (method was not found) [mtdName=" + mtdName + ", cls=" + cls + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(@Nullable Class<?> cls, @Nullable Object obj, String mtdName, Class[] paramTypes2, Object ... params2) throws IgniteCheckedException {
        assert (cls != null || obj != null);
        assert (mtdName != null);
        try {
            Class<?> clazz2 = cls = cls != null ? cls : obj.getClass();
            while (cls != Object.class) {
                block11: {
                    Object res;
                    Method mtd;
                    try {
                        mtd = cls.getDeclaredMethod(mtdName, paramTypes2);
                    }
                    catch (NoSuchMethodException ignored) {
                        break block11;
                    }
                    boolean accessible = mtd.isAccessible();
                    try {
                        mtd.setAccessible(true);
                        res = mtd.invoke(obj, params2);
                    }
                    finally {
                        if (!accessible) {
                            mtd.setAccessible(false);
                        }
                    }
                    return (T)res;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to invoke [mtdName=" + mtdName + ", cls=" + cls + ']', e);
        }
        throw new IgniteCheckedException("Failed to invoke (method was not found) [mtdName=" + mtdName + ", cls=" + cls + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T property(Object obj, String propName) {
        assert (obj != null);
        assert (propName != null);
        try {
            Method m;
            try {
                m = obj.getClass().getMethod("get" + IgniteUtils.capitalFirst(propName), new Class[0]);
            }
            catch (NoSuchMethodException ignored) {
                m = obj.getClass().getMethod("is" + IgniteUtils.capitalFirst(propName), new Class[0]);
            }
            assert (F.isEmpty(m.getParameterTypes()));
            boolean accessible = m.isAccessible();
            try {
                m.setAccessible(true);
                Object object = m.invoke(obj, new Object[0]);
                return (T)object;
            }
            finally {
                m.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            throw new IgniteException("Failed to get property value [property=" + propName + ", obj=" + obj + ']', e);
        }
    }

    public static <T> T staticField(Class<?> cls, String fieldName) throws IgniteCheckedException {
        assert (cls != null);
        assert (fieldName != null);
        try {
            for (Field field2 : cls.getDeclaredFields()) {
                if (!field2.getName().equals(fieldName)) continue;
                boolean accessible = field2.isAccessible();
                if (!accessible) {
                    field2.setAccessible(true);
                }
                Object val = field2.get(null);
                if (!accessible) {
                    field2.setAccessible(false);
                }
                return (T)val;
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to get field value [fieldName=" + fieldName + ", cls=" + cls + ']', e);
        }
        throw new IgniteCheckedException("Failed to get field value [fieldName=" + fieldName + ", cls=" + cls + ']');
    }

    private static String capitalFirst(@Nullable String str) {
        return str == null ? null : (str.isEmpty() ? "" : Character.toUpperCase(str.charAt(0)) + str.substring(1));
    }

    public static boolean isVisorNodeStartProperty(String name) {
        return "IGNITE_SSH_HOST".equals(name) || "IGNITE_SSH_USER_NAME".equals(name);
    }

    public static boolean isVisorRequiredProperty(String name) {
        return "java.version".equals(name) || "java.vm.name".equals(name) || "os.arch".equals(name) || "os.name".equals(name) || "os.version".equals(name);
    }

    public static IgniteBiTuple<Object, Object> addLog4jNoOpLogger() throws IgniteCheckedException {
        Object nullApp;
        Object rootLog;
        try {
            Class<?> logCls = Class.forName("org.apache.log4j.Logger");
            rootLog = logCls.getMethod("getRootLogger", new Class[0]).invoke(logCls, new Object[0]);
            try {
                nullApp = Class.forName("org.apache.log4j.varia.NullAppender").newInstance();
            }
            catch (ClassNotFoundException ignore) {
                return new IgniteBiTuple<Object, Object>(rootLog, null);
            }
            Class<?> appCls = Class.forName("org.apache.log4j.Appender");
            rootLog.getClass().getMethod("addAppender", appCls).invoke(rootLog, nullApp);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to add no-op logger for Log4j.", e);
        }
        return new IgniteBiTuple<Object, Object>(rootLog, nullApp);
    }

    public static void removeLog4jNoOpLogger(IgniteBiTuple<Object, Object> t) throws IgniteCheckedException {
        Object rootLog = t.get1();
        Object nullApp = t.get2();
        if (nullApp == null) {
            return;
        }
        try {
            Class<?> appenderCls = Class.forName("org.apache.log4j.Appender");
            rootLog.getClass().getMethod("removeAppender", appenderCls).invoke(rootLog, nullApp);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to remove previously added no-op logger for Log4j.", e);
        }
    }

    public static Collection<Handler> addJavaNoOpLogger() {
        ArrayList<Handler> savedHnds = new ArrayList<Handler>();
        Logger log2 = Logger.getLogger("");
        for (Handler h : log2.getHandlers()) {
            log2.removeHandler(h);
            savedHnds.add(h);
        }
        ConsoleHandler hnd = new ConsoleHandler();
        hnd.setLevel(Level.OFF);
        log2.addHandler(hnd);
        return savedHnds;
    }

    public static void removeJavaNoOpLogger(Collection<Handler> rmvHnds) {
        Logger log2 = Logger.getLogger("");
        for (Handler h : log2.getHandlers()) {
            log2.removeHandler(h);
        }
        if (!F.isEmpty(rmvHnds)) {
            for (Handler h : rmvHnds) {
                log2.addHandler(h);
            }
        }
    }

    public static String nodeIdLogFileName(UUID nodeId, String fileName) {
        assert (nodeId != null);
        assert (fileName != null);
        int dot = (fileName = GridFilenameUtils.separatorsToSystem(fileName)).lastIndexOf(46);
        if (dot < 0 || dot == fileName.length() - 1) {
            return fileName + '-' + U.id8(nodeId);
        }
        return fileName.substring(0, dot) + '-' + U.id8(nodeId) + fileName.substring(dot);
    }

    public static String customDirectoryLogFileName(@Nullable String dir, String fileName) {
        assert (fileName != null);
        if (dir == null) {
            return fileName;
        }
        int sep = fileName.lastIndexOf(File.separator);
        return dir + (sep < 0 ? File.separator + fileName : fileName.substring(sep));
    }

    public static String fl(String msg, Object ... args2) {
        assert (args2.length % 2 == 0);
        StringBuilder sb = new StringBuilder(msg);
        if (args2.length > 0) {
            sb.append(" [");
            for (int i = 0; i < args2.length / 2; ++i) {
                sb.append(args2[i * 2]).append('=').append(args2[i * 2 + 1]);
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(']');
        }
        return sb.toString();
    }

    public static int safeAbs(int i) {
        return (i = Math.abs(i)) < 0 ? 0 : i;
    }

    public static long safeAbs(long i) {
        return (i = Math.abs(i)) < 0L ? 0L : i;
    }

    public static long ensurePositive(long i, long dflt) {
        return i <= 0L ? dflt : i;
    }

    @Nullable
    public static Class<?> box(@Nullable Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (!cls.isPrimitive()) {
            return cls;
        }
        return boxedClsMap.get(cls);
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr) throws ClassNotFoundException {
        return U.forName(clsName, ldr, null);
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr, IgnitePredicate<String> clsFilter) throws ClassNotFoundException {
        Class<?> old;
        ConcurrentMap<String, Class<?>> ldrMap;
        assert (clsName != null);
        Class<?> cls = primitiveMap.get(clsName);
        if (cls != null) {
            return cls;
        }
        if (ldr != null) {
            if (ldr instanceof ClassCache) {
                return ((ClassCache)((Object)ldr)).getFromCache(clsName);
            }
        } else {
            ldr = gridClassLoader;
        }
        if ((ldrMap = (ConcurrentHashMap)classCache.get(ldr)) == null && (old = (ConcurrentMap)classCache.putIfAbsent(ldr, ldrMap = new ConcurrentHashMap())) != null) {
            ldrMap = old;
        }
        if ((cls = (Class<?>)ldrMap.get(clsName)) == null) {
            if (clsFilter != null && !clsFilter.apply(clsName)) {
                throw new RuntimeException("Deserialization of class " + clsName + " is disallowed.");
            }
            cls = ldr instanceof CacheClassLoaderMarker ? ldr.loadClass(clsName) : Class.forName(clsName, true, ldr);
            old = ldrMap.putIfAbsent(clsName, cls);
            if (old != null) {
                cls = old;
            }
        }
        return cls;
    }

    public static void clearClassFromClassCache(ClassLoader ldr, String clsName) {
        ConcurrentMap map2 = (ConcurrentMap)classCache.get(ldr);
        if (map2 != null) {
            map2.remove(clsName);
        }
    }

    public static void clearClassCache(ClassLoader ldr) {
        classCache.remove(ldr);
    }

    public static void clearClassCache() {
        classCache.clear();
    }

    public static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public static int hash(Object key) {
        return IgniteUtils.hash(key.hashCode());
    }

    public static int hash(long key) {
        int val = (int)(key ^ key >>> 32);
        return IgniteUtils.hash(val);
    }

    public static int jvmPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            int idx = name.indexOf(64);
            return idx > 0 ? Integer.parseInt(name.substring(0, idx)) : -1;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    public static List<String> jvmArgs() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    private static boolean unsafeByteArrayCopyAvailable() {
        try {
            Class<Unsafe> unsafeCls = Unsafe.class;
            unsafeCls.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static int arrayCopy(byte[] src, int off, byte[] resBuf, int resOff, int len) {
        assert (resBuf.length >= resOff + len);
        if (UNSAFE_BYTE_ARR_CP) {
            GridUnsafe.copyMemory(src, GridUnsafe.BYTE_ARR_OFF + (long)off, resBuf, GridUnsafe.BYTE_ARR_OFF + (long)resOff, len);
        } else {
            System.arraycopy(src, off, resBuf, resOff, len);
        }
        return resOff + len;
    }

    public static String consistentId(Collection<String> addrs) {
        assert (!F.isEmpty(addrs));
        StringBuilder sb = new StringBuilder();
        for (String addr : addrs) {
            sb.append(addr).append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static String consistentId(Collection<String> addrs, int port) {
        assert (!F.isEmpty(addrs));
        return IgniteUtils.consistentId(addrs) + ':' + port;
    }

    public static String maskForFileName(CharSequence name) {
        StringBuilder b = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                b.append(c);
                continue;
            }
            b.append('_');
        }
        return b.toString();
    }

    public static boolean overridesEqualsAndHashCode(Object obj) {
        return IgniteUtils.overridesEqualsAndHashCode(obj.getClass());
    }

    public static boolean overridesEqualsAndHashCode(Class<?> cls) {
        try {
            return !Object.class.equals(cls.getMethod("equals", Object.class).getDeclaringClass()) && !Object.class.equals(cls.getMethod("hashCode", new Class[0]).getDeclaringClass());
        }
        catch (NoSuchMethodException | SecurityException ignore) {
            return true;
        }
    }

    public static boolean isMacInvalidArgumentError(Exception e) {
        return U.isMacOs() && e instanceof SocketException && e.getMessage() != null && e.getMessage().toLowerCase().contains("invalid argument");
    }

    @Nullable
    public static <T> T firstNotNull(T ... vals) {
        if (vals == null) {
            return null;
        }
        for (T val : vals) {
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static void startLifecycleAware(Iterable<?> objs) throws IgniteCheckedException {
        try {
            for (Object obj : objs) {
                if (!(obj instanceof LifecycleAware)) continue;
                ((LifecycleAware)obj).start();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to start component: " + e, e);
        }
    }

    public static void stopLifecycleAware(IgniteLogger log2, Iterable<?> objs) {
        for (Object obj : objs) {
            if (!(obj instanceof LifecycleAware)) continue;
            try {
                ((LifecycleAware)obj).stop();
            }
            catch (Exception e) {
                U.error(log2, "Failed to stop component (ignoring): " + obj, e);
            }
        }
    }

    public static Map<String, Collection<ClusterNode>> neighborhood(Iterable<ClusterNode> nodes2) {
        HashMap<String, Collection<ClusterNode>> map2 = new HashMap<String, Collection<ClusterNode>>();
        for (ClusterNode n : nodes2) {
            String macs = (String)n.attribute("org.apache.ignite.macs");
            assert (macs != null) : "Missing MACs attribute: " + n;
            ArrayList<ClusterNode> neighbors = (ArrayList<ClusterNode>)map2.get(macs);
            if (neighbors == null) {
                neighbors = new ArrayList<ClusterNode>(2);
                map2.put(macs, neighbors);
            }
            neighbors.add(n);
        }
        return map2;
    }

    public static Collection<InetAddress> toInetAddresses(ClusterNode node) throws IgniteCheckedException {
        return IgniteUtils.toInetAddresses(node.addresses(), node.hostNames());
    }

    public static Collection<InetAddress> toInetAddresses(Collection<String> addrs, Collection<String> hostNames) throws IgniteCheckedException {
        HashSet<InetAddress> res = new HashSet<InetAddress>(addrs.size());
        Iterator<String> hostNamesIt = hostNames.iterator();
        for (String addr : addrs) {
            String hostName = hostNamesIt.hasNext() ? hostNamesIt.next() : null;
            InetAddress inetAddr = null;
            if (!F.isEmpty(hostName)) {
                try {
                    inetAddr = InetAddress.getByName(hostName);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (inetAddr == null || inetAddr.isLoopbackAddress()) {
                try {
                    inetAddr = InetAddress.getByName(addr);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (inetAddr == null) continue;
            res.add(inetAddr);
        }
        if (res.isEmpty()) {
            throw new IgniteCheckedException("Addresses can not be resolved [addr=" + addrs + ", hostNames=" + hostNames + ']');
        }
        return res;
    }

    public static Collection<InetSocketAddress> toSocketAddresses(ClusterNode node, int port) {
        return IgniteUtils.toSocketAddresses(node.addresses(), node.hostNames(), port);
    }

    public static Collection<InetSocketAddress> toSocketAddresses(Collection<String> addrs, Collection<String> hostNames, int port) {
        HashSet<InetSocketAddress> res = new HashSet<InetSocketAddress>(addrs.size());
        Iterator<String> hostNamesIt = hostNames.iterator();
        for (String addr : addrs) {
            String hostName;
            String string2 = hostName = hostNamesIt.hasNext() ? hostNamesIt.next() : null;
            if (!F.isEmpty(hostName)) {
                InetSocketAddress inetSockAddr = new InetSocketAddress(hostName, port);
                if (inetSockAddr.isUnresolved() || inetSockAddr.getAddress().isLoopbackAddress()) {
                    inetSockAddr = new InetSocketAddress(addr, port);
                }
                res.add(inetSockAddr);
            }
            res.add(new InetSocketAddress(addr, port));
        }
        return res;
    }

    public static Collection<InetSocketAddress> resolveAddresses(AddressResolver addrRslvr, Iterable<String> addrs, int port) throws IgniteSpiException {
        assert (addrRslvr != null);
        HashSet<InetSocketAddress> extAddrs = new HashSet<InetSocketAddress>();
        for (String addr : addrs) {
            Collection<InetSocketAddress> extAddrs0;
            InetSocketAddress sockAddr = new InetSocketAddress(addr, port);
            if (sockAddr.isUnresolved() || (extAddrs0 = IgniteUtils.resolveAddress(addrRslvr, sockAddr)) == null) continue;
            extAddrs.addAll(extAddrs0);
        }
        return extAddrs;
    }

    public static Collection<InetSocketAddress> resolveAddresses(AddressResolver addrRslvr, Collection<InetSocketAddress> sockAddr) {
        if (addrRslvr == null) {
            return sockAddr;
        }
        HashSet<InetSocketAddress> resolved = new HashSet<InetSocketAddress>();
        for (InetSocketAddress address : sockAddr) {
            resolved.addAll(IgniteUtils.resolveAddress(addrRslvr, address));
        }
        return resolved;
    }

    private static Collection<InetSocketAddress> resolveAddress(AddressResolver addrRslvr, InetSocketAddress sockAddr) {
        try {
            return addrRslvr.getExternalAddresses(sockAddr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to get mapped external addresses [addrRslvr=" + addrRslvr + ", addr=" + sockAddr + ']', e);
        }
    }

    public static String addressesAsString(ClusterNode node) {
        return IgniteUtils.addressesAsString(node.addresses(), node.hostNames());
    }

    public static String addressesAsString(Collection<String> addrs, Collection<String> hostNames) {
        if (F.isEmpty(addrs)) {
            return "";
        }
        if (F.isEmpty(hostNames)) {
            return addrs.toString();
        }
        SB sb = new SB("[");
        Iterator<String> hostNamesIt = hostNames.iterator();
        boolean first = true;
        for (String addr : addrs) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            String hostName = hostNamesIt.hasNext() ? hostNamesIt.next() : null;
            sb.a(hostName != null ? hostName : "").a('/').a(addr);
        }
        sb.a(']');
        return sb.toString();
    }

    public static String defaultWorkDirectory() throws IgniteCheckedException {
        return IgniteUtils.workDirectory(null, null);
    }

    public static String workDirectory(@Nullable String userWorkDir, @Nullable String userIgniteHome) throws IgniteCheckedException {
        File workDir;
        if (userIgniteHome == null) {
            userIgniteHome = IgniteUtils.getIgniteHome();
        }
        if (!F.isEmpty(userWorkDir)) {
            workDir = new File(userWorkDir);
        } else if (!F.isEmpty(IGNITE_WORK_DIR)) {
            workDir = new File(IGNITE_WORK_DIR);
        } else if (!F.isEmpty(userIgniteHome)) {
            workDir = new File(userIgniteHome, DEFAULT_WORK_DIR);
        } else {
            String userDir = System.getProperty("user.dir");
            if (F.isEmpty(userDir)) {
                throw new IgniteCheckedException("Failed to resolve Ignite work directory. Either IgniteConfiguration.setWorkDirectory or one of the system properties (IGNITE_HOME, IGNITE_WORK_DIR) must be explicitly set.");
            }
            File igniteDir = new File(userDir, "ignite");
            try {
                igniteDir.mkdirs();
                File readme = new File(igniteDir, "README.txt");
                if (!readme.exists()) {
                    U.writeStringToFile(readme, "This is Apache Ignite working directory that contains information that \n    Ignite nodes need in order to function normally.\nDon't delete it unless you're sure you know what you're doing.\n\nYou can change the location of working directory with \n    igniteConfiguration.setWorkingDirectory(location) or \n    <property name=\"workingDirectory\" value=\"location\"/> in IgniteConfiguration <bean>.\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            workDir = new File(igniteDir, DEFAULT_WORK_DIR);
        }
        if (!workDir.isAbsolute()) {
            throw new IgniteCheckedException("Work directory path must be absolute: " + workDir);
        }
        if (!IgniteUtils.mkdirs(workDir)) {
            throw new IgniteCheckedException("Work directory does not exist and cannot be created: " + workDir);
        }
        if (!workDir.canRead()) {
            throw new IgniteCheckedException("Cannot read from work directory: " + workDir);
        }
        if (!workDir.canWrite()) {
            throw new IgniteCheckedException("Cannot write to work directory: " + workDir);
        }
        return workDir.getAbsolutePath();
    }

    public static void nullifyHomeDirectory() {
        ggHome = null;
    }

    public static File resolveWorkDirectory(String workDir, String path2, boolean delIfExist) throws IgniteCheckedException {
        File dir = new File(path2);
        if (!dir.isAbsolute()) {
            if (F.isEmpty(workDir)) {
                throw new IgniteCheckedException("Failed to resolve path (work directory has not been set): " + path2);
            }
            dir = new File(workDir, dir.getPath());
        }
        if (delIfExist && dir.exists() && !U.delete(dir)) {
            throw new IgniteCheckedException("Failed to delete directory: " + dir);
        }
        if (!IgniteUtils.mkdirs(dir)) {
            throw new IgniteCheckedException("Directory does not exist and cannot be created: " + dir);
        }
        if (!dir.canRead()) {
            throw new IgniteCheckedException("Cannot read from directory: " + dir);
        }
        if (!dir.canWrite()) {
            throw new IgniteCheckedException("Cannot write to directory: " + dir);
        }
        return dir;
    }

    public static void ensureDirectory(File dir, String msg, IgniteLogger log2) throws IgniteCheckedException {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IgniteCheckedException("Failed to create " + msg + ": " + dir.getAbsolutePath());
            }
        } else if (!dir.isDirectory()) {
            throw new IgniteCheckedException("Failed to initialize " + msg + " (a file with the same name already exists): " + dir.getAbsolutePath());
        }
        if (log2 != null && log2.isInfoEnabled()) {
            log2.info("Resolved " + msg + ": " + dir.getAbsolutePath());
        }
    }

    public static void ensureDirectory(Path dir, String msg, IgniteLogger log2) throws IgniteCheckedException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to create " + msg + ": " + dir.toAbsolutePath(), e);
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IgniteCheckedException("Failed to initialize " + msg + " (a file with the same name already exists): " + dir.toAbsolutePath());
        }
        if (log2 != null && log2.isInfoEnabled()) {
            log2.info("Resolved " + msg + ": " + dir.toAbsolutePath());
        }
    }

    public static IgniteCheckedException exceptionWithSuppressed(String msg, @Nullable Collection<Throwable> suppressed) {
        IgniteCheckedException e = new IgniteCheckedException(msg);
        if (suppressed != null) {
            for (Throwable th : suppressed) {
                e.addSuppressed(th);
            }
        }
        return e;
    }

    @Nullable
    public static String lambdaEnclosingClassName(String clsName) {
        int idx = clsName.indexOf("$$Lambda$");
        return idx != -1 ? clsName.substring(0, idx) : null;
    }

    public static int toDigit(char ch, int idx) throws IgniteCheckedException {
        int digit2 = Character.digit(ch, 16);
        if (digit2 == -1) {
            throw new IgniteCheckedException("Illegal hexadecimal character " + ch + " at index " + idx);
        }
        return digit2;
    }

    public static ClusterNode oldest(Collection<ClusterNode> c, @Nullable IgnitePredicate<ClusterNode> p) {
        ClusterNode oldest = null;
        long minOrder = Long.MAX_VALUE;
        for (ClusterNode n : c) {
            if (p != null && !p.apply(n) || n.order() >= minOrder) continue;
            oldest = n;
            minOrder = n.order();
        }
        return oldest;
    }

    public static ClusterNode youngest(Collection<ClusterNode> c, @Nullable IgnitePredicate<ClusterNode> p) {
        ClusterNode youngest = null;
        long maxOrder = Long.MIN_VALUE;
        for (ClusterNode n : c) {
            if (p != null && !p.apply(n) || n.order() <= maxOrder) continue;
            youngest = n;
            maxOrder = n.order();
        }
        return youngest;
    }

    public static byte[] copyMemory(long ptr, int size2) {
        byte[] res = new byte[size2];
        GridUnsafe.copyMemory(null, ptr, res, GridUnsafe.BYTE_ARR_OFF, size2);
        return res;
    }

    public static int capacity(int expSize) {
        if (expSize < 3) {
            return expSize + 1;
        }
        if (expSize < 0x40000000) {
            return expSize + expSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMap(int expSize) {
        return new HashMap(IgniteUtils.capacity(expSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expSize) {
        return new LinkedHashMap(IgniteUtils.capacity(expSize));
    }

    public static <T> HashSet<T> newHashSet(int expSize) {
        return new HashSet(IgniteUtils.capacity(expSize));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(int expSize) {
        return new LinkedHashSet(IgniteUtils.capacity(expSize));
    }

    public static <K, V> Map<K, V> limitedMap(int limit) {
        if (limit == 0) {
            return Collections.emptyMap();
        }
        if (limit < 5) {
            return new GridLeanMap(limit);
        }
        return new HashMap(IgniteUtils.capacity(limit), 0.75f);
    }

    public static <T> Collection<T> convertToSingletonList(Collection<T> col) {
        if (col.size() != 1) {
            throw new IllegalArgumentException("Unexpected collection size for singleton list, expecting 1 but was: " + col.size());
        }
        return Collections.singletonList(col.iterator().next());
    }

    public static Comparator<InetSocketAddress> inetAddressesComparator(final boolean sameHost) {
        return new Comparator<InetSocketAddress>(){

            @Override
            public int compare(InetSocketAddress addr1, InetSocketAddress addr2) {
                if (addr1.isUnresolved() && addr2.isUnresolved()) {
                    return 0;
                }
                if (addr1.isUnresolved() || addr2.isUnresolved()) {
                    return addr1.isUnresolved() ? 1 : -1;
                }
                boolean addr1Loopback = addr1.getAddress().isLoopbackAddress();
                if (addr1Loopback == addr2.getAddress().isLoopbackAddress()) {
                    return 0;
                }
                if (sameHost) {
                    return addr1Loopback ? -1 : 1;
                }
                return addr1Loopback ? 1 : -1;
            }
        };
    }

    @Nullable
    public static Method findNonPublicMethod(Class<?> cls, String name, Class<?> ... paramTypes2) {
        while (cls != null) {
            Method mtd = IgniteUtils.getNonPublicMethod(cls, name, paramTypes2);
            if (mtd != null) {
                return mtd;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Method getNonPublicMethod(Class<?> cls, String name, Class<?> ... paramTypes2) {
        try {
            Method mtd = cls.getDeclaredMethod(name, paramTypes2);
            mtd.setAccessible(true);
            return mtd;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Nullable
    public static Method findInheritableMethod(Class<?> cls, String name, Class<?> ... paramTypes2) {
        ClassLoader clsLdr0;
        Class<?> cls0;
        Method mtd = null;
        for (cls0 = cls; cls0 != null; cls0 = cls0.getSuperclass()) {
            try {
                mtd = cls0.getDeclaredMethod(name, paramTypes2);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (mtd == null) {
            return null;
        }
        mtd.setAccessible(true);
        int mods = mtd.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return mtd;
        }
        if ((mods & 2) != 0) {
            return cls == cls0 ? mtd : null;
        }
        ClassLoader clsLdr = cls.getClassLoader();
        return clsLdr == (clsLdr0 = cls0.getClassLoader()) && IgniteUtils.packageName(cls).equals(IgniteUtils.packageName(cls0)) ? mtd : null;
    }

    private static String packageName(Class<?> cls) {
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    @Nullable
    public static Field findField(Class<?> cls, String name) {
        while (cls != null) {
            try {
                Field fld = cls.getDeclaredField(name);
                if (!fld.isAccessible()) {
                    fld.setAccessible(true);
                }
                return fld;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                cls = cls.getSuperclass();
            }
        }
        return null;
    }

    public static <T extends R, R> List<R> arrayList(Collection<T> c, IgnitePredicate<? super T> ... p) {
        assert (c != null);
        return IgniteUtils.arrayList(c, c.size(), p);
    }

    public static <T extends R, R> List<R> arrayList(Collection<T> c) {
        assert (c != null);
        return new ArrayList<T>(c);
    }

    public static <T extends R, R> List<R> arrayList(Iterable<T> c, int cap, IgnitePredicate<? super T> ... p) {
        assert (c != null);
        assert (cap >= 0);
        ArrayList<T> list2 = new ArrayList<T>(cap);
        for (T t : c) {
            if (!F.isAll(t, p)) continue;
            list2.add(t);
        }
        return list2;
    }

    public static byte[] calculateMD5Digest(@NotNull InputStream in) throws NoSuchAlgorithmException, IOException {
        int nread;
        MessageDigest md = MessageDigest.getInstance("MD5");
        BufferedInputStream fis = new BufferedInputStream(in);
        byte[] dataBytes = new byte[1024];
        while ((nread = ((InputStream)fis).read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        return md.digest();
    }

    public static String calculateMD5(InputStream in) throws NoSuchAlgorithmException, IOException {
        byte[] md5Bytes = IgniteUtils.calculateMD5Digest(in);
        StringBuilder sb = new StringBuilder();
        for (byte md5Byte : md5Bytes) {
            sb.append(Integer.toString((md5Byte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static int writeMessageFully(Message msg, OutputStream out, ByteBuffer buf, MessageWriter writer) throws IOException {
        assert (msg != null);
        assert (out != null);
        assert (buf != null);
        assert (buf.hasArray());
        if (writer != null) {
            writer.setCurrentWriteClass(msg.getClass());
        }
        boolean finished = false;
        int cnt = 0;
        while (!finished) {
            finished = msg.writeTo(buf, writer);
            out.write(buf.array(), 0, buf.position());
            cnt += buf.position();
            buf.clear();
        }
        return cnt;
    }

    public static void assertParameter(boolean cond, String condDesc) throws IgniteException {
        if (!cond) {
            throw new IgniteException("Parameter failed condition check: " + condDesc);
        }
    }

    public static boolean hasSharedMemory() {
        if (hasShmem == null) {
            if (IgniteUtils.isWindows()) {
                hasShmem = false;
            } else {
                try {
                    IpcSharedMemoryNativeLoader.load(null);
                    hasShmem = true;
                }
                catch (IgniteCheckedException ignore) {
                    hasShmem = false;
                }
            }
        }
        return hasShmem;
    }

    public static void writeLock(ReadWriteLock lock) throws IgniteInterruptedCheckedException {
        try {
            lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public static byte directProtocolVersion(GridKernalContext ctx, UUID nodeId) throws IgniteCheckedException {
        byte rmtProtoVer;
        assert (nodeId != null);
        ClusterNode node = ctx.discovery().node(nodeId);
        if (node == null) {
            throw new IgniteCheckedException("Failed to define communication protocol version (has node left topology?): " + nodeId);
        }
        assert (!node.isLocal());
        Byte attr = (Byte)node.attribute("comm.direct.proto.ver");
        byte by2 = rmtProtoVer = attr != null ? attr : (byte)1;
        if (rmtProtoVer < 2) {
            return rmtProtoVer;
        }
        return 2;
    }

    public static boolean isHashCodeMethod(Method mtd) {
        return hashCodeMtd.equals(mtd);
    }

    public static boolean isEqualsMethod(Method mtd) {
        return equalsMtd.equals(mtd);
    }

    public static boolean isToStringMethod(Method mtd) {
        return toStringMtd.equals(mtd);
    }

    public static String threadName(long threadId) {
        Thread[] threads = new Thread[Thread.activeCount()];
        int cnt = Thread.enumerate(threads);
        for (int i = 0; i < cnt; ++i) {
            if (threads[i].getId() != threadId) continue;
            return threads[i].getName();
        }
        return "<failed to find active thread " + threadId + '>';
    }

    public static <T extends Comparable<? super T>> T max(T t0, T t1) {
        return t0.compareTo(t1) > 0 ? t0 : t1;
    }

    public static <T> T unmarshal(Marshaller marsh, InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (marsh != null);
        assert (in != null);
        try {
            return marsh.unmarshal(in, clsLdr);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static <T> T unmarshalZip(Marshaller marsh, byte[] zipBytes, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (marsh != null);
        assert (zipBytes != null);
        try {
            ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(zipBytes));
            in.getNextEntry();
            return marsh.unmarshal(in, clsLdr);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static <T> T unmarshal(Marshaller marsh, byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (marsh != null);
        assert (arr != null);
        try {
            return marsh.unmarshal(arr, clsLdr);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static <T> T unmarshal(GridKernalContext ctx, byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (ctx != null);
        assert (arr != null);
        try {
            return U.unmarshal(ctx.config().getMarshaller(), arr, clsLdr);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static <T> T unmarshal(GridCacheSharedContext ctx, byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (ctx != null);
        assert (arr != null);
        try {
            return U.unmarshal(ctx.marshaller(), arr, clsLdr);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static byte[] marshal(Marshaller marsh, Object obj) throws IgniteCheckedException {
        assert (marsh != null);
        try {
            return marsh.marshal(obj);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static void marshal(Marshaller marsh, @Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        assert (marsh != null);
        try {
            marsh.marshal(obj, out);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static byte[] marshal(GridKernalContext ctx, Object obj) throws IgniteCheckedException {
        assert (ctx != null);
        return IgniteUtils.marshal(ctx.config().getMarshaller(), obj);
    }

    public static byte[] marshal(GridCacheSharedContext ctx, Object obj) throws IgniteCheckedException {
        assert (ctx != null);
        return IgniteUtils.marshal(ctx.marshaller(), obj);
    }

    @Nullable
    public static String getCurrentIgniteName() {
        return LOC_IGNITE_NAME.get();
    }

    public static boolean isCurrentIgniteNameSet(@Nullable String name) {
        return name != LOC_IGNITE_NAME_EMPTY;
    }

    @Nullable
    public static String setCurrentIgniteName(@Nullable String newName) {
        String oldName = LOC_IGNITE_NAME.get();
        if (oldName != newName) {
            LOC_IGNITE_NAME.set(newName);
        }
        return oldName;
    }

    public static void restoreOldIgniteName(@Nullable String oldName, @Nullable String curName) {
        if (oldName != curName) {
            LOC_IGNITE_NAME.set(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(@Nullable byte[] bytes2) throws IgniteCheckedException {
        try {
            if (bytes2 == null) {
                return null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(bos);){
                ZipEntry entry2 = new ZipEntry("");
                try {
                    entry2.setSize(bytes2.length);
                    zos.putNextEntry(entry2);
                    zos.write(bytes2);
                }
                finally {
                    zos.closeEntry();
                }
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] toBytes(Serializable obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T fromBytes(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long checkpointBufferSize(DataRegionConfiguration regCfg) {
        if (!regCfg.isPersistenceEnabled()) {
            return 0L;
        }
        long res = regCfg.getCheckpointPageBufferSize();
        if (res == 0L) {
            res = regCfg.getMaxSize() < 0x40000000L ? Math.min(DFLT_MIN_CHECKPOINTING_PAGE_BUFFER_SIZE, regCfg.getMaxSize()) : (regCfg.getMaxSize() < 0x200000000L ? regCfg.getMaxSize() / 4L : DFLT_MAX_CHECKPOINTING_PAGE_BUFFER_SIZE);
        }
        return res;
    }

    public static long adjustedWalHistorySize(DataStorageConfiguration dsCfg, @Nullable IgniteLogger log2) {
        long adjustedWalArchiveSize;
        DataRegionConfiguration regCfg;
        long cpBufSize;
        if (dsCfg.getMaxWalArchiveSize() != 0x40000000L) {
            return dsCfg.getMaxWalArchiveSize();
        }
        long maxCpBufSize = 0L;
        if (dsCfg.getDataRegionConfigurations() != null) {
            for (DataRegionConfiguration regCfg2 : dsCfg.getDataRegionConfigurations()) {
                long cpBufSize2 = IgniteUtils.checkpointBufferSize(regCfg2);
                if (cpBufSize2 > regCfg2.getMaxSize()) {
                    cpBufSize2 = regCfg2.getMaxSize();
                }
                if (cpBufSize2 <= maxCpBufSize) continue;
                maxCpBufSize = cpBufSize2;
            }
        }
        if ((cpBufSize = IgniteUtils.checkpointBufferSize(regCfg = dsCfg.getDefaultDataRegionConfiguration())) > regCfg.getMaxSize()) {
            cpBufSize = regCfg.getMaxSize();
        }
        if (cpBufSize > maxCpBufSize) {
            maxCpBufSize = cpBufSize;
        }
        if ((adjustedWalArchiveSize = maxCpBufSize * 4L) > dsCfg.getMaxWalArchiveSize()) {
            if (log2 != null) {
                U.quietAndInfo(log2, "Automatically adjusted max WAL archive size to " + U.readableSize(adjustedWalArchiveSize, false) + " (to override, use DataStorageConfiguration.setMaxWalArhiveSize)");
            }
            return adjustedWalArchiveSize;
        }
        return dsCfg.getMaxWalArchiveSize();
    }

    public static int fileCount(Path dir) throws IOException {
        int cnt = 0;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            for (Path d : ds) {
                if (Files.isDirectory(d, new LinkOption[0])) {
                    cnt += IgniteUtils.fileCount(d);
                    continue;
                }
                if (!Files.isRegularFile(d, new LinkOption[0])) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public static long dirSize(Path path2) throws IgniteCheckedException {
        final AtomicLong s2 = new AtomicLong(0L);
        try {
            Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    s2.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    U.error(null, "file skipped - " + file, exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        U.error(null, "error during size calculation of directory - " + dir, exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IgniteCheckedException("walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return s2.get();
    }

    public static Path searchFileRecursively(Path path2, final @NotNull String name) throws IgniteCheckedException {
        final AtomicReference res = new AtomicReference();
        try {
            Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (name.equals(file.getFileName().toString())) {
                        res.set(file);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    U.error(null, "file skipped during recursive search - " + file, exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        U.error(null, "error during recursive search - " + dir, exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IgniteCheckedException("walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return (Path)res.get();
    }

    public static GridIntIterator forRange(final int start, final int cnt) {
        return new GridIntIterator(){
            int c = 0;

            @Override
            public boolean hasNext() {
                return this.c < cnt;
            }

            @Override
            public int next() {
                return start + this.c++;
            }
        };
    }

    public static int nearestPow2(int x) {
        return IgniteUtils.nearestPow2(x, true);
    }

    public static int nearestPow2(int x, boolean less2) {
        long y;
        assert (x > 0) : "can not calculate for less zero";
        for (y = 1L; y < (long)x; y *= 2L) {
            if (y * 2L <= Integer.MAX_VALUE) continue;
            return (int)y;
        }
        if (less2) {
            y /= 2L;
        }
        return (int)y;
    }

    public static ReentrantReadWriteLockTracer lockTracer(ReadWriteLock lock) {
        return new ReentrantReadWriteLockTracer(lock);
    }

    public static LockTracer lockTracer(Lock lock) {
        return new LockTracer(lock);
    }

    public static BaselineTopology getBaselineTopology(@NotNull GridKernalContext ctx) {
        return ctx.state().clusterState().baselineTopology();
    }

    public static BaselineTopology getBaselineTopology(@NotNull GridCacheSharedContext cctx) {
        return IgniteUtils.getBaselineTopology(cctx.kernalContext());
    }

    public static BaselineTopology getBaselineTopology(@NotNull GridCacheContext cctx) {
        return IgniteUtils.getBaselineTopology(cctx.kernalContext());
    }

    public static boolean isOldestNodeVersionAtLeast(IgniteProductVersion ver, Iterable<ClusterNode> nodes2) {
        for (ClusterNode node : nodes2) {
            if (node.version().compareToIgnoreTimestamp(ver) >= 0) continue;
            return false;
        }
        return true;
    }

    public static String toHexString(long addr, int len) {
        assert ((len & 7) == 0 && len > 0);
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; i += 8) {
            sb.append(U.hexLong(GridUnsafe.getLong(addr + (long)i)));
        }
        return sb.toString();
    }

    public static String toHexString(ByteBuffer buf) {
        assert ((buf.capacity() & 7) == 0);
        StringBuilder sb = new StringBuilder(buf.capacity() * 2);
        for (int i = 0; i < buf.capacity(); i += 8) {
            sb.append(U.hexLong(buf.getLong(i)));
        }
        return sb.toString();
    }

    public static ClusterNode randomServerNode(GridKernalContext ctx) {
        Collection<ClusterNode> aliveNodes = ctx.discovery().aliveServerNodes();
        int rndIdx = RND.nextInt(aliveNodes.size()) + 1;
        ClusterNode rndNode = null;
        Iterator<ClusterNode> it = aliveNodes.iterator();
        for (int i = 0; i < rndIdx && it.hasNext(); ++i) {
            rndNode = it.next();
        }
        if (rndNode == null) assert (rndNode != null);
        return rndNode;
    }

    public static Runnable wrapIgniteFuture(Runnable r, GridFutureAdapter<?> fut) {
        return () -> {
            try {
                r.run();
                fut.onDone();
            }
            catch (Throwable e) {
                fut.onDone(e);
                throw e;
            }
        };
    }

    public static void writeFully(SocketChannel sockCh, ByteBuffer buf) throws IOException {
        int totalWritten = 0;
        assert (sockCh.isBlocking()) : "SocketChannel should be in blocking mode " + sockCh;
        while (buf.hasRemaining()) {
            int written = sockCh.write(buf);
            if (written < 0) {
                throw new IOException("Error writing buffer to channel [written = " + written + ", buf " + buf + ", totalWritten = " + totalWritten + "]");
            }
            totalWritten += written;
        }
    }

    static {
        Class[] evtHolderClasses;
        DFLT_MIN_CHECKPOINTING_PAGE_BUFFER_SIZE = 0x10000000L;
        DFLT_MAX_CHECKPOINTING_PAGE_BUFFER_SIZE = 0x80000000L;
        UNSAFE_BYTE_ARR_CP = IgniteUtils.unsafeByteArrayCopyAvailable();
        GRID_EVT_NAMES = new HashMap<Integer, String>();
        EMPTY_INTS = new int[0];
        EMPTY_LONGS = new long[0];
        EMPTY_FIELDS = new Field[0];
        NL = System.getProperty("line.separator");
        p2pFields = new ConcurrentHashMap();
        MBEAN_CACHE_NAME_PATTERN = Pattern.compile("^[a-zA-Z_0-9]+$");
        JMX_DOMAIN = IgniteUtils.class.getName().substring(0, IgniteUtils.class.getName().indexOf(46, IgniteUtils.class.getName().indexOf(46) + 1));
        IGNITE_HEADER = IgniteUtils.intToBytes(18247);
        LONG_DATE_FMT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        SHORT_DATE_FMT = new SimpleDateFormat("HH:mm:ss");
        DEBUG_DATE_FMT = new SimpleDateFormat("HH:mm:ss,SSS");
        curTimeMillis = System.currentTimeMillis();
        primitiveMap = new HashMap(16, 0.5f);
        boxedClsMap = new HashMap(16, 0.5f);
        gridClassLoader = IgniteUtils.class.getClassLoader();
        IGNITE_LOG_DIR = System.getenv("IGNITE_LOG_DIR");
        IGNITE_WORK_DIR = System.getenv("IGNITE_WORK_DIR");
        RND = new Random(System.currentTimeMillis());
        mux = new Object();
        classCache = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String, Class>>();
        LOC_IGNITE_NAME_EMPTY = new String();
        LOC_IGNITE_NAME = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return LOC_IGNITE_NAME_EMPTY;
            }
        };
        IGNITE_MBEANS_DISABLED = IgniteSystemProperties.getBoolean("IGNITE_MBEANS_DISABLED");
        IGNITE_TEST_FEATURES_ENABLED = IgniteSystemProperties.getBoolean("IGNITE_TEST_FEATURES_ENABLED");
        EMPTY_URL_ARR = new URL[0];
        bltClsLdrCls = IgniteUtils.defaultClassLoaderClass();
        urlClsLdrField = IgniteUtils.urlClassLoaderField();
        devOnlyLogDisabled = IgniteSystemProperties.getBoolean("IGNITE_DEV_ONLY_LOGGING_DISABLED");
        boolean assertionsEnabled0 = true;
        try {
            assert (false);
            assertionsEnabled0 = false;
        }
        catch (AssertionError ignored) {
            assertionsEnabled0 = true;
        }
        finally {
            assertionsEnabled = assertionsEnabled0;
        }
        redHat = Files.exists(Paths.get("/etc/redhat-release", new String[0]), new LinkOption[0]);
        String osName = System.getProperty("os.name");
        String osLow = osName.toLowerCase();
        if (osLow.contains("win")) {
            if (osLow.contains("95")) {
                win95 = true;
            } else if (osLow.contains("98")) {
                win98 = true;
            } else if (osLow.contains("nt")) {
                winNt = true;
            } else if (osLow.contains("2000")) {
                win2k = true;
            } else if (osLow.contains("vista")) {
                winVista = true;
            } else if (osLow.contains("xp")) {
                winXp = true;
            } else if (osLow.contains("2003")) {
                win2003 = true;
            } else if (osLow.contains("2008")) {
                win2008 = true;
            } else if (osLow.contains("7")) {
                win7 = true;
            } else if (osLow.contains("8.1")) {
                win81 = true;
            } else if (osLow.contains("8")) {
                win8 = true;
            } else {
                unknownWin = true;
            }
        } else if (osLow.contains("netware")) {
            netware = true;
        } else if (osLow.contains("mac os")) {
            mac = true;
        } else {
            for (String os : new String[]{"ix", "inux", "olaris", "un", "ux", "sco", "bsd", "att"}) {
                if (!osLow.contains(os)) continue;
                unix = true;
                break;
            }
            if (osLow.contains("olaris") || osLow.contains("sunos")) {
                solaris = true;
            } else if (osLow.contains("inux")) {
                linux = true;
            }
        }
        String osArch = System.getProperty("os.arch");
        String archStr = osArch.toLowerCase();
        if (archStr.contains("x86")) {
            x86 = true;
        } else if (archStr.contains("sparc")) {
            sparc = true;
        }
        String javaRtName = System.getProperty("java.runtime.name");
        String javaRtVer = System.getProperty("java.runtime.version");
        String jdkVendor = System.getProperty("java.specification.vendor");
        String jdkName = System.getProperty("java.specification.name");
        String jdkVer = System.getProperty("java.specification.version");
        String osVer = System.getProperty("os.version");
        String jvmSpecName = System.getProperty("java.vm.specification.name");
        String jvmImplVer = System.getProperty("java.vm.version");
        String jvmImplVendor = System.getProperty("java.vm.vendor");
        String jvmImplName = System.getProperty("java.vm.name");
        String jvmArchDataModel = System.getProperty("sun.arch.data.model");
        String jdkStr = javaRtName + ' ' + javaRtVer + ' ' + jvmImplVendor + ' ' + jvmImplName + ' ' + jvmImplVer;
        osStr = osName + ' ' + osVer + ' ' + osArch;
        osJdkStr = osLow + ", " + jdkStr;
        IgniteUtils.osName = osName;
        IgniteUtils.jdkName = jdkName;
        IgniteUtils.jdkVendor = jdkVendor;
        IgniteUtils.jdkVer = jdkVer;
        IgniteUtils.jdkStr = jdkStr;
        IgniteUtils.osVer = osVer;
        IgniteUtils.osArch = osArch;
        IgniteUtils.jvmSpecName = jvmSpecName;
        IgniteUtils.jvmImplVer = jvmImplVer;
        IgniteUtils.jvmImplVendor = jvmImplVendor;
        IgniteUtils.jvmImplName = jvmImplName;
        IgniteUtils.javaRtName = javaRtName;
        IgniteUtils.javaRtVer = javaRtVer;
        jvm32Bit = "32".equals(jvmArchDataModel);
        primitiveMap.put("byte", Byte.TYPE);
        primitiveMap.put("short", Short.TYPE);
        primitiveMap.put("int", Integer.TYPE);
        primitiveMap.put("long", Long.TYPE);
        primitiveMap.put("float", Float.TYPE);
        primitiveMap.put("double", Double.TYPE);
        primitiveMap.put("char", Character.TYPE);
        primitiveMap.put("boolean", Boolean.TYPE);
        primitiveMap.put("void", Void.TYPE);
        boxedClsMap.put(Byte.TYPE, Byte.class);
        boxedClsMap.put(Short.TYPE, Short.class);
        boxedClsMap.put(Integer.TYPE, Integer.class);
        boxedClsMap.put(Long.TYPE, Long.class);
        boxedClsMap.put(Float.TYPE, Float.class);
        boxedClsMap.put(Double.TYPE, Double.class);
        boxedClsMap.put(Character.TYPE, Character.class);
        boxedClsMap.put(Boolean.TYPE, Boolean.class);
        boxedClsMap.put(Void.TYPE, Void.class);
        try {
            OBJECT_CTOR = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw IgniteUtils.withCause(new AssertionError((Object)"Object class does not have empty constructor (is JDK corrupted?)."), e);
        }
        Method ctorFac = null;
        Object refFac = null;
        try {
            Class<?> refFactoryCls = Class.forName("sun.reflect.ReflectionFactory");
            refFac = refFactoryCls.getMethod("getReflectionFactory", new Class[0]).invoke(null, new Object[0]);
            ctorFac = refFac.getClass().getMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException refFactoryCls) {
            // empty catch block
        }
        CTOR_FACTORY = ctorFac;
        SUN_REFLECT_FACTORY = refFac;
        if (Boolean.parseBoolean(System.getProperty("IGNITE_DISABLE_HOSTNAME_VERIFIER"))) {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSes) {
                    return true;
                }
            });
        }
        for (Class cls : evtHolderClasses = new Class[]{EventType.class, DiscoveryCustomEvent.class}) {
            for (Field field2 : cls.getFields()) {
                if (!Modifier.isStatic(field2.getModifiers()) || !field2.getType().equals(Integer.TYPE) || !field2.getName().startsWith("EVT_")) continue;
                try {
                    int type = field2.getInt(null);
                    String prev = GRID_EVT_NAMES.put(type, field2.getName().substring("EVT_".length()));
                    if ($assertionsDisabled || prev == null) continue;
                    throw new AssertionError((Object)("Duplicate event [type=" + type + ", name1=" + prev + ", name2=" + field2.getName() + ']'));
                }
                catch (IllegalAccessException e) {
                    throw new IgniteException(e);
                }
            }
        }
        GRID_EVTS = IgniteUtils.toIntArray(GRID_EVT_NAMES.keySet());
        Arrays.sort(GRID_EVTS);
        if (EventType.EVTS_ALL == null || EventType.EVTS_ALL_MINUS_METRIC_UPDATE == null) {
            try {
                Field f1 = EventType.class.getDeclaredField("EVTS_ALL");
                Field f2 = EventType.class.getDeclaredField("EVTS_ALL_MINUS_METRIC_UPDATE");
                assert (f1 != null);
                assert (f2 != null);
                GridUnsafe.putObjectVolatile(GridUnsafe.staticFieldBase(f1), GridUnsafe.staticFieldOffset(f1), IgniteUtils.gridEvents(new int[0]));
                GridUnsafe.putObjectVolatile(GridUnsafe.staticFieldBase(f2), GridUnsafe.staticFieldOffset(f2), IgniteUtils.gridEvents(13));
                assert (EventType.EVTS_ALL != null);
                assert (EventType.EVTS_ALL.length == GRID_EVTS.length);
                assert (EventType.EVTS_ALL_MINUS_METRIC_UPDATE != null);
                assert (EventType.EVTS_ALL_MINUS_METRIC_UPDATE.length == GRID_EVTS.length - 1);
                for (int type : GRID_EVTS) {
                    assert (IgniteUtils.containsIntArray(EventType.EVTS_ALL, type));
                    if (type != 13) assert (IgniteUtils.containsIntArray(EventType.EVTS_ALL_MINUS_METRIC_UPDATE, type));
                }
                assert (!IgniteUtils.containsIntArray(EventType.EVTS_ALL_MINUS_METRIC_UPDATE, 13));
            }
            catch (NoSuchFieldException e) {
                throw new IgniteException(e);
            }
        }
        exceptionConverters = Collections.unmodifiableMap(IgniteUtils.exceptionConverters());
        System.setProperty("http.strictPostRedirect", "true");
        for (Method mtd : Object.class.getMethods()) {
            if ("hashCode".equals(mtd.getName())) {
                hashCodeMtd = mtd;
                continue;
            }
            if ("equals".equals(mtd.getName())) {
                equalsMtd = mtd;
                continue;
            }
            if (!"toString".equals(mtd.getName())) continue;
            toStringMtd = mtd;
        }
        try {
            clsURLClassPath = Class.forName("jdk.internal.loader.URLClassPath");
            mthdURLClassPathGetUrls = clsURLClassPath.getMethod("getURLs", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            clsURLClassPath = null;
            mthdURLClassPathGetUrls = null;
        }
    }

    public static class LockTracer
    implements Lock {
        private final Lock delegate;
        private final AtomicLong cnt = new AtomicLong();
        private final ConcurrentMap<String, AtomicLong> cntMap = new ConcurrentHashMap<String, AtomicLong>();

        public LockTracer(Lock delegate) {
            this.delegate = delegate;
        }

        private void inc() {
            AtomicLong cnt0;
            this.cnt.incrementAndGet();
            String name = Thread.currentThread().getName();
            AtomicLong cnt = (AtomicLong)this.cntMap.get(name);
            if (cnt == null && (cnt0 = this.cntMap.putIfAbsent(name, cnt = new AtomicLong())) != null) {
                cnt = cnt0;
            }
            cnt.incrementAndGet();
        }

        private void dec() {
            this.cnt.decrementAndGet();
            String name = Thread.currentThread().getName();
            AtomicLong cnt = (AtomicLong)this.cntMap.get(name);
            cnt.decrementAndGet();
        }

        @Override
        public void lock() {
            this.delegate.lock();
            this.inc();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
            this.inc();
        }

        @Override
        public boolean tryLock() {
            if (this.delegate.tryLock()) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (this.delegate.tryLock(time, unit)) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
            this.dec();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            return this.delegate.newCondition();
        }

        public Map<String, AtomicLong> getLockUnlockCounters() {
            return new HashMap<String, AtomicLong>(this.cntMap);
        }

        public long getLockUnlockCounter() {
            return this.cnt.get();
        }
    }

    public static class ReentrantReadWriteLockTracer
    implements ReadWriteLock {
        private final LockTracer readLock;
        private final LockTracer writeLock;

        public ReentrantReadWriteLockTracer(ReadWriteLock delegate) {
            this.readLock = new LockTracer(delegate.readLock());
            this.writeLock = new LockTracer(delegate.writeLock());
        }

        @Override
        @NotNull
        public Lock readLock() {
            return this.readLock;
        }

        @Override
        @NotNull
        public Lock writeLock() {
            return this.writeLock;
        }

        public LockTracer getReadLock() {
            return this.readLock;
        }

        public LockTracer getWriteLock() {
            return this.writeLock;
        }
    }

    private static class DeploymentHostnameVerifier
    implements HostnameVerifier {
        private DeploymentHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession ses) {
            return true;
        }
    }
}

