/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgniteExceptionRegistry {
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    private static final IgniteExceptionRegistry instance = new IgniteExceptionRegistry();
    private int maxSize = IgniteSystemProperties.getInteger("IGNITE_EXCEPTION_REGISTRY_MAX_SIZE", 1000);
    private AtomicLong errCnt = new AtomicLong();
    private final ConcurrentLinkedDeque<ExceptionInfo> q = new ConcurrentLinkedDeque();

    public static IgniteExceptionRegistry get() {
        return instance;
    }

    private IgniteExceptionRegistry() {
    }

    public void onException(String msg, Throwable e) {
        this.q.offerFirst(new ExceptionInfo(this.errCnt.incrementAndGet(), e, msg, Thread.currentThread().getId(), Thread.currentThread().getName(), U.currentTimeMillis()));
        int delta = this.q.size() - this.maxSize;
        for (int i = 0; i < delta && this.q.size() > this.maxSize; ++i) {
            this.q.pollLast();
        }
    }

    public List<ExceptionInfo> getErrors(long order) {
        ArrayList<ExceptionInfo> errors = new ArrayList<ExceptionInfo>();
        for (ExceptionInfo error2 : this.q) {
            if (error2.order <= order) continue;
            errors.add(error2);
        }
        return errors;
    }

    public void setMaxSize(int maxSize) {
        A.ensure(maxSize > 0, "Max queue size must be greater than 0.");
        this.maxSize = maxSize;
    }

    public void printErrors(IgniteLogger log2) {
        int size2 = this.q.size();
        Iterator<ExceptionInfo> descIter = this.q.descendingIterator();
        for (int i = 0; i < size2 && descIter.hasNext(); ++i) {
            ExceptionInfo error2 = descIter.next();
            U.error(log2, "Error: " + (i + 1) + U.nl() + "    Time: " + new Date(error2.time()) + U.nl() + "    Error: " + error2.message() + U.nl() + "    Thread ID: " + error2.threadId() + U.nl() + "    Thread name: " + error2.threadName(), error2.error());
        }
    }

    public long errorCount() {
        return this.errCnt.get();
    }

    public static class ExceptionInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final long order;
        @GridToStringExclude
        private final Throwable error;
        private final long threadId;
        private final String threadName;
        private final long time;
        private String msg;

        public ExceptionInfo(long order, Throwable error2, String msg, long threadId, String threadName, long time) {
            this.order = order;
            this.error = error2;
            this.threadId = threadId;
            this.threadName = threadName;
            this.time = time;
            this.msg = msg;
        }

        public long order() {
            return this.order;
        }

        public String message() {
            return this.msg;
        }

        public Throwable error() {
            return this.error;
        }

        public long threadId() {
            return this.threadId;
        }

        public String threadName() {
            return this.threadName;
        }

        public long time() {
            return this.time;
        }

        public String toString() {
            return S.toString(ExceptionInfo.class, this);
        }
    }
}

