/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GridSynchronizedMap<K, V>
extends ConcurrentHashMap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 0L;

    @Override
    public synchronized V putIfAbsent(K key, V val) {
        return super.putIfAbsent(key, val);
    }

    @Override
    public synchronized boolean remove(Object key, Object val) {
        return super.remove(key, val);
    }

    @Override
    public synchronized boolean replace(K key, V oldVal, V newVal) {
        return super.replace(key, oldVal, newVal);
    }

    @Override
    public synchronized V replace(K key, V val) {
        return super.replace(key, val);
    }

    @Override
    public synchronized V put(K key, V val) {
        return super.put(key, val);
    }

    @Override
    public synchronized V remove(Object key) {
        return super.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        int size2 = this.size();
        out.writeInt(size2);
        for (Map.Entry entry2 : this.entrySet()) {
            out.writeObject(entry2.getKey());
            out.writeObject(entry2.getValue());
            --size2;
        }
        assert (size2 == 0) : "Invalid number of entries written: " + size2;
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.put(in.readObject(), in.readObject());
        }
        int mapSize = this.size();
        assert (mapSize == size2) : "Invalid map size after reading [size=" + size2 + ", mapSize=" + size2 + ']';
    }
}

