/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;

public class GridPartitionStateMap
extends AbstractMap<Integer, GridDhtPartitionState>
implements Serializable {
    public static final GridPartitionStateMap EMPTY = new GridPartitionStateMap(0);
    private static final long serialVersionUID = 0L;
    private static final int BITS = 32 - Integer.numberOfLeadingZeros(GridDhtPartitionState.values().length + 1);
    private final BitSet states;
    private int size;

    @Override
    public Set<Map.Entry<Integer, GridDhtPartitionState>> entrySet() {
        return new AbstractSet<Map.Entry<Integer, GridDhtPartitionState>>(){

            @Override
            public Iterator<Map.Entry<Integer, GridDhtPartitionState>> iterator() {
                return new Iterator<Map.Entry<Integer, GridDhtPartitionState>>(){
                    private int idx;
                    private int cur;

                    @Override
                    public boolean hasNext() {
                        this.idx = GridPartitionStateMap.this.states.nextSetBit(this.idx);
                        return this.idx != -1;
                    }

                    @Override
                    public Map.Entry<Integer, GridDhtPartitionState> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.cur = this.idx / BITS;
                        int bitN = this.idx % BITS;
                        int st = 1 << bitN;
                        for (int i = 1; i < BITS - bitN; ++i) {
                            st |= (GridPartitionStateMap.this.states.get(this.idx + i) ? 1 : 0) << i + bitN;
                        }
                        final int ordinal = st - 1;
                        this.idx += BITS - bitN;
                        return new Map.Entry<Integer, GridDhtPartitionState>(){
                            int p;
                            {
                                this.p = cur;
                            }

                            @Override
                            public Integer getKey() {
                                return this.p;
                            }

                            @Override
                            public GridDhtPartitionState getValue() {
                                return GridDhtPartitionState.fromOrdinal(ordinal);
                            }

                            @Override
                            public GridDhtPartitionState setValue(GridDhtPartitionState val) {
                                return GridPartitionStateMap.this.setState(this.p, val);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        GridPartitionStateMap.this.setState(this.cur, null);
                    }
                };
            }

            @Override
            public int size() {
                return GridPartitionStateMap.this.size();
            }
        };
    }

    public GridPartitionStateMap() {
        this.states = new BitSet();
    }

    public GridPartitionStateMap(int parts) {
        this.states = new BitSet(parts * BITS);
    }

    public GridPartitionStateMap(GridPartitionStateMap from2, boolean onlyActive) {
        this.size = from2.size();
        this.states = (BitSet)from2.states.clone();
        if (onlyActive) {
            int maxPart = this.states.size() / BITS;
            for (int part = 0; part < maxPart; ++part) {
                GridDhtPartitionState state = from2.state(part);
                if (state == null || state.active()) continue;
                this.remove(part);
            }
        }
    }

    @Override
    public GridDhtPartitionState put(Integer key, GridDhtPartitionState val) {
        assert (val != null);
        return this.setState(key, val);
    }

    @Override
    public GridDhtPartitionState get(Object key) {
        return this.state((Integer)key);
    }

    @Override
    public GridDhtPartitionState remove(Object key) {
        return this.setState((Integer)key, null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.state((Integer)key) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private GridDhtPartitionState setState(int part, GridDhtPartitionState st) {
        GridDhtPartitionState old = this.state(part);
        if (old == st) {
            return old;
        }
        int off = part * BITS;
        int ist = st == null ? 0 : st.ordinal() + 1;
        for (int i = 0; i < BITS; ++i) {
            this.states.set(off + i, (ist & 1) == 1);
            ist >>>= 1;
        }
        this.size += st == null ? -1 : (old == null ? 1 : 0);
        return old;
    }

    private GridDhtPartitionState state(int part) {
        int off = part * BITS;
        int st = 0;
        for (int i = 0; i < BITS; ++i) {
            st |= (this.states.get(off + i) ? 1 : 0) << i;
        }
        return st == 0 ? null : GridDhtPartitionState.fromOrdinal(st - 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridPartitionStateMap map2 = (GridPartitionStateMap)o;
        return this.size == map2.size && this.states.equals(map2.states);
    }

    @Override
    public int hashCode() {
        return 31 * this.states.hashCode() + this.size;
    }
}

