/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridListSet<V>
extends GridSerializableSet<V>
implements Cloneable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private LinkedList<V> vals = new LinkedList();
    @GridToStringInclude
    private Comparator<V> comp;
    private boolean strict;

    public GridListSet() {
        this.comp = null;
        this.strict = true;
    }

    public GridListSet(@Nullable Comparator<V> comp) {
        this.comp = comp;
        this.strict = true;
    }

    public GridListSet(@Nullable Comparator<V> comp, boolean strict) {
        this.comp = comp;
        this.strict = strict;
    }

    public GridListSet(GridListSet<V> copy2) {
        assert (copy2 != null);
        this.comp = copy2.comp;
        this.strict = copy2.strict;
        this.addAll(copy2);
    }

    public boolean strict() {
        return this.strict;
    }

    @Nullable
    public Comparator<V> comparator() {
        return this.comp;
    }

    @Override
    public boolean add(V val) {
        return this.addx(val) == null;
    }

    @Nullable
    public V addx(V val) {
        A.notNull(val, "val");
        if (this.comp == null) {
            for (Object v : this.vals) {
                if (!v.equals(val)) continue;
                return (V)v;
            }
            this.vals.add(val);
            return null;
        }
        if (this.strict) {
            ListIterator<V> it = this.vals.listIterator();
            while (it.hasNext()) {
                Object v = it.next();
                if (v.equals(val)) {
                    return (V)v;
                }
                int c = this.comp.compare(v, val);
                if (c == 0) {
                    throw new IllegalStateException("Inconsistent equals and compare methods.");
                }
                if (c <= 0) continue;
                it.previous();
                it.add(val);
                return null;
            }
            this.vals.add(val);
            return null;
        }
        for (Object v : this.vals) {
            if (!v.equals(val)) continue;
            return (V)v;
        }
        Iterator<V> it = this.vals.listIterator();
        while (it.hasNext()) {
            Object v;
            v = it.next();
            if (this.comp.compare(v, val) <= 0) continue;
            while (this.comp.compare(v = it.previous(), val) == 0) {
            }
            it.add(val);
            return null;
        }
        this.vals.add(val);
        return null;
    }

    @Nullable
    public V removeFirst() {
        return this.vals.isEmpty() ? null : (V)this.vals.removeFirst();
    }

    @Nullable
    public V removeLast() {
        return this.vals.isEmpty() ? null : (V)this.vals.removeLast();
    }

    @Nullable
    public V first() {
        return this.vals.isEmpty() ? null : (V)this.vals.getFirst();
    }

    @Nullable
    public V last() {
        return this.vals.isEmpty() ? null : (V)this.vals.getLast();
    }

    @Override
    public boolean remove(Object val) {
        A.notNull(val, "val");
        return this.removex(val) != null;
    }

    @Nullable
    public V removex(V val) {
        A.notNull(val, "val");
        if (this.comp == null || !this.strict) {
            Iterator it = this.vals.iterator();
            while (it.hasNext()) {
                Object v = it.next();
                if (!v.equals(val)) continue;
                it.remove();
                return (V)v;
            }
            return null;
        }
        assert (this.comp != null && this.strict);
        Iterator it = this.vals.iterator();
        while (it.hasNext()) {
            Object v = it.next();
            if (v.equals(val)) {
                it.remove();
                return (V)v;
            }
            if (this.comp.compare(v, val) <= 0) continue;
            break;
        }
        return null;
    }

    @Nullable
    public V get(V val) {
        A.notNull(val, "val");
        if (this.comp == null || !this.strict) {
            for (Object v : this.vals) {
                if (!v.equals(val)) continue;
                return (V)v;
            }
            return null;
        }
        assert (this.comp != null && this.strict);
        for (Object v : this.vals) {
            if (v.equals(val)) {
                return (V)v;
            }
            if (this.comp.compare(v, val) <= 0) continue;
            break;
        }
        return null;
    }

    public V get(int idx) {
        A.ensure(idx >= 0 && idx < this.size(), "idx >= 0 && idx < size()");
        return this.vals.get(idx);
    }

    @Override
    public boolean contains(Object val) {
        A.notNull(val, "val");
        if (this.comp != null && this.strict) {
            for (Object v : this.vals) {
                if (v.equals(val)) {
                    return true;
                }
                if (this.comp.compare(v, val) <= 0) continue;
                break;
            }
            return false;
        }
        return this.vals.contains(val);
    }

    public GridListSet<V> copy() {
        return new GridListSet<V>(this);
    }

    @Override
    public Iterator<V> iterator() {
        return this.vals.iterator();
    }

    @Override
    public int size() {
        return this.vals.size();
    }

    public List<V> values() {
        return new ArrayList<V>(this.vals);
    }

    protected Object clone() throws CloneNotSupportedException {
        GridListSet clone2 = (GridListSet)super.clone();
        clone2.vals = (LinkedList)this.vals.clone();
        clone2.comp = this.comp;
        clone2.strict = this.strict;
        return clone2;
    }

    @Override
    public String toString() {
        return S.toString(GridListSet.class, this);
    }

    public GridListSet<V> toSynchronized() {
        final GridListSet set = this;
        return new GridListSet<V>(){

            @Override
            public synchronized boolean add(V val) {
                return set.add(val);
            }

            @Override
            public synchronized V addx(V val) {
                return set.addx(val);
            }

            @Override
            public synchronized Object clone() throws CloneNotSupportedException {
                return set.clone();
            }

            @Override
            public synchronized boolean contains(Object val) {
                return set.contains(val);
            }

            @Override
            public synchronized GridListSet<V> copy() {
                return set.copy();
            }

            @Override
            public synchronized V get(int idx) {
                return set.get(idx);
            }

            @Override
            public synchronized V get(V val) {
                return set.get(val);
            }

            @Override
            public synchronized Iterator<V> iterator() {
                return set.iterator();
            }

            @Override
            public synchronized boolean remove(Object val) {
                return set.remove(val);
            }

            @Override
            public synchronized V removex(V val) {
                return set.removex(val);
            }

            @Override
            public synchronized int size() {
                return set.size();
            }

            @Override
            public synchronized String toString() {
                return set.toString();
            }

            @Override
            public synchronized GridListSet<V> toSynchronized() {
                return set.toSynchronized();
            }

            @Override
            public synchronized boolean equals(Object o) {
                return set.equals(o);
            }

            @Override
            public synchronized int hashCode() {
                return set.hashCode();
            }

            @Override
            public synchronized boolean removeAll(Collection<?> c) {
                return set.removeAll(c);
            }

            @Override
            public synchronized boolean addAll(Collection<? extends V> c) {
                return set.addAll(c);
            }

            @Override
            public synchronized void clear() {
                set.clear();
            }

            @Override
            public synchronized boolean containsAll(Collection<?> c) {
                return set.containsAll(c);
            }

            @Override
            public synchronized boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public synchronized boolean retainAll(Collection<?> c) {
                return set.retainAll(c);
            }

            @Override
            public synchronized Object[] toArray() {
                return set.toArray();
            }

            @Override
            public synchronized <T> T[] toArray(T[] a) {
                return set.toArray(a);
            }

            @Override
            public synchronized V first() {
                return set.first();
            }

            @Override
            public synchronized V removeFirst() {
                return set.removeFirst();
            }

            @Override
            public synchronized List<V> values() {
                return set.values();
            }

            @Override
            public V last() {
                return set.last();
            }

            @Override
            public V removeLast() {
                return set.removeLast();
            }
        };
    }
}

