/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public final class GridJavaProcess {
    public static final String PID_MSG_PREFIX = "my_pid_is:";
    private IgniteLogger log;
    private Process proc;
    private volatile String pid = "-1";
    private ProcessStreamGrabber osGrabber;
    private ProcessStreamGrabber esGrabber;
    private GridAbsClosure procKilledC;

    private GridJavaProcess() {
    }

    public static GridJavaProcess exec(Class cls, String params2, @Nullable IgniteLogger log2, @Nullable IgniteInClosure<String> printC, @Nullable GridAbsClosure procKilledC) throws Exception {
        return GridJavaProcess.exec(cls.getCanonicalName(), params2, log2, printC, procKilledC, null, null, null);
    }

    public static GridJavaProcess exec(Class cls, String params2, @Nullable IgniteLogger log2, @Nullable IgniteInClosure<String> printC, @Nullable GridAbsClosure procKilledC, @Nullable Collection<String> jvmArgs, @Nullable String cp) throws Exception {
        return GridJavaProcess.exec(cls.getCanonicalName(), params2, log2, printC, procKilledC, null, jvmArgs, cp);
    }

    public static GridJavaProcess exec(String clsName, String params2, @Nullable IgniteLogger log2, @Nullable IgniteInClosure<String> printC, @Nullable GridAbsClosure procKilledC, @Nullable String javaHome, @Nullable Collection<String> jvmArgs, @Nullable String cp) throws Exception {
        GridJavaProcess gjProc = new GridJavaProcess();
        gjProc.log = log2;
        gjProc.procKilledC = procKilledC;
        List procParams = params2 == null || params2.isEmpty() ? Collections.emptyList() : Arrays.asList(params2.split(" "));
        ArrayList<String> procCommands = new ArrayList<String>();
        String javaBin = (javaHome == null ? System.getProperty("java.home") : javaHome) + File.separator + "bin" + File.separator + "java";
        procCommands.add(javaBin);
        procCommands.addAll(jvmArgs == null ? U.jvmArgs() : jvmArgs);
        if (jvmArgs == null || !jvmArgs.contains("-cp") && !jvmArgs.contains("-classpath")) {
            String classpath = System.getProperty("java.class.path");
            String sfcp = System.getProperty("surefire.test.class.path");
            if (sfcp != null) {
                classpath = classpath + System.getProperty("path.separator") + sfcp;
            }
            if (cp != null) {
                classpath = classpath + System.getProperty("path.separator") + cp;
            }
            procCommands.add("-cp");
            procCommands.add(classpath);
        }
        procCommands.add(clsName);
        procCommands.addAll(procParams);
        ProcessBuilder builder = new ProcessBuilder(procCommands);
        builder.redirectErrorStream(true);
        Process proc = builder.start();
        GridJavaProcess gridJavaProcess = gjProc;
        gridJavaProcess.getClass();
        gjProc.osGrabber = gridJavaProcess.new ProcessStreamGrabber(proc.getInputStream(), printC);
        GridJavaProcess gridJavaProcess2 = gjProc;
        gridJavaProcess2.getClass();
        gjProc.esGrabber = gridJavaProcess2.new ProcessStreamGrabber(proc.getErrorStream(), printC);
        gjProc.osGrabber.start();
        gjProc.esGrabber.start();
        gjProc.proc = proc;
        return gjProc;
    }

    public void kill() throws Exception {
        Process killProc = U.isWindows() ? Runtime.getRuntime().exec(new String[]{"taskkill", "/pid", this.pid, "/f", "/t"}) : Runtime.getRuntime().exec(new String[]{"kill", "-9", this.pid});
        killProc.waitFor();
        int exitVal = killProc.exitValue();
        if (exitVal != 0) {
            this.log.info(String.format("Abnormal exit value of %s for pid %s", exitVal, this.pid));
        }
        if (this.procKilledC != null) {
            this.procKilledC.apply();
        }
        U.interrupt(this.osGrabber);
        U.interrupt(this.esGrabber);
        U.join(this.osGrabber, this.log);
        U.join(this.esGrabber, this.log);
    }

    public void killProcess() {
        this.proc.destroy();
        if (this.procKilledC != null) {
            this.procKilledC.apply();
        }
        U.interrupt(this.osGrabber);
        U.interrupt(this.esGrabber);
        U.join(this.osGrabber, this.log);
        U.join(this.esGrabber, this.log);
    }

    public int getPid() {
        return Integer.valueOf(this.pid);
    }

    public Process getProcess() {
        return this.proc;
    }

    private class ProcessStreamGrabber
    extends Thread {
        private final InputStream streamToGrab;
        private final IgniteInClosure<String> printC;

        ProcessStreamGrabber(@Nullable InputStream streamToGrab, IgniteInClosure<String> printC) {
            this.streamToGrab = streamToGrab;
            this.printC = printC;
        }

        @Override
        public void run() {
            block7: {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.streamToGrab));
                    while ((line = br.readLine()) != null && !this.isInterrupted()) {
                        if (line.startsWith(GridJavaProcess.PID_MSG_PREFIX)) {
                            GridJavaProcess.this.pid = line.substring(GridJavaProcess.PID_MSG_PREFIX.length());
                            continue;
                        }
                        if (this.printC == null) continue;
                        this.printC.apply(line);
                    }
                }
                catch (IOException e) {
                    U.error(GridJavaProcess.this.log, "Caught IOException while grabbing stream", e);
                    try {
                        GridJavaProcess.this.proc.exitValue();
                        if (GridJavaProcess.this.procKilledC != null) {
                            GridJavaProcess.this.procKilledC.apply();
                        }
                    }
                    catch (IllegalThreadStateException e1) {
                        if (ProcessStreamGrabber.interrupted()) break block7;
                        U.error(GridJavaProcess.this.log, "Failed to get exit value from process.", e1);
                    }
                }
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            U.closeQuiet(GridJavaProcess.this.proc.getErrorStream());
            U.closeQuiet(GridJavaProcess.this.proc.getInputStream());
            U.closeQuiet(GridJavaProcess.this.proc.getOutputStream());
        }
    }
}

