/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class GridConfigurationFinder {
    private static final String DFLT_CFG = "config" + File.separator + "default-config.xml";
    public static final String Q_PREFIX = "(?)";
    private static final int Q_PREFIX_LEN = "(?)".length();

    private GridConfigurationFinder() {
    }

    public static List<GridTuple3<String, Long, File>> getConfigFiles() throws IOException {
        return GridConfigurationFinder.getConfigFiles(new File(U.getIgniteHome()));
    }

    private static List<GridTuple3<String, Long, File>> getConfigFiles(File dir) throws IOException {
        assert (dir != null);
        LinkedList<GridTuple3<String, Long, File>> lst = GridConfigurationFinder.listFiles(dir);
        Collections.sort(lst, new Comparator<GridTuple3<String, Long, File>>(){

            @Override
            public int compare(GridTuple3<String, Long, File> t1, GridTuple3<String, Long, File> t2) {
                String s1 = t1.get1();
                String s2 = t2.get1();
                String q1 = s1.startsWith(GridConfigurationFinder.Q_PREFIX) ? s1.substring(Q_PREFIX_LEN + 1) : s1;
                String q2 = s2.startsWith(GridConfigurationFinder.Q_PREFIX) ? s2.substring(Q_PREFIX_LEN + 1) : s2;
                return q1.compareTo(q2);
            }
        });
        File dflt = new File(U.getIgniteHome() + File.separator + DFLT_CFG);
        if (dflt.exists()) {
            lst.addFirst(F.t(DFLT_CFG, dflt.lastModified(), dflt));
        }
        return lst;
    }

    private static LinkedList<GridTuple3<String, Long, File>> listFiles(File dir) throws IOException {
        assert (dir != null);
        LinkedList<GridTuple3<String, Long, File>> paths = new LinkedList<GridTuple3<String, Long, File>>();
        String[] configs = dir.list();
        if (configs != null) {
            for (String name : configs) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    paths.addAll(GridConfigurationFinder.listFiles(file));
                    continue;
                }
                if (!file.getName().endsWith(".xml")) continue;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    boolean springCfg = false;
                    boolean ggCfg = false;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("http://www.springframework.org/schema/beans")) {
                            springCfg = true;
                        }
                        if (line.contains("class=\"org.apache.ignite.configuration.IgniteConfiguration\"")) {
                            ggCfg = true;
                        }
                        if (!springCfg || !ggCfg) continue;
                    }
                    if (!springCfg) continue;
                    String path2 = file.getAbsolutePath().substring(U.getIgniteHome().length());
                    if (path2.startsWith(File.separator)) {
                        path2 = path2.substring(File.separator.length());
                    }
                    if (path2.equals(DFLT_CFG)) continue;
                    if (!ggCfg) {
                        path2 = "(?) " + path2;
                    }
                    paths.add(F.t(path2, file.lastModified(), file));
                }
            }
        }
        return paths;
    }
}

