/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.Nullable;

public class GridConcurrentWeakHashSet<E>
implements Set<E> {
    private static final Object[] EMPTY_ARR = new Object[0];
    @GridToStringInclude
    private GridConcurrentHashSet<WeakReferenceElement<E>> store;
    @GridToStringExclude
    private final ReferenceQueue<E> gcQ = new ReferenceQueue();
    private final IgniteClosure<E, WeakReferenceElement<E>> fact = new IgniteClosure<E, WeakReferenceElement<E>>(){

        @Override
        public WeakReferenceElement<E> apply(E e) {
            assert (e != null);
            return new WeakReferenceElement(e, GridConcurrentWeakHashSet.this.gcQ);
        }
    };

    public GridConcurrentWeakHashSet() {
        this.store = new GridConcurrentHashSet();
    }

    public GridConcurrentWeakHashSet(int initCap) {
        this.store = new GridConcurrentHashSet(initCap);
    }

    public GridConcurrentWeakHashSet(int initCap, float loadFactor, int conLevel) {
        this.store = new GridConcurrentHashSet(initCap, loadFactor, conLevel);
    }

    public GridConcurrentWeakHashSet(Collection<E> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        A.notNull(e, "e");
        this.removeStale();
        if (!this.contains(e)) {
            return this.store.add(this.fact.apply(e));
        }
        return false;
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        boolean res = false;
        if (!F.isEmpty(c)) {
            assert (c != null);
            for (E e : c) {
                res |= this.add(e);
            }
        }
        return res;
    }

    @Override
    public boolean retainAll(@Nullable Collection<?> c) {
        this.removeStale();
        boolean res = false;
        if (!F.isEmpty(c)) {
            assert (c != null);
            Iterator iter2 = this.store.iterator();
            while (iter2.hasNext()) {
                if (c.contains(((WeakReferenceElement)iter2.next()).get())) continue;
                iter2.remove();
                res = true;
            }
        }
        return res;
    }

    @Override
    public int size() {
        this.removeStale();
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        this.removeStale();
        return this.store.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        this.removeStale();
        if (!this.store.isEmpty() && o != null) {
            for (WeakReferenceElement weakReferenceElement : this.store) {
                Object reft = weakReferenceElement.get();
                if (reft == null || !reft.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        if (F.isEmpty(c)) {
            return false;
        }
        assert (c != null);
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(EMPTY_ARR);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.removeStale();
        LinkedList elems = new LinkedList();
        for (WeakReferenceElement weakReferenceElement : this.store) {
            Object e = weakReferenceElement.get();
            if (e == null) continue;
            elems.add(e);
        }
        return elems.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        this.removeStale();
        return new Iterator<E>(){
            private Iterator<WeakReferenceElement<E>> iter;
            private E elem;
            {
                this.iter = GridConcurrentWeakHashSet.this.store.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.elem == null) {
                    while (this.iter.hasNext()) {
                        Object e;
                        WeakReferenceElement ref2 = this.iter.next();
                        if (ref2 != null && (e = ref2.get()) != null) {
                            this.elem = e;
                            break;
                        }
                        GridConcurrentWeakHashSet.this.removeStale();
                    }
                }
                return this.elem != null;
            }

            @Override
            public E next() {
                if (this.elem == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = this.elem;
                this.elem = null;
                return res;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        this.removeStale();
        if (o != null) {
            Iterator iter2 = this.store.iterator();
            while (iter2.hasNext()) {
                Object reft = ((WeakReferenceElement)iter2.next()).get();
                if (reft == null || !reft.equals(o)) continue;
                iter2.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> c) {
        boolean res = false;
        if (!F.isEmpty(c)) {
            assert (c != null);
            for (Object o : c) {
                res |= this.remove(o);
            }
        }
        return res;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridConcurrentWeakHashSet)) {
            return false;
        }
        GridConcurrentWeakHashSet that = (GridConcurrentWeakHashSet)o;
        return this.store.equals(that.store);
    }

    @Override
    public int hashCode() {
        return this.store.hashCode();
    }

    private void removeStale() {
        WeakReferenceElement ref2;
        while ((ref2 = (WeakReferenceElement)this.gcQ.poll()) != null) {
            this.store.remove(ref2);
            this.onGc(ref2.get());
        }
    }

    protected void onGc(E e) {
    }

    public String toString() {
        return S.toString(GridConcurrentWeakHashSet.class, this);
    }

    private static class WeakReferenceElement<E>
    extends WeakReference<E> {
        private int hashCode;

        private WeakReferenceElement(E reft, ReferenceQueue<? super E> queue) {
            super(reft, queue);
            this.hashCode = reft != null ? reft.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakReferenceElement)) {
                return false;
            }
            Object thisReft = this.get();
            Object thatReft = ((Reference)o).get();
            return thisReft != null ? thisReft.equals(thatReft) : thatReft == null;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

