/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public abstract class GridClientByteUtils {
    public static byte[] shortToBytes(short s2) {
        return GridClientByteUtils.toBytes(s2, new byte[2], 0, 2);
    }

    public static byte[] intToBytes(int i) {
        return GridClientByteUtils.toBytes(i, new byte[4], 0, 4);
    }

    public static byte[] longToBytes(long l) {
        return GridClientByteUtils.toBytes(l, new byte[8], 0, 8);
    }

    public static int shortToBytes(short s2, byte[] bytes2, int off) {
        GridClientByteUtils.toBytes(s2, bytes2, off, 2);
        return 2;
    }

    public static int intToBytes(int i, byte[] bytes2, int off) {
        GridClientByteUtils.toBytes(i, bytes2, off, 4);
        return 4;
    }

    public static int longToBytes(long l, byte[] bytes2, int off) {
        GridClientByteUtils.toBytes(l, bytes2, off, 8);
        return 8;
    }

    public static byte[] uuidToBytes(UUID uuid) {
        byte[] bytes2 = new byte[16];
        GridClientByteUtils.uuidToBytes(uuid, bytes2, 0);
        return bytes2;
    }

    public static int uuidToBytes(UUID uuid, byte[] bytes2, int off) {
        ByteBuffer buf = ByteBuffer.wrap(bytes2, off, 16);
        buf.order(ByteOrder.BIG_ENDIAN);
        if (uuid != null) {
            buf.putLong(uuid.getMostSignificantBits());
            buf.putLong(uuid.getLeastSignificantBits());
        } else {
            buf.putLong(0L);
            buf.putLong(0L);
        }
        return 16;
    }

    public static short bytesToShort(byte[] bytes2, int off) {
        return (short)GridClientByteUtils.fromBytes(bytes2, off, 2);
    }

    public static int bytesToInt(byte[] bytes2, int off) {
        return (int)GridClientByteUtils.fromBytes(bytes2, off, 4);
    }

    public static long bytesToLong(byte[] bytes2, int off) {
        return GridClientByteUtils.fromBytes(bytes2, off, 8);
    }

    public static UUID bytesToUuid(byte[] bytes2, int off) {
        ByteBuffer buf = ByteBuffer.wrap(bytes2, off, 16);
        buf.order(ByteOrder.BIG_ENDIAN);
        long most = buf.getLong();
        long least = buf.getLong();
        return most != 0L && least != 0L ? new UUID(most, least) : null;
    }

    private static byte[] toBytes(long l, byte[] bytes2, int off, int limit) {
        assert (bytes2 != null);
        assert (limit <= 8);
        assert (bytes2.length >= off + limit);
        for (int i = limit - 1; i >= 0; --i) {
            bytes2[off + i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return bytes2;
    }

    private static long fromBytes(byte[] bytes2, int off, int limit) {
        assert (bytes2 != null);
        assert (limit <= 8);
        assert (bytes2.length >= off + limit);
        long res = 0L;
        for (int i = 0; i < limit; ++i) {
            res <<= 8;
            res |= (long)(bytes2[off + i] & 0xFF);
        }
        return res;
    }
}

