/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.ignite.internal.util.typedef.internal.A;

public class GridBoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 0L;
    private final int maxCap;
    private final Comparator<? super E> cmp;

    public GridBoundedPriorityQueue(int maxCap, Comparator<? super E> cmp) {
        super(maxCap, cmp);
        A.notNull(cmp, "comparator not null");
        this.maxCap = maxCap;
        this.cmp = cmp;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.maxCap) {
            Object head2 = this.peek();
            if (this.cmp.compare(e, head2) <= 0) {
                return false;
            }
            this.poll();
        }
        return super.offer(e);
    }
}

