/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;

public class GridBoundedConcurrentOrderedSet<E>
extends GridConcurrentSkipListSet<E> {
    private static final long serialVersionUID = 0L;
    private final AtomicInteger cnt = new AtomicInteger(0);
    private int max;

    public GridBoundedConcurrentOrderedSet(int max2) {
        assert (max2 > 0);
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedSet(int max2, Comparator<? super E> comp) {
        super(comp);
        assert (max2 > 0);
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedSet(int max2, Collection<? extends E> c) {
        super(c);
        assert (max2 > 0);
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedSet(int max2, SortedSet<E> s2) {
        super(s2);
        assert (max2 > 0);
        this.max = max2;
    }

    @Override
    public boolean add(E e) {
        GridArgumentCheck.notNull(e, "e");
        if (super.add(e)) {
            int c;
            this.cnt.incrementAndGet();
            while ((c = this.cnt.get()) > this.max) {
                if (!this.cnt.compareAndSet(c, c - 1)) continue;
                try {
                    while (!super.remove(this.first())) {
                    }
                }
                catch (NoSuchElementException e1) {
                    e1.printStackTrace();
                    assert (false) : "Internal error in grid bounded ordered set.";
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int size2 = this.cnt.get();
        return size2 < 0 ? 0 : size2;
    }

    @Override
    public GridBoundedConcurrentOrderedSet<E> clone() {
        GridBoundedConcurrentOrderedSet s2 = (GridBoundedConcurrentOrderedSet)super.clone();
        s2.max = this.max;
        return s2;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.cnt.decrementAndGet();
            return true;
        }
        return false;
    }
}

