/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.jetbrains.annotations.Nullable;

public class GridBoundedConcurrentOrderedMap<K, V>
extends ConcurrentSkipListMap<K, V> {
    private static final long serialVersionUID = 0L;
    private final AtomicInteger cnt = new AtomicInteger();
    private int max;
    private volatile IgniteBiInClosure<K, V> lsnr;

    public GridBoundedConcurrentOrderedMap(int max2) {
        A.ensure(max2 > 0, "max > 0");
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedMap(int max2, Comparator<? super K> comparator) {
        super(comparator);
        A.ensure(max2 > 0, "max > 0");
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedMap(int max2, Map<? extends K, ? extends V> map2) {
        super(map2);
        A.ensure(max2 > 0, "max > 0");
        this.max = max2;
    }

    public GridBoundedConcurrentOrderedMap(int max2, SortedMap<K, V> map2) {
        super(map2);
        A.ensure(max2 > 0, "max > 0");
        this.max = max2;
    }

    public void evictionListener(IgniteBiInClosure<K, V> lsnr) {
        this.lsnr = lsnr;
    }

    public IgniteBiInClosure<K, V> evictionListener() {
        return this.lsnr;
    }

    @Override
    @Nullable
    public V put(K k, V v) {
        A.notNull(k, "k", v, "v");
        V ret = super.put(k, v);
        this.onPut();
        return ret;
    }

    @Override
    @Nullable
    public V putIfAbsent(K k, V v) {
        A.notNull(k, "k", v, "v");
        V ret = super.putIfAbsent(k, v);
        if (ret == null) {
            this.onPut();
        }
        return ret;
    }

    private void onPut() {
        this.cnt.incrementAndGet();
        IgniteBiInClosure<K, V> lsnr = this.lsnr;
        int delta = this.cnt.get() - this.max;
        for (int i = 0; i < delta && this.cnt.get() > this.max; ++i) {
            Map.Entry e = this.pollFirstEntry();
            if (e == null) {
                return;
            }
            this.cnt.decrementAndGet();
            if (lsnr == null) continue;
            lsnr.apply(e.getKey(), e.getValue());
        }
    }

    @Override
    public int size() {
        return this.cnt.get();
    }

    @Override
    public GridBoundedConcurrentOrderedMap<K, V> clone() {
        GridBoundedConcurrentOrderedMap map2 = (GridBoundedConcurrentOrderedMap)super.clone();
        map2.max = this.max;
        return map2;
    }

    @Override
    public V remove(Object o) {
        Object old = super.remove(o);
        if (old != null) {
            this.cnt.decrementAndGet();
        }
        return old;
    }

    @Override
    public boolean remove(Object key, Object val) {
        boolean rmvd = super.remove(key, val);
        if (rmvd) {
            this.cnt.decrementAndGet();
        }
        return rmvd;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

