/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.suggestions;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsConfigurationSuggestions {
    private static final String VM_PARAMS_BASE_PATH = "/proc/sys/vm/";
    private static final String DIRTY_WRITEBACK_CENTISECS = "dirty_writeback_centisecs";
    private static final String DIRTY_EXPIRE_CENTISECS = "dirty_expire_centisecs";
    private static final String SWAPPINESS = "swappiness";
    private static final String ZONE_RECLAIM_MODE = "zone_reclaim_mode";
    private static final String EXTRA_FREE_KBYTES = "extra_free_kbytes";

    public static synchronized List<String> getSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (U.isRedHat()) {
            boolean decParamFlag;
            String expected = "500";
            String value2 = OsConfigurationSuggestions.readVmParam(DIRTY_WRITEBACK_CENTISECS);
            boolean dwcParamFlag = value2 != null && !value2.equals(expected);
            value2 = OsConfigurationSuggestions.readVmParam(DIRTY_EXPIRE_CENTISECS);
            boolean bl = decParamFlag = value2 != null && !value2.equals(expected);
            if (dwcParamFlag || decParamFlag) {
                suggestions.add(String.format("Speed up flushing of dirty pages by OS (alter %s%s%s parameter%s by setting to %s)", dwcParamFlag ? "vm.dirty_writeback_centisecs" : "", dwcParamFlag && decParamFlag ? " and " : "", decParamFlag ? "vm.dirty_expire_centisecs" : "", dwcParamFlag && decParamFlag ? "s" : "", expected));
            }
            if ((value2 = OsConfigurationSuggestions.readVmParam(SWAPPINESS)) != null) {
                try {
                    double maxSwappiness = 10.0;
                    if ((double)Float.parseFloat(value2) > maxSwappiness) {
                        suggestions.add(String.format("Reduce pages swapping ratio (set vm.%s=%f or less)", SWAPPINESS, maxSwappiness));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((value2 = OsConfigurationSuggestions.readVmParam(ZONE_RECLAIM_MODE)) != null) {
                expected = "0";
                if (!value2.equals("0")) {
                    suggestions.add(String.format("Disable NUMA memory reclaim (set vm.%s=%s)", ZONE_RECLAIM_MODE, expected));
                }
            }
            if ((value2 = OsConfigurationSuggestions.readVmParam(EXTRA_FREE_KBYTES)) != null) {
                expected = "1240000";
                if (!value2.equals("1240000")) {
                    suggestions.add(String.format("Avoid direct reclaim and page allocation failures (set vm.%s=%s)", EXTRA_FREE_KBYTES, expected));
                }
            }
        }
        return suggestions;
    }

    @Nullable
    private static String readVmParam(@NotNull String name) {
        try {
            Path path2 = Paths.get(VM_PARAMS_BASE_PATH + name, new String[0]);
            if (!Files.exists(path2, new LinkOption[0])) {
                return null;
            }
            return OsConfigurationSuggestions.readLine(path2);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    private static String readLine(@NotNull Path path2) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path2, StandardCharsets.UTF_8);){
            String string2 = reader.readLine();
            return string2;
        }
    }

    public String toString() {
        return S.toString(OsConfigurationSuggestions.class, this);
    }
}

