/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadFormat;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlBulkLoadCommand
implements SqlCommand {
    private String locFileName;
    private SqlQualifiedName tblQName;
    private List<String> cols;
    private BulkLoadFormat inputFormat;
    private Integer packetSize;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        SqlParserUtils.skipIfMatchesKeyword(lex, "FROM");
        this.parseFileName(lex);
        this.parseTableName(lex);
        this.parseColumns(lex);
        this.parseFormat(lex);
        this.parseParameters(lex);
        return this;
    }

    private void parseFileName(SqlLexer lex) {
        if (lex.lookAhead().tokenType() != SqlLexerTokenType.STRING) {
            throw SqlParserUtils.errorUnexpectedToken(lex.lookAhead(), "[file name: string]", new String[0]);
        }
        lex.shift();
        this.locFileName = lex.token();
    }

    private void parseTableName(SqlLexer lex) {
        SqlParserUtils.skipIfMatchesKeyword(lex, "INTO");
        this.tblQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
    }

    private void parseColumns(SqlLexer lex) {
        SqlParserUtils.skipIfMatches(lex, SqlLexerTokenType.PARENTHESIS_LEFT);
        this.cols = new ArrayList<String>();
        do {
            this.cols.add(this.parseColumn(lex));
        } while (!SqlParserUtils.skipCommaOrRightParenthesis(lex));
    }

    private String parseColumn(SqlLexer lex) {
        return SqlParserUtils.parseIdentifier(lex, new String[0]);
    }

    private void parseFormat(SqlLexer lex) {
        SqlParserUtils.skipIfMatchesKeyword(lex, "FORMAT");
        String name = SqlParserUtils.parseIdentifier(lex, new String[0]);
        switch (name.toUpperCase()) {
            case "CSV": {
                BulkLoadCsvFormat fmt = new BulkLoadCsvFormat();
                fmt.lineSeparator(BulkLoadCsvFormat.DEFAULT_LINE_SEPARATOR);
                fmt.fieldSeparator(BulkLoadCsvFormat.DEFAULT_FIELD_SEPARATOR);
                fmt.quoteChars("\"");
                fmt.commentChars(BulkLoadCsvFormat.DEFAULT_COMMENT_CHARS);
                fmt.escapeChars(BulkLoadCsvFormat.DEFAULT_ESCAPE_CHARS);
                this.parseCsvOptions(lex, fmt);
                this.inputFormat = fmt;
                break;
            }
            default: {
                throw SqlParserUtils.error(lex, "Unknown format name: " + name + ". Currently supported format is " + "CSV");
            }
        }
    }

    private void parseCsvOptions(SqlLexer lex, BulkLoadCsvFormat format2) {
        block6: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "CHARSET": {
                    lex.shift();
                    String charsetName = SqlParserUtils.parseString(lex, new String[0]);
                    format2.inputCharsetName(charsetName);
                    continue block6;
                }
            }
            return;
        }
    }

    private void parseParameters(SqlLexer lex) {
        block6: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "PACKET_SIZE": {
                    lex.shift();
                    int size2 = SqlParserUtils.parseInt(lex);
                    if (!BulkLoadAckClientParameters.isValidPacketSize(size2)) {
                        throw SqlParserUtils.error(lex, BulkLoadAckClientParameters.packetSizeErrorMesssage(size2));
                    }
                    this.packetSize = size2;
                    continue block6;
                }
            }
            return;
        }
    }

    @Override
    public String schemaName() {
        return this.tblQName.schemaName();
    }

    @Override
    public void schemaName(String schemaName) {
        this.tblQName.schemaName(schemaName);
    }

    public String tableName() {
        return this.tblQName.name();
    }

    public void tableName(String tblName) {
        this.tblQName.name(tblName);
    }

    public String localFileName() {
        return this.locFileName;
    }

    public void localFileName(String locFileName) {
        this.locFileName = locFileName;
    }

    public List<String> columns() {
        return this.cols;
    }

    public BulkLoadFormat inputFormat() {
        return this.inputFormat;
    }

    public Integer packetSize() {
        return this.packetSize;
    }

    public void packetSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public String toString() {
        return S.toString(SqlBulkLoadCommand.class, this);
    }
}

