/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.internal.sql.SqlKeyword;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.F;

public class SqlParserUtils {
    public static boolean parseIfExists(SqlLexer lex) {
        SqlLexerToken token2 = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(token2, "IF")) {
            lex.shift();
            SqlParserUtils.skipIfMatchesKeyword(lex, "EXISTS");
            return true;
        }
        return false;
    }

    public static boolean parseIfNotExists(SqlLexer lex) {
        SqlLexerToken token2 = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(token2, "IF")) {
            lex.shift();
            SqlParserUtils.skipIfMatchesKeyword(lex, "NOT");
            SqlParserUtils.skipIfMatchesKeyword(lex, "EXISTS");
            return true;
        }
        return false;
    }

    public static boolean skipCommaOrRightParenthesis(SqlLexer lex) {
        if (lex.shift()) {
            switch (lex.tokenType()) {
                case COMMA: {
                    return false;
                }
                case PARENTHESIS_RIGHT: {
                    return true;
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, ",", ")");
    }

    public static int parseInt(SqlLexer lex) {
        int sign2 = 1;
        if (lex.lookAhead().tokenType() == SqlLexerTokenType.MINUS) {
            sign2 = -1;
            lex.shift();
        }
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            try {
                long val = (long)sign2 * Long.parseLong(lex.token());
                if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                    return (int)val;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[integer]");
    }

    public static boolean parseBoolean(SqlLexer lex) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.token()) {
                case "ON": 
                case "1": {
                    return true;
                }
                case "OFF": 
                case "0": {
                    return false;
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "ON", "OFF", "1", "0");
    }

    public static String parseIdentifier(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[identifier]", additionalExpTokens);
    }

    public static String parseUsername(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[username identifier]", additionalExpTokens);
    }

    public static String parseString(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[string]", additionalExpTokens);
    }

    public static SqlQualifiedName parseQualifiedIdentifier(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            SqlQualifiedName res = new SqlQualifiedName();
            String first = lex.token();
            SqlLexerToken nextTok = lex.lookAhead();
            if (nextTok.tokenType() == SqlLexerTokenType.DOT) {
                lex.shift();
                String second = SqlParserUtils.parseIdentifier(lex, new String[0]);
                return res.schemaName(first).name(second);
            }
            return res.name(first);
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[qualified identifier]", additionalExpTokens);
    }

    public static boolean isValidIdentifier(SqlLexerToken token2) {
        switch (token2.tokenType()) {
            case DEFAULT: {
                char c = token2.tokenFirstChar();
                return (c >= 'A' && c <= 'Z' || c == '_') && !SqlKeyword.isKeyword(token2.token());
            }
            case QUOTED: {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesKeyword(SqlLexerToken token2, String expKeyword) {
        return token2.tokenType() == SqlLexerTokenType.DEFAULT && expKeyword.equals(token2.token());
    }

    public static void skipIfMatchesKeyword(SqlLexer lex, String expKeyword) {
        if (lex.shift() && SqlParserUtils.matchesKeyword(lex, expKeyword)) {
            return;
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, expKeyword);
    }

    static void skipIfMatchesOptionalKeyword(SqlLexer lex, String expKeyword) {
        SqlLexerToken nextTok = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(nextTok, expKeyword)) {
            lex.shift();
        }
    }

    public static void skipIfMatches(SqlLexer lex, SqlLexerTokenType tokenTyp) {
        if (lex.shift() && F.eq((Object)lex.tokenType(), (Object)tokenTyp)) {
            return;
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, tokenTyp.asString());
    }

    public static SqlParseException error(SqlLexerToken token2, String msg) {
        return SqlParserUtils.error0(token2, 1001, msg);
    }

    private static SqlParseException error0(SqlLexerToken token2, int code2, String msg) {
        return new SqlParseException(token2.sql(), token2.tokenPosition(), code2, msg);
    }

    public static SqlParseException errorUnexpectedToken(SqlLexerToken token2) {
        return SqlParserUtils.errorUnexpectedToken0(token2, new String[0]);
    }

    public static void errorUnsupportedIfMatchesKeyword(SqlLexerToken token2, String keyword2) {
        if (SqlParserUtils.matchesKeyword(token2, keyword2)) {
            throw SqlParserUtils.errorUnsupported(token2);
        }
    }

    public static void errorUnsupportedIfMatchesKeyword(SqlLexerToken token2, String ... keywords) {
        if (F.isEmpty(keywords)) {
            return;
        }
        for (String keyword2 : keywords) {
            SqlParserUtils.errorUnsupportedIfMatchesKeyword(token2, keyword2);
        }
    }

    public static SqlParseException errorUnsupported(SqlLexerToken token2) {
        throw SqlParserUtils.error0(token2, 1002, "Unsupported keyword: \"" + token2.token() + "\"");
    }

    public static SqlParseException errorUnexpectedToken(SqlLexer lex, String expToken) {
        return SqlParserUtils.errorUnexpectedToken0(lex, expToken);
    }

    public static SqlParseException errorUnexpectedToken(SqlLexerToken token2, String firstExpToken, String ... expTokens) {
        if (F.isEmpty(expTokens)) {
            return SqlParserUtils.errorUnexpectedToken0(token2, firstExpToken);
        }
        String[] expTokens0 = new String[expTokens.length + 1];
        expTokens0[0] = firstExpToken;
        System.arraycopy(expTokens, 0, expTokens0, 1, expTokens.length);
        throw SqlParserUtils.errorUnexpectedToken0(token2, expTokens0);
    }

    private static SqlParseException errorUnexpectedToken0(SqlLexerToken token2, String ... expTokens) {
        String token0 = token2.token();
        StringBuilder msg = new StringBuilder(token0 == null ? "Unexpected end of command" : "Unexpected token: \"" + token0 + "\"");
        if (!F.isEmpty(expTokens)) {
            msg.append(" (expected: ");
            boolean first = true;
            for (String expToken : expTokens) {
                if (first) {
                    first = false;
                } else {
                    msg.append(", ");
                }
                msg.append("\"" + expToken + "\"");
            }
            msg.append(")");
        }
        throw SqlParserUtils.error(token2, msg.toString());
    }

    private SqlParserUtils() {
    }
}

