/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlParseException
extends IgniteException {
    private static final long serialVersionUID = 0L;
    private final String sql;
    private final int pos;
    private final int code;

    public SqlParseException(String sql2, int pos, int code2, String msg) {
        super(SqlParseException.prepareMessage(sql2, pos, msg));
        this.sql = sql2;
        this.pos = pos;
        this.code = code2;
    }

    protected SqlParseException(SqlParseException e) {
        super(e.getMessage());
        this.sql = e.sql;
        this.pos = e.pos;
        this.code = e.code;
    }

    private static String prepareMessage(String sql2, int pos, String msg) {
        String sql0 = pos == sql2.length() ? sql2 + "[*]" : sql2.substring(0, pos) + "[*]" + sql2.substring(pos);
        return "Failed to parse SQL statement \"" + sql0 + "\": " + msg;
    }

    public String sql() {
        return this.sql;
    }

    public int position() {
        return this.pos;
    }

    public int code() {
        return this.code;
    }

    @Override
    public String toString() {
        return S.toString(SqlParseException.class, this, "msg", this.getMessage());
    }
}

