/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import java.util.HashMap;

public enum SqlLexerTokenType {
    DEFAULT,
    QUOTED,
    STRING,
    MINUS(Character.valueOf('-')),
    DOT(Character.valueOf('.')),
    COMMA(Character.valueOf(',')),
    PARENTHESIS_LEFT(Character.valueOf('(')),
    PARENTHESIS_RIGHT(Character.valueOf(')')),
    SEMICOLON(Character.valueOf(';')),
    EOF;

    private static final HashMap<Character, SqlLexerTokenType> CHAR_TO_TYP;
    private final Character c;
    private final String str;

    public static SqlLexerTokenType forChar(char c) {
        return CHAR_TO_TYP.get(Character.valueOf(c));
    }

    private SqlLexerTokenType() {
        this(null);
    }

    private SqlLexerTokenType(Character c) {
        this.c = c;
        this.str = c != null ? c.toString() : null;
    }

    public Character asChar() {
        return this.c;
    }

    public String asString() {
        return this.str;
    }

    static {
        CHAR_TO_TYP = new HashMap();
        for (SqlLexerTokenType typ2 : SqlLexerTokenType.values()) {
            Character c = typ2.asChar();
            if (c == null) continue;
            CHAR_TO_TYP.put(c, typ2);
        }
    }
}

