/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDeploymentException;
import org.jetbrains.annotations.Nullable;

public class GridServiceDeploymentCompoundFuture
extends GridCompoundFuture<Object, Object> {
    private Collection<String> svcsToRollback;
    private volatile ServiceDeploymentException err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processFailure(Throwable err2, IgniteInternalFuture<Object> fut) {
        assert (fut instanceof GridServiceDeploymentFuture) : fut;
        GridServiceDeploymentFuture depFut = (GridServiceDeploymentFuture)fut;
        GridServiceDeploymentCompoundFuture gridServiceDeploymentCompoundFuture = this;
        synchronized (gridServiceDeploymentCompoundFuture) {
            if (this.err == null) {
                this.err = new ServiceDeploymentException("Failed to deploy some services.", new ArrayList<ServiceConfiguration>());
            }
            this.err.getFailedConfigurations().add(depFut.configuration());
            this.err.addSuppressed(err2);
        }
        return true;
    }

    @Override
    protected boolean onDone(@Nullable Object res, @Nullable Throwable err2, boolean cancel) {
        if (err2 == null && this.err != null) {
            err2 = new IgniteCheckedException(this.err);
        }
        return super.onDone(res, err2, cancel);
    }

    public void add(GridServiceDeploymentFuture fut, boolean own) {
        super.add(fut);
        if (own) {
            if (this.svcsToRollback == null) {
                this.svcsToRollback = new ArrayList<String>();
            }
            this.svcsToRollback.add(fut.configuration().getName());
        }
    }

    public Collection<String> servicesToRollback() {
        if (this.svcsToRollback != null) {
            return this.svcsToRollback;
        }
        return Collections.emptyList();
    }
}

