/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import java.util.EnumMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisConnectionCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.key.GridRedisDelCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.key.GridRedisExistsCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.key.GridRedisExpireCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.server.GridRedisDbSizeCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.server.GridRedisFlushCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisAppendCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisGetCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisGetRangeCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisGetSetCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisIncrDecrCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisMGetCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisMSetCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisSetCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisSetRangeCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.string.GridRedisStrlenCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridRedisNioListener
extends GridNioServerListenerAdapter<GridRedisMessage> {
    private final IgniteLogger log;
    protected final Map<GridRedisCommand, GridRedisCommandHandler> handlers = new EnumMap<GridRedisCommand, GridRedisCommandHandler>(GridRedisCommand.class);
    public static final int CONN_CTX_META_KEY = GridNioSessionMetaKey.nextUniqueKey();

    public GridRedisNioListener(IgniteLogger log2, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        this.log = log2;
        this.addCommandHandler(new GridRedisConnectionCommandHandler(log2, hnd, ctx));
        this.addCommandHandler(new GridRedisGetCommandHandler(log2, hnd, ctx));
        this.addCommandHandler(new GridRedisSetCommandHandler(log2, hnd, ctx));
        this.addCommandHandler(new GridRedisMSetCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisMGetCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisIncrDecrCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisAppendCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisGetSetCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisStrlenCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisSetRangeCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisGetRangeCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisDelCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisExistsCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisExpireCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisDbSizeCommandHandler(log2, hnd));
        this.addCommandHandler(new GridRedisFlushCommandHandler(log2, hnd, ctx));
    }

    private void addCommandHandler(GridRedisCommandHandler hnd) {
        assert (!this.handlers.containsValue(hnd));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added Redis command handler: " + hnd);
        }
        for (GridRedisCommand cmd : hnd.supportedCommands()) {
            assert (!this.handlers.containsKey((Object)cmd)) : cmd;
            this.handlers.put(cmd, hnd);
        }
    }

    @Override
    public void onConnected(GridNioSession ses) {
        assert (false);
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        assert (false);
    }

    @Override
    public void onMessage(final GridNioSession ses, GridRedisMessage msg) {
        if (this.handlers.get((Object)msg.command()) == null) {
            U.warn(this.log, "Cannot find the corresponding command (session will be closed) [ses=" + ses + ", command=" + msg.command().name() + ']');
            ses.close();
            return;
        }
        String cacheName = (String)ses.meta(CONN_CTX_META_KEY);
        if (cacheName != null) {
            msg.cacheName(cacheName);
        }
        IgniteInternalFuture<GridRedisMessage> f2 = this.handlers.get((Object)msg.command()).handleAsync(ses, msg);
        f2.listen((IgniteInClosure<IgniteInternalFuture<GridRedisMessage>>)new CIX1<IgniteInternalFuture<GridRedisMessage>>(){

            @Override
            public void applyx(IgniteInternalFuture<GridRedisMessage> f2) throws IgniteCheckedException {
                GridRedisMessage res = f2.get();
                GridRedisNioListener.this.sendResponse(ses, res);
            }
        });
    }

    private GridNioFuture<?> sendResponse(GridNioSession ses, GridRedisMessage res) {
        return ses.send(res);
    }
}

