/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.util.UUID;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridMemcachedMessage
implements GridClientMessage {
    private static final long serialVersionUID = 0L;
    private static final UUID MEMCACHED_ID = UUID.randomUUID();
    public static final int HDR_LEN = 24;
    public static final byte FLAGS_LENGTH = 4;
    public static final byte MEMCACHE_REQ_FLAG = -128;
    public static final byte MEMCACHE_RES_FLAG = -127;
    public static final byte IGNITE_REQ_FLAG = -112;
    public static final byte IGNITE_HANDSHAKE_FLAG = -111;
    public static final byte IGNITE_HANDSHAKE_RES_FLAG = -110;
    public static final int SUCCESS = 0;
    public static final int KEY_NOT_FOUND = 1;
    public static final int FAILURE = 4;
    public static final int SERIALIZED_FLAG = 1;
    public static final int BOOLEAN_FLAG = 256;
    public static final int INT_FLAG = 512;
    public static final int LONG_FLAG = 768;
    public static final int DATE_FLAG = 1024;
    public static final int BYTE_FLAG = 1280;
    public static final int FLOAT_FLAG = 1536;
    public static final int DOUBLE_FLAG = 1792;
    public static final int BYTE_ARR_FLAG = 2048;
    private byte reqFlag;
    private byte opCode;
    private short keyLen;
    private byte extrasLen;
    private int status;
    private int totalLen;
    private byte[] opaque;
    private byte[] extras;
    private Object key;
    private Object val;
    private Long delta;
    private Long init;
    private Long expiration;
    private String cacheName;

    GridMemcachedMessage() {
    }

    GridMemcachedMessage(GridMemcachedMessage req) {
        assert (req != null);
        this.reqFlag = req.reqFlag;
        this.opCode = req.opCode;
        this.opaque = new byte[req.opaque.length];
        U.arrayCopy(req.opaque, 0, this.opaque, 0, req.opaque.length);
    }

    @Override
    public long requestId() {
        return U.bytesToInt(this.opaque, 0);
    }

    @Override
    public void requestId(long reqId) {
        U.intToBytes((int)reqId, this.opaque, 0);
    }

    @Override
    public UUID clientId() {
        return MEMCACHED_ID;
    }

    @Override
    public void clientId(UUID id) {
    }

    @Override
    public UUID destinationId() {
        return null;
    }

    @Override
    public void destinationId(UUID id) {
        throw new UnsupportedOperationException("destId is not supported by memcached packets.");
    }

    @Override
    public byte[] sessionToken() {
        return null;
    }

    @Override
    public void sessionToken(byte[] sesTok) {
    }

    public byte requestFlag() {
        return this.reqFlag;
    }

    public void requestFlag(byte reqFlag) {
        this.reqFlag = reqFlag;
    }

    public byte operationCode() {
        return this.opCode;
    }

    public void operationCode(byte opCode) {
        assert (opCode >= 0);
        this.opCode = opCode;
    }

    public short keyLength() {
        return this.keyLen;
    }

    public void keyLength(short keyLen) {
        assert (keyLen >= 0);
        this.keyLen = keyLen;
    }

    public byte extrasLength() {
        return this.extrasLen;
    }

    public void extrasLength(byte extrasLen) {
        assert (extrasLen >= 0);
        this.extrasLen = extrasLen;
    }

    public int status() {
        return this.status;
    }

    public void status(int status) {
        this.status = status;
    }

    public int totalLength() {
        return this.totalLen;
    }

    public void totalLength(int totalLen) {
        assert (totalLen >= 0);
        this.totalLen = totalLen;
    }

    public byte[] opaque() {
        return this.opaque;
    }

    public void opaque(byte[] opaque) {
        assert (opaque != null);
        this.opaque = opaque;
    }

    public byte[] extras() {
        return this.extras;
    }

    public void extras(byte[] extras2) {
        assert (extras2 != null);
        this.extras = extras2;
    }

    public Object key() {
        return this.key;
    }

    public void key(Object key) {
        assert (key != null);
        this.key = key;
    }

    public Object value() {
        return this.val;
    }

    public void value(Object val) {
        assert (val != null);
        this.val = val;
    }

    @Nullable
    public Long expiration() {
        return this.expiration;
    }

    public void expiration(long expiration) {
        this.expiration = expiration;
    }

    @Nullable
    public Long delta() {
        return this.delta;
    }

    public void delta(long delta) {
        this.delta = delta;
    }

    @Nullable
    public Long initial() {
        return this.init;
    }

    public void initial(long init2) {
        this.init = init2;
    }

    @Nullable
    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        assert (cacheName != null);
        this.cacheName = cacheName;
    }

    public boolean hasFlags() {
        return this.opCode == 1 || this.opCode == 2 || this.opCode == 3 || this.opCode == 17 || this.opCode == 18 || this.opCode == 19;
    }

    public boolean hasExpiration() {
        return this.opCode == 1 || this.opCode == 2 || this.opCode == 3 || this.opCode == 17 || this.opCode == 18 || this.opCode == 19;
    }

    public boolean hasDelta() {
        return this.opCode == 5 || this.opCode == 6 || this.opCode == 21 || this.opCode == 22;
    }

    public boolean hasInitial() {
        return this.opCode == 5 || this.opCode == 6 || this.opCode == 21 || this.opCode == 22;
    }

    public boolean addData() {
        return this.opCode == 0 || this.opCode == 5 || this.opCode == 6 || this.opCode == 9 || this.opCode == 11 || this.opCode == 12 || this.opCode == 13 || this.opCode == 32 || this.opCode == 36 || this.opCode == 37 || this.opCode == 38 || this.opCode == 39 || this.opCode == 40 || this.opCode == 41;
    }

    public boolean addFlags() {
        return this.opCode == 0 || this.opCode == 9 || this.opCode == 12 || this.opCode == 13;
    }

    public String toString() {
        return S.toString(GridMemcachedMessage.class, this);
    }
}

