/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.lang.IgniteClosure;

final class GridResourceUtils {
    private GridResourceUtils() {
    }

    static void inject(Field field2, Object target, Object rsrc) throws IgniteCheckedException {
        if (rsrc != null && !field2.getType().isAssignableFrom(rsrc.getClass())) {
            throw new IgniteCheckedException("Resource field is not assignable from the resource: " + rsrc.getClass());
        }
        try {
            field2.setAccessible(true);
            field2.set(target, rsrc);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | SecurityException e) {
            throw new IgniteCheckedException("Failed to inject resource [field=" + field2.getName() + ", target=" + target + ", rsrc=" + rsrc + ']', e);
        }
    }

    static void inject(Method mtd, Object target, Object rsrc) throws IgniteCheckedException {
        if (mtd.getParameterTypes().length != 1 || rsrc != null && !mtd.getParameterTypes()[0].isAssignableFrom(rsrc.getClass())) {
            throw new IgniteCheckedException("Setter does not have single parameter of required type [type=" + rsrc.getClass().getName() + ", setter=" + mtd + ']');
        }
        try {
            mtd.setAccessible(true);
            mtd.invoke(target, rsrc);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to inject resource [method=" + mtd.getName() + ", target=" + target + ", rsrc=" + rsrc + ']', e);
        }
    }

    static boolean mayRequireResources(Field f2) {
        assert (f2 != null);
        return f2.getName().startsWith("this$") || f2.getName().startsWith("val$") || Callable.class.isAssignableFrom(f2.getType()) || Runnable.class.isAssignableFrom(f2.getType()) || IgniteClosure.class.isAssignableFrom(f2.getType());
    }
}

