/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.resource.GridNoImplicitInjection;
import org.apache.ignite.internal.processors.resource.GridResourceField;
import org.apache.ignite.internal.processors.resource.GridResourceInjector;
import org.apache.ignite.internal.processors.resource.GridResourceMethod;
import org.apache.ignite.internal.processors.resource.GridResourceUtils;
import org.apache.ignite.internal.util.GridLeanIdentitySet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.CacheNameResource;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.FileSystemResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.apache.ignite.resources.LoadBalancerResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.resources.ServiceResource;
import org.apache.ignite.resources.SpringApplicationContextResource;
import org.apache.ignite.resources.SpringResource;
import org.apache.ignite.resources.TaskContinuousMapperResource;
import org.apache.ignite.resources.TaskSessionResource;
import org.jetbrains.annotations.Nullable;

public class GridResourceIoc {
    private final ConcurrentMap<ClassLoader, Set<Class<?>>> taskMap = new ConcurrentHashMap();
    private AtomicReference<Map<Class<?>, ClassDescriptor>> clsDescs = new AtomicReference();

    void onUndeployed(ClassLoader ldr) {
        Set clss = (Set)this.taskMap.remove(ldr);
        if (clss != null) {
            Map<Class<?>, ClassDescriptor> oldMap;
            while ((oldMap = this.clsDescs.get()) != null) {
                HashMap newMap = new HashMap(oldMap.size() - clss.size());
                for (Map.Entry<Class<?>, ClassDescriptor> entry2 : oldMap.entrySet()) {
                    if (clss.contains(entry2.getKey())) continue;
                    newMap.put(entry2.getKey(), entry2.getValue());
                }
                if (!this.clsDescs.compareAndSet(oldMap, newMap)) continue;
            }
        }
    }

    void undeployAll() {
        this.taskMap.clear();
        this.clsDescs.set(null);
    }

    boolean inject(Object target, Class<? extends Annotation> annCls, GridResourceInjector injector, @Nullable GridDeployment dep, @Nullable Class<?> depCls) throws IgniteCheckedException {
        return this.injectInternal(target, annCls, injector, dep, depCls, null);
    }

    ClassDescriptor descriptor(@Nullable GridDeployment dep, Class<?> cls) {
        ClassDescriptor res;
        Map<Class<?>, ClassDescriptor> oldMap;
        ClassDescriptor newDesc = null;
        while ((oldMap = this.clsDescs.get()) == null || (res = oldMap.get(cls)) == null) {
            HashMap newMap;
            if (dep != null) {
                Set classes2 = (Set)((Object)F.addIfAbsent(this.taskMap, dep.classLoader(), F.newCSet()));
                classes2.add(cls);
                dep = null;
            }
            if (oldMap == null) {
                newMap = new HashMap();
            } else {
                newMap = new HashMap(oldMap.size() + 1);
                newMap.putAll(oldMap);
            }
            res = newDesc == null ? new ClassDescriptor(cls) : newDesc;
            newMap.put(cls, res);
            if (!this.clsDescs.compareAndSet(oldMap, newMap)) continue;
        }
        return res;
    }

    private boolean injectInternal(Object target, Class<? extends Annotation> annCls, GridResourceInjector injector, @Nullable GridDeployment dep, @Nullable Class<?> depCls, @Nullable Set<Object> checkedObjs) throws IgniteCheckedException {
        Class<?> targetCls = target.getClass();
        ClassDescriptor descr = this.descriptor(dep, targetCls);
        T2<GridResourceField[], GridResourceMethod[]> annotatedMembers = descr.annotatedMembers(annCls);
        return descr.injectInternal(target, annCls, annotatedMembers, injector, dep, depCls, checkedObjs);
    }

    boolean isAnnotationPresent(Object target, Class<? extends Annotation> annCls, @Nullable GridDeployment dep) {
        assert (target != null);
        assert (annCls != null);
        ClassDescriptor desc = this.descriptor(dep, target.getClass());
        return desc.recursiveFields().length > 0 || desc.annotatedMembers(annCls) != null;
    }

    boolean isAnnotationsPresent(@Nullable GridDeployment dep, Object target, AnnotationSet annSet) {
        assert (target != null);
        assert (annSet != null);
        return this.descriptor(dep, target.getClass()).isAnnotated(annSet) != 0;
    }

    GridResourceMethod[] getMethodsWithAnnotation(@Nullable GridDeployment dep, Class<?> cls, Class<? extends Annotation> annCls) {
        ClassDescriptor desc = this.descriptor(dep, cls);
        T2<GridResourceField[], GridResourceMethod[]> t2 = desc.annotatedMembers(annCls);
        return t2 == null ? GridResourceMethod.EMPTY_ARRAY : (GridResourceMethod[])t2.get2();
    }

    public void printMemoryStats() {
        X.println(">>>   taskMapSize: " + this.taskMap.size(), new Object[0]);
        Map<Class<?>, ClassDescriptor> map2 = this.clsDescs.get();
        X.println(">>>   classDescriptorsCacheSize: " + (map2 == null ? 0 : map2.size()), new Object[0]);
    }

    public static final class AnnotationSet
    extends Enum<AnnotationSet> {
        public static final /* enum */ AnnotationSet GENERIC = new AnnotationSet(ResourceAnnotation.SPRING_APPLICATION_CONTEXT, ResourceAnnotation.SPRING, ResourceAnnotation.IGNITE_INSTANCE, ResourceAnnotation.LOGGER, ResourceAnnotation.SERVICE);
        public static final /* enum */ AnnotationSet ENTRY_PROCESSOR = new AnnotationSet(ResourceAnnotation.CACHE_NAME, ResourceAnnotation.SPRING_APPLICATION_CONTEXT, ResourceAnnotation.SPRING, ResourceAnnotation.IGNITE_INSTANCE, ResourceAnnotation.LOGGER, ResourceAnnotation.SERVICE);
        public static final /* enum */ AnnotationSet TASK = new AnnotationSet(ResourceAnnotation.TASK_SESSION, ResourceAnnotation.LOAD_BALANCER, ResourceAnnotation.TASK_CONTINUOUS_MAPPER, ResourceAnnotation.SPRING_APPLICATION_CONTEXT, ResourceAnnotation.SPRING, ResourceAnnotation.IGNITE_INSTANCE, ResourceAnnotation.LOGGER, ResourceAnnotation.SERVICE);
        public static final /* enum */ AnnotationSet JOB = new AnnotationSet(ResourceAnnotation.TASK_SESSION, ResourceAnnotation.JOB_CONTEXT, ResourceAnnotation.SPRING_APPLICATION_CONTEXT, ResourceAnnotation.SPRING, ResourceAnnotation.IGNITE_INSTANCE, ResourceAnnotation.LOGGER, ResourceAnnotation.SERVICE);
        public final int annotationsBitSet;
        public final ResourceAnnotation[] annotations;
        private static final /* synthetic */ AnnotationSet[] $VALUES;

        public static AnnotationSet[] values() {
            return (AnnotationSet[])$VALUES.clone();
        }

        public static AnnotationSet valueOf(String name) {
            return Enum.valueOf(AnnotationSet.class, name);
        }

        private AnnotationSet(ResourceAnnotation ... annotations2) {
            assert (annotations2.length < 32) : annotations2.length;
            this.annotations = annotations2;
            int mask = 0;
            for (ResourceAnnotation ann : annotations2) {
                mask |= 1 << ann.ordinal();
            }
            this.annotationsBitSet = mask;
        }

        static {
            $VALUES = new AnnotationSet[]{GENERIC, ENTRY_PROCESSOR, TASK, JOB};
        }
    }

    static enum ResourceAnnotation {
        CACHE_NAME(CacheNameResource.class),
        SPRING_APPLICATION_CONTEXT(SpringApplicationContextResource.class),
        SPRING(SpringResource.class),
        IGNITE_INSTANCE(IgniteInstanceResource.class),
        LOGGER(LoggerResource.class),
        SERVICE(ServiceResource.class),
        TASK_SESSION(TaskSessionResource.class),
        LOAD_BALANCER(LoadBalancerResource.class),
        TASK_CONTINUOUS_MAPPER(TaskContinuousMapperResource.class),
        JOB_CONTEXT(JobContextResource.class),
        CACHE_STORE_SESSION(CacheStoreSessionResource.class),
        FILESYSTEM_RESOURCE(FileSystemResource.class);

        public final Class<? extends Annotation> clazz;

        private ResourceAnnotation(Class<? extends Annotation> clazz2) {
            this.clazz = clazz2;
        }
    }

    class ClassDescriptor {
        private final Field[] recursiveFields;
        private final Map<Class<? extends Annotation>, T2<GridResourceField[], GridResourceMethod[]>> annMap;
        private final int[] containsAnnSets;
        private final T2<GridResourceField[], GridResourceMethod[]>[] annArr;

        /*
         * WARNING - void declaration
         */
        ClassDescriptor(Class<?> cls) {
            HashMap annMap = new HashMap();
            ArrayList<Field> recursiveFieldsList = new ArrayList<Field>();
            boolean allowImplicitInjection = !GridNoImplicitInjection.class.isAssignableFrom(cls);
            Class cls0 = cls;
            while (!cls0.equals(Object.class)) {
                int n;
                Annotation[] fieldAnns;
                for (Field field2 : cls0.getDeclaredFields()) {
                    Annotation[] annotationArray = fieldAnns = field2.getAnnotations();
                    n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation ann = annotationArray[i];
                        T2 t2 = (T2)annMap.get(ann.annotationType());
                        if (t2 == null) {
                            t2 = new T2(new ArrayList(), new ArrayList());
                            annMap.put(ann.annotationType(), t2);
                        }
                        ((List)t2.get1()).add(new GridResourceField(field2, ann));
                    }
                    if (!allowImplicitInjection || fieldAnns.length != 0 || !GridResourceUtils.mayRequireResources(field2)) continue;
                    field2.setAccessible(true);
                    recursiveFieldsList.add(field2);
                }
                for (Method method : cls0.getDeclaredMethods()) {
                    fieldAnns = method.getAnnotations();
                    int n2 = fieldAnns.length;
                    for (n = 0; n < n2; ++n) {
                        Annotation ann = fieldAnns[n];
                        T2 t2 = (T2)annMap.get(ann.annotationType());
                        if (t2 == null) {
                            t2 = new T2(new ArrayList(), new ArrayList());
                            annMap.put(ann.annotationType(), t2);
                        }
                        ((List)t2.get2()).add(new GridResourceMethod(method, ann));
                    }
                }
                cls0 = cls0.getSuperclass();
            }
            this.recursiveFields = recursiveFieldsList.isEmpty() ? U.EMPTY_FIELDS : recursiveFieldsList.toArray(new Field[recursiveFieldsList.size()]);
            this.annMap = IgniteUtils.limitedMap(annMap.size());
            for (Map.Entry entry2 : annMap.entrySet()) {
                GridResourceField[] fields = GridResourceField.toArray((Collection)((T2)entry2.getValue()).get1());
                GridResourceMethod[] mtds = GridResourceMethod.toArray((Collection)((T2)entry2.getValue()).get2());
                this.annMap.put((Class<? extends Annotation>)entry2.getKey(), new T2<GridResourceField[], GridResourceMethod[]>(fields, mtds));
            }
            T2[] annArr = null;
            if (annMap.isEmpty()) {
                this.containsAnnSets = null;
            } else {
                void var10_25;
                boolean bl = false;
                ResourceAnnotation[] fields = ResourceAnnotation.values();
                int mtds = fields.length;
                boolean bl2 = false;
                while (var10_25 < mtds) {
                    ResourceAnnotation ann = fields[var10_25];
                    T2<GridResourceField[], GridResourceMethod[]> member = this.annotatedMembers(ann.clazz);
                    if (member != null) {
                        if (annArr == null) {
                            annArr = new T2[ResourceAnnotation.values().length];
                        }
                        annArr[ann.ordinal()] = member;
                        n |= 1 << ann.ordinal();
                    }
                    ++var10_25;
                }
                AnnotationSet[] annotationSets = AnnotationSet.values();
                this.containsAnnSets = new int[annotationSets.length];
                for (int i = 0; i < annotationSets.length; ++i) {
                    int n;
                    this.containsAnnSets[i] = n & annotationSets[i].annotationsBitSet;
                }
            }
            this.annArr = annArr;
        }

        Field[] recursiveFields() {
            return this.recursiveFields;
        }

        @Nullable
        T2<GridResourceField[], GridResourceMethod[]> annotatedMembers(Class<? extends Annotation> annCls) {
            return this.annMap.get(annCls);
        }

        int isAnnotated(AnnotationSet set) {
            return this.recursiveFields.length > 0 ? set.annotationsBitSet : (this.containsAnnSets == null ? 0 : this.containsAnnSets[set.ordinal()]);
        }

        boolean isAnnotated(ResourceAnnotation ann) {
            return this.recursiveFields.length > 0 || this.annArr != null && this.annArr[ann.ordinal()] != null;
        }

        boolean injectInternal(Object target, Class<? extends Annotation> annCls, T2<GridResourceField[], GridResourceMethod[]> annotatedMembers, GridResourceInjector injector, @Nullable GridDeployment dep, @Nullable Class<?> depCls, @Nullable Set<Object> checkedObjs) throws IgniteCheckedException {
            if (this.recursiveFields.length == 0 && annotatedMembers == null) {
                return false;
            }
            if (checkedObjs == null && this.recursiveFields.length > 0) {
                checkedObjs = new GridLeanIdentitySet<Object>();
            }
            if (checkedObjs != null && !checkedObjs.add(target)) {
                return false;
            }
            boolean injected = false;
            for (Field field2 : this.recursiveFields) {
                try {
                    Object obj = field2.get(target);
                    if (obj == null) continue;
                    assert (checkedObjs != null);
                    ClassDescriptor desc = GridResourceIoc.this.descriptor(dep, obj.getClass());
                    injected |= desc.injectInternal(obj, annCls, desc.annotatedMembers(annCls), injector, dep, depCls, checkedObjs);
                }
                catch (IllegalAccessException e) {
                    throw new IgniteCheckedException("Failed to inject resource [field=" + field2.getName() + ", target=" + target + ']', e);
                }
            }
            if (annotatedMembers != null) {
                for (GridResourceField gridResourceField : (GridResourceField[])annotatedMembers.get1()) {
                    injector.inject(gridResourceField, target, depCls, dep);
                    injected = true;
                }
                for (GridResourceMethod gridResourceMethod : (GridResourceMethod[])annotatedMembers.get2()) {
                    injector.inject(gridResourceMethod, target, depCls, dep);
                    injected = true;
                }
            }
            return injected;
        }

        public boolean inject(Object target, ResourceAnnotation ann, GridResourceInjector injector, @Nullable GridDeployment dep, @Nullable Class<?> depCls) throws IgniteCheckedException {
            return this.injectInternal(target, ann.clazz, this.annArr == null ? null : this.annArr[ann.ordinal()], injector, dep, depCls, null);
        }
    }
}

