/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationWorker;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class SchemaOperationManager {
    private final GridKernalContext ctx;
    private final GridQueryProcessor qryProc;
    private final IgniteLogger log;
    private final SchemaOperationWorker worker;
    private final Object mux = new Object();
    private Collection<UUID> nodeIds;
    private Map<UUID, SchemaOperationException> nodeRess;
    private ClusterNode crd;
    private boolean crdMapped;
    private boolean crdFinished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaOperationManager(GridKernalContext ctx, GridQueryProcessor qryProc, SchemaOperationWorker worker, @Nullable ClusterNode crd) {
        assert (!ctx.clientNode() || crd == null);
        this.ctx = ctx;
        this.log = ctx.log(SchemaOperationManager.class);
        this.qryProc = qryProc;
        this.worker = worker;
        Object object = this.mux;
        synchronized (object) {
            this.crd = crd;
            this.prepareCoordinator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.worker.start();
        Object object = this.mux;
        synchronized (object) {
            this.worker.future().listen(new IgniteInClosure<IgniteInternalFuture>(){

                @Override
                public void apply(IgniteInternalFuture fut) {
                    SchemaOperationManager.this.onLocalNodeFinished(fut);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLocalNodeFinished(IgniteInternalFuture fut) {
        SchemaOperationException err2;
        assert (fut.isDone());
        if (this.ctx.clientNode()) {
            return;
        }
        try {
            fut.get();
            err2 = null;
        }
        catch (Exception e) {
            err2 = QueryUtils.wrapIfNeeded(e);
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.isLocalCoordinator()) {
                this.onNodeFinished(this.ctx.localNodeId(), err2);
            } else {
                this.qryProc.sendStatusMessage(this.crd.id(), this.operationId(), err2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeFinished(UUID nodeId, @Nullable SchemaOperationException err2) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.isLocalCoordinator());
            if (this.nodeRess.containsKey(nodeId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received duplicate result [opId=" + this.operationId() + ", nodeId=" + nodeId + ", err=" + err2 + ']');
                }
                return;
            }
            if (this.nodeIds.contains(nodeId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received result [opId=" + this.operationId() + ", nodeId=" + nodeId + ", err=" + err2 + ']');
                }
                this.nodeRess.put(nodeId, err2);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Received result from non-tracked node (joined after operation started, will ignore) [opId=" + this.operationId() + ", nodeId=" + nodeId + ", err=" + err2 + ']');
            }
            this.checkFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeave(UUID nodeId, ClusterNode curCrd) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.crd != null);
            if (F.eq(nodeId, this.crd.id())) {
                this.crd = curCrd;
                this.prepareCoordinator();
            } else if (this.isLocalCoordinator() && this.nodeIds.remove(nodeId)) {
                this.nodeRess.remove(nodeId);
            }
            IgniteInternalFuture fut = this.worker().future();
            if (fut.isDone()) {
                this.onLocalNodeFinished(fut);
            }
            this.checkFinished();
        }
    }

    private void checkFinished() {
        assert (Thread.holdsLock(this.mux));
        if (this.isLocalCoordinator()) {
            if (this.crdFinished) {
                return;
            }
            if (this.nodeIds.size() == this.nodeRess.size()) {
                SchemaOperationException err2 = null;
                for (Map.Entry<UUID, SchemaOperationException> nodeRes : this.nodeRess.entrySet()) {
                    if (nodeRes.getValue() == null) continue;
                    err2 = nodeRes.getValue();
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Collected all results, about to send finish message [opId=" + this.operationId() + ", err=" + err2 + ']');
                }
                this.crdFinished = true;
                this.qryProc.onCoordinatorFinished(this.worker.operation(), err2);
            }
        }
    }

    private boolean prepareCoordinator() {
        if (this.isLocalCoordinator() && !this.crdMapped) {
            this.nodeIds = new HashSet<UUID>();
            this.nodeRess = new HashMap<UUID, SchemaOperationException>();
            for (ClusterNode alive : this.ctx.discovery().aliveServerNodes()) {
                this.nodeIds.add(alive.id());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mapped participating nodes on coordinator [opId=" + this.operationId() + ", crdNodeId=" + this.ctx.localNodeId() + ", nodes=" + this.nodeIds + ']');
            }
            this.crdMapped = true;
            return true;
        }
        return false;
    }

    private boolean isLocalCoordinator() {
        assert (Thread.holdsLock(this.mux));
        return this.crd != null && this.crd.isLocal();
    }

    public SchemaOperationWorker worker() {
        return this.worker;
    }

    private UUID operationId() {
        return this.worker.operation().id();
    }
}

