/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFilter;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class SchemaIndexCacheVisitorImpl
implements SchemaIndexCacheVisitor {
    private static final int DFLT_PARALLELISM = Math.min(4, Math.max(1, Runtime.getRuntime().availableProcessors() / 4));
    private static final int BATCH_SIZE = 1000;
    private final GridCacheContext cctx;
    private final SchemaIndexCacheFilter rowFilter;
    private final SchemaIndexOperationCancellationToken cancel;
    private final int parallelism;
    private volatile boolean stop;

    public SchemaIndexCacheVisitorImpl(GridCacheContext cctx) {
        this(cctx, null, null, 0);
    }

    public SchemaIndexCacheVisitorImpl(GridCacheContext cctx, SchemaIndexCacheFilter rowFilter, SchemaIndexOperationCancellationToken cancel, int parallelism) {
        this.rowFilter = rowFilter;
        this.cancel = cancel;
        this.parallelism = parallelism > 0 ? Math.min(Runtime.getRuntime().availableProcessors(), parallelism) : DFLT_PARALLELISM;
        if (cctx.isNear()) {
            cctx = ((GridNearCacheAdapter)cctx.cache()).dht().context();
        }
        this.cctx = cctx;
    }

    @Override
    public void visit(SchemaIndexCacheVisitorClosure clo) throws IgniteCheckedException {
        assert (clo != null);
        List<GridDhtLocalPartition> parts = this.cctx.topology().localPartitions();
        if (parts.isEmpty()) {
            return;
        }
        GridCompoundFuture fut = null;
        if (this.parallelism > 1) {
            fut = new GridCompoundFuture();
            for (int i = 1; i < this.parallelism; ++i) {
                fut.add(this.processPartitionsAsync(parts, clo, i));
            }
            fut.markInitialized();
        }
        this.processPartitions(parts, clo, 0);
        if (fut != null) {
            fut.get();
        }
    }

    private GridFutureAdapter<Void> processPartitionsAsync(List<GridDhtLocalPartition> parts, SchemaIndexCacheVisitorClosure clo, int remainder) {
        GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
        AsyncWorker worker = new AsyncWorker(parts, clo, remainder, fut);
        new IgniteThread(worker).start();
        return fut;
    }

    private void processPartitions(List<GridDhtLocalPartition> parts, SchemaIndexCacheVisitorClosure clo, int remainder) throws IgniteCheckedException {
        int size2 = parts.size();
        for (int i = 0; i < size2 && !this.stop; ++i) {
            if (i % this.parallelism != remainder) continue;
            this.processPartition(parts.get(i), clo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartition(GridDhtLocalPartition part, SchemaIndexCacheVisitorClosure clo) throws IgniteCheckedException {
        this.checkCancelled();
        boolean reserved = false;
        if (part != null && part.state() != GridDhtPartitionState.EVICTED) {
            boolean bl = reserved = (part.state() == GridDhtPartitionState.OWNING || part.state() == GridDhtPartitionState.RENTING) && part.reserve();
        }
        if (!reserved) {
            return;
        }
        try {
            GridCursor<? extends CacheDataRow> cursor = part.dataStore().cursor(this.cctx.cacheId(), null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
            boolean locked = false;
            try {
                int cntr = 0;
                while (cursor.next() && !this.stop) {
                    KeyCacheObject key = cursor.get().key();
                    if (!locked) {
                        this.cctx.shared().database().checkpointReadLock();
                        locked = true;
                    }
                    this.processKey(key, clo);
                    if (++cntr % 1000 == 0) {
                        this.cctx.shared().database().checkpointReadUnlock();
                        locked = false;
                    }
                    if (part.state() != GridDhtPartitionState.RENTING) continue;
                    break;
                }
            }
            finally {
                if (locked) {
                    this.cctx.shared().database().checkpointReadUnlock();
                }
            }
        }
        finally {
            part.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKey(KeyCacheObject key, SchemaIndexCacheVisitorClosure clo) throws IgniteCheckedException {
        while (true) {
            try {
                this.checkCancelled();
                GridCacheEntryEx entry2 = this.cctx.cache().entryEx(key);
                try {
                    entry2.updateIndex(this.rowFilter, clo);
                }
                finally {
                    entry2.touch(AffinityTopologyVersion.NONE);
                }
            }
            catch (GridDhtInvalidPartitionException ignore) {
            }
            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                continue;
            }
            break;
        }
    }

    private void checkCancelled() throws IgniteCheckedException {
        if (this.cancel != null && this.cancel.isCancelled()) {
            throw new IgniteCheckedException("Index creation was cancelled.");
        }
    }

    public String toString() {
        return S.toString(SchemaIndexCacheVisitorImpl.class, this);
    }

    private class AsyncWorker
    extends GridWorker {
        private final List<GridDhtLocalPartition> parts;
        private final SchemaIndexCacheVisitorClosure clo;
        private final int remainder;
        private final GridFutureAdapter<Void> fut;

        public AsyncWorker(List<GridDhtLocalPartition> parts, SchemaIndexCacheVisitorClosure clo, int remainder, GridFutureAdapter<Void> fut) {
            super(SchemaIndexCacheVisitorImpl.this.cctx.igniteInstanceName(), "parallel-idx-worker-" + SchemaIndexCacheVisitorImpl.this.cctx.cache().name() + "-" + remainder, SchemaIndexCacheVisitorImpl.this.cctx.logger(AsyncWorker.class));
            this.parts = parts;
            this.clo = clo;
            this.remainder = remainder;
            this.fut = fut;
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            Throwable err2 = null;
            try {
                SchemaIndexCacheVisitorImpl.this.processPartitions(this.parts, this.clo, this.remainder);
            }
            catch (Throwable e) {
                err2 = e;
                U.error(this.log, "Error during parallel index create/rebuild.", e);
                SchemaIndexCacheVisitorImpl.this.stop = true;
            }
            finally {
                this.fut.onDone(err2);
            }
        }
    }
}

