/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2SelectForUpdateTxDetails;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridH2QueryRequest
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    public static final int FLAG_DISTRIBUTED_JOINS = 1;
    public static final int FLAG_ENFORCE_JOIN_ORDER = 2;
    public static final int FLAG_IS_LOCAL = 4;
    public static final int FLAG_EXPLAIN = 8;
    public static final int FLAG_REPLICATED = 16;
    public static final int FLAG_LAZY = 32;
    private long reqId;
    @GridToStringInclude
    @GridDirectCollection(value=Integer.class)
    private List<Integer> caches;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=int[].class)
    private Map<UUID, int[]> parts;
    @GridToStringInclude
    private int[] qryParts;
    private int pageSize;
    @GridToStringInclude
    @GridDirectCollection(value=Message.class)
    private List<GridCacheSqlQuery> qrys;
    private byte flags;
    @GridToStringInclude
    @GridDirectCollection(value=Message.class)
    private Collection<QueryTable> tbls;
    private int timeout;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    private String schemaName;
    private MvccSnapshot mvccSnapshot;
    private GridH2SelectForUpdateTxDetails txReq;

    public GridH2QueryRequest() {
    }

    public GridH2QueryRequest(GridH2QueryRequest req) {
        this.reqId = req.reqId;
        this.caches = req.caches;
        this.topVer = req.topVer;
        this.parts = req.parts;
        this.qryParts = req.qryParts;
        this.pageSize = req.pageSize;
        this.qrys = req.qrys;
        this.flags = req.flags;
        this.tbls = req.tbls;
        this.timeout = req.timeout;
        this.params = req.params;
        this.paramsBytes = req.paramsBytes;
        this.schemaName = req.schemaName;
        this.mvccSnapshot = req.mvccSnapshot;
        this.txReq = req.txReq;
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public GridH2QueryRequest mvccSnapshot(MvccSnapshot mvccSnapshot) {
        this.mvccSnapshot = mvccSnapshot;
        return this;
    }

    public Object[] parameters() {
        return this.params;
    }

    public GridH2QueryRequest parameters(Object[] params2) {
        if (params2 == null) {
            params2 = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        this.params = params2;
        return this;
    }

    public GridH2QueryRequest tables(Collection<QueryTable> tbls) {
        this.tbls = tbls;
        return this;
    }

    public Collection<QueryTable> tables() {
        return this.tbls;
    }

    public GridH2QueryRequest requestId(long reqId) {
        this.reqId = reqId;
        return this;
    }

    public long requestId() {
        return this.reqId;
    }

    public GridH2QueryRequest caches(List<Integer> caches) {
        this.caches = caches;
        return this;
    }

    public List<Integer> caches() {
        return this.caches;
    }

    public GridH2QueryRequest topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        return this;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Map<UUID, int[]> partitions() {
        return this.parts;
    }

    public GridH2QueryRequest partitions(Map<UUID, int[]> parts) {
        this.parts = parts;
        return this;
    }

    public int[] queryPartitions() {
        return this.qryParts;
    }

    public GridH2QueryRequest queryPartitions(int[] qryParts) {
        this.qryParts = qryParts;
        return this;
    }

    public GridH2QueryRequest pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridH2QueryRequest queries(List<GridCacheSqlQuery> qrys) {
        this.qrys = qrys;
        return this;
    }

    public List<GridCacheSqlQuery> queries() {
        return this.qrys;
    }

    public GridH2QueryRequest flags(int flags) {
        assert (flags >= 0 && flags <= 255) : flags;
        this.flags = (byte)flags;
        return this;
    }

    public boolean isFlagSet(int flags) {
        return (this.flags & flags) == flags;
    }

    public int timeout() {
        return this.timeout;
    }

    public GridH2QueryRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public GridH2QueryRequest schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public GridH2SelectForUpdateTxDetails txDetails() {
        return this.txReq;
    }

    public void txDetails(GridH2SelectForUpdateTxDetails txDetails) {
        this.txReq = txDetails;
    }

    @Override
    public void marshall(Marshaller m) {
        if (this.paramsBytes != null) {
            return;
        }
        assert (this.params != null);
        try {
            this.paramsBytes = U.marshal(m, (Object)this.params);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        if (this.params != null) {
            return;
        }
        assert (this.paramsBytes != null);
        try {
            ClassLoader ldr = U.resolveClassLoader(ctx.config());
            this.params = m instanceof BinaryMarshaller ? (Object[])((BinaryMarshaller)m).binaryMarshaller().unmarshal(this.paramsBytes, ldr) : (Object[])U.unmarshal(m, this.paramsBytes, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("caches", this.caches, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMap("parts", this.parts, MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("qrys", this.qrys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("tbls", this.tbls, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeIntArray("qryParts", this.qryParts)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeString("schemaName", this.schemaName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeMessage("txReq", this.txReq)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.caches = (List)reader.readCollection("caches", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.parts = reader.readMap("parts", MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.qrys = (List)reader.readCollection("qrys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.tbls = reader.readCollection("tbls", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.timeout = reader.readInt("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.qryParts = reader.readIntArray("qryParts");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.schemaName = reader.readString("schemaName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.txReq = (GridH2SelectForUpdateTxDetails)reader.readMessage("txReq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2QueryRequest.class);
    }

    @Override
    public short directType() {
        return -33;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridH2QueryRequest.class, this);
    }
}

