/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.jdbc.JdbcConnection;
import org.jetbrains.annotations.Nullable;

class ReduceQueryRun {
    private final GridRunningQueryInfo qry;
    private final List<GridMergeIndex> idxs;
    private CountDownLatch latch;
    private final JdbcConnection conn;
    private final int pageSize;
    private final AtomicReference<State> state = new AtomicReference();
    private final GridNearTxSelectForUpdateFuture selectForUpdateFut;

    ReduceQueryRun(Long id, String qry, String schemaName, Connection conn, int idxsCnt, int pageSize, long startTime, GridNearTxSelectForUpdateFuture selectForUpdateFut, GridQueryCancel cancel) {
        this.qry = new GridRunningQueryInfo(id, qry, GridCacheQueryType.SQL_FIELDS, schemaName, startTime, cancel, false);
        this.conn = (JdbcConnection)conn;
        this.idxs = new ArrayList<GridMergeIndex>(idxsCnt);
        this.pageSize = pageSize > 0 ? pageSize : 1000;
        this.selectForUpdateFut = selectForUpdateFut;
    }

    void setStateOnException(@Nullable UUID nodeId, CacheException err2) {
        this.setState0(new State(nodeId, err2, null, null));
    }

    void setStateOnNodeLeave(UUID nodeId, AffinityTopologyVersion topVer) {
        this.setState0(new State(nodeId, null, topVer, "Data node has left the grid during query execution [nodeId=" + nodeId + ']'));
    }

    void setStateOnRetry(UUID nodeId, AffinityTopologyVersion topVer, String retryCause) {
        assert (!F.isEmpty(retryCause));
        this.setState0(new State(nodeId, null, topVer, retryCause));
    }

    private void setState0(State state) {
        if (!this.state.compareAndSet(null, state)) {
            return;
        }
        while (this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
        for (GridMergeIndex idx : this.idxs) {
            idx.fail(state.nodeId, state.ex);
        }
    }

    void disconnected(CacheException e) {
        this.setStateOnException(null, e);
    }

    GridRunningQueryInfo queryInfo() {
        return this.qry;
    }

    int pageSize() {
        return this.pageSize;
    }

    JdbcConnection connection() {
        return this.conn;
    }

    boolean hasErrorOrRetry() {
        return this.state.get() != null;
    }

    CacheException exception() {
        State st = this.state.get();
        return st != null ? st.ex : null;
    }

    AffinityTopologyVersion retryTopologyVersion() {
        State st = this.state.get();
        return st != null ? st.retryTopVer : null;
    }

    UUID retryNodeId() {
        State st = this.state.get();
        return st != null ? st.nodeId : null;
    }

    String retryCause() {
        State st = this.state.get();
        return st != null ? st.retryCause : null;
    }

    List<GridMergeIndex> indexes() {
        return this.idxs;
    }

    CountDownLatch latch() {
        return this.latch;
    }

    void latch(CountDownLatch latch) {
        this.latch = latch;
    }

    @Nullable
    public GridNearTxSelectForUpdateFuture selectForUpdateFuture() {
        return this.selectForUpdateFut;
    }

    private static class State {
        private final UUID nodeId;
        private final CacheException ex;
        private final AffinityTopologyVersion retryTopVer;
        private final String retryCause;

        private State(UUID nodeId, CacheException ex, AffinityTopologyVersion retryTopVer, String retryCause) {
            this.nodeId = nodeId;
            this.ex = ex;
            this.retryTopVer = retryTopVer;
            this.retryCause = retryCause;
        }
    }
}

