/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.ResultSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.jetbrains.annotations.Nullable;

class MapQueryResults {
    private final IgniteH2Indexing h2;
    private final long qryReqId;
    private final AtomicReferenceArray<MapQueryResult> results;
    private final GridQueryCancel[] cancels;
    private final GridCacheContext<?, ?> cctx;
    private final MapQueryLazyWorker lazyWorker;
    private volatile boolean cancelled;
    private final boolean forUpdate;

    MapQueryResults(IgniteH2Indexing h2, long qryReqId, int qrys, @Nullable GridCacheContext<?, ?> cctx, @Nullable MapQueryLazyWorker lazyWorker, boolean forUpdate) {
        this.forUpdate = forUpdate;
        this.h2 = h2;
        this.qryReqId = qryReqId;
        this.cctx = cctx;
        this.lazyWorker = lazyWorker;
        this.results = new AtomicReferenceArray(qrys);
        this.cancels = new GridQueryCancel[qrys];
        for (int i = 0; i < this.cancels.length; ++i) {
            this.cancels[i] = new GridQueryCancel();
        }
    }

    MapQueryResult result(int qry) {
        return this.results.get(qry);
    }

    GridQueryCancel queryCancel(int qryIdx) {
        return this.cancels[qryIdx];
    }

    MapQueryLazyWorker lazyWorker() {
        return this.lazyWorker;
    }

    void addResult(int qry, GridCacheSqlQuery q, UUID qrySrcNodeId, ResultSet rs, Object[] params2) {
        MapQueryResult res = new MapQueryResult(this.h2, rs, this.cctx, qrySrcNodeId, q, params2, this.lazyWorker);
        if (this.lazyWorker != null) {
            this.lazyWorker.result(res);
        }
        if (!this.results.compareAndSet(qry, null, res)) {
            throw new IllegalStateException();
        }
    }

    boolean isAllClosed() {
        for (int i = 0; i < this.results.length(); ++i) {
            MapQueryResult res = this.results.get(i);
            if (res != null && res.closed()) continue;
            return false;
        }
        return true;
    }

    void cancel(boolean forceQryCancel) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        for (int i = 0; i < this.results.length(); ++i) {
            GridQueryCancel cancel;
            MapQueryResult res = this.results.get(i);
            if (res != null) {
                res.close();
                continue;
            }
            if (!forceQryCancel || (cancel = this.cancels[i]) == null) continue;
            cancel.cancel();
        }
    }

    boolean cancelled() {
        return this.cancelled;
    }

    long queryRequestId() {
        return this.qryReqId;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

