/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorkerKey;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.jetbrains.annotations.Nullable;

public class MapQueryLazyWorker
extends GridWorker {
    private static final ThreadLocal<MapQueryLazyWorker> LAZY_WORKER = new ThreadLocal();
    private static final LongAdder ACTIVE_CNT = new LongAdder();
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingDeque<Runnable>();
    private final MapQueryLazyWorkerKey key;
    private final GridMapQueryExecutor exec;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private volatile MapQueryResult res;

    public MapQueryLazyWorker(@Nullable String instanceName, MapQueryLazyWorkerKey key, IgniteLogger log2, GridMapQueryExecutor exec2) {
        super(instanceName, MapQueryLazyWorker.workerName(instanceName, key), log2);
        this.key = key;
        this.exec = exec2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
        LAZY_WORKER.set(this);
        ACTIVE_CNT.increment();
        try {
            while (!this.isCancelled()) {
                Runnable task2 = this.tasks.take();
                if (task2 == null) continue;
                if (!this.exec.busyLock().enterBusy()) {
                    return;
                }
                try {
                    task2.run();
                }
                finally {
                    this.exec.busyLock().leaveBusy();
                }
            }
            return;
        }
        finally {
            if (this.res != null) {
                this.res.close();
            }
            LAZY_WORKER.set(null);
            ACTIVE_CNT.decrement();
            this.exec.unregisterLazyWorker(this);
        }
    }

    public void submit(Runnable task2) {
        this.tasks.add(task2);
    }

    public MapQueryLazyWorkerKey key() {
        return this.key;
    }

    public void stop(final boolean nodeStop) {
        if (MapQueryLazyWorker.currentWorker() == null) {
            this.submit(new Runnable(){

                @Override
                public void run() {
                    MapQueryLazyWorker.this.stop(nodeStop);
                }
            });
        } else {
            GridH2QueryContext qctx = GridH2QueryContext.get();
            if (qctx != null) {
                qctx.clearContext(nodeStop);
                GridH2QueryContext.clearThreadLocal();
            }
            this.isCancelled = true;
            this.stopLatch.countDown();
        }
    }

    public void awaitStop() {
        try {
            U.await(this.stopLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteException("Failed to wait for lazy worker stop (interrupted): " + this.name(), e);
        }
    }

    public void result(MapQueryResult res) {
        this.res = res;
    }

    @Nullable
    public static MapQueryLazyWorker currentWorker() {
        return LAZY_WORKER.get();
    }

    public static int activeCount() {
        return ACTIVE_CNT.intValue();
    }

    private static String workerName(String instanceName, MapQueryLazyWorkerKey key) {
        return "query-lazy-worker_" + instanceName + "_" + key.nodeId() + "_" + key.queryRequestId() + "_" + key.segment();
    }
}

