/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.cache.CacheException;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.value.Value;

public class GridThreadLocalTable
extends Table {
    private final ThreadLocal<Table> tbl = new ThreadLocal();

    public GridThreadLocalTable(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, persistIndexes, persistData);
    }

    public void innerTable(Table t) {
        if (t == null) {
            this.tbl.remove();
        } else {
            this.tbl.set(t);
        }
    }

    private Table innerTable() {
        Table t = this.tbl.get();
        if (t == null) {
            throw new CacheException("Table `" + this.getName() + "` can be accessed only within Ignite query context.");
        }
        return t;
    }

    @Override
    public Index getPrimaryKey() {
        return this.innerTable().getPrimaryKey();
    }

    @Override
    public Column getRowIdColumn() {
        return this.innerTable().getRowIdColumn();
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> cols) {
        return this.innerTable().getBestPlanItem(session, masks, filters, filter2, sortOrder, cols);
    }

    @Override
    public Value getDefaultValue(Session session, Column column) {
        return this.innerTable().getDefaultValue(session, column);
    }

    @Override
    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        return this.innerTable().getTemplateSimpleRow(singleColumn);
    }

    @Override
    public Row getTemplateRow() {
        return this.innerTable().getTemplateRow();
    }

    @Override
    public Column getColumn(String columnName) {
        return this.innerTable().getColumn(columnName);
    }

    @Override
    public Column getColumn(int index2) {
        return this.innerTable().getColumn(index2);
    }

    @Override
    public Index getIndexForColumn(Column column, boolean needGetFirstOrLast, boolean needFindNext) {
        return this.innerTable().getIndexForColumn(column, needGetFirstOrLast, needFindNext);
    }

    @Override
    public Column[] getColumns() {
        return this.innerTable().getColumns();
    }

    @Override
    protected void setColumns(Column[] columns) {
        throw new IllegalStateException("Cols: " + Arrays.asList(columns));
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean force) {
        return this.innerTable().lock(session, exclusive, force);
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s2) {
        this.innerTable().unlock(s2);
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        return this.innerTable().addIndex(session, indexName, indexId, cols, indexType, create, indexComment);
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.innerTable().removeRow(session, row);
    }

    @Override
    public void truncate(Session session) {
        this.innerTable().truncate(session);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.innerTable().addRow(session, row);
    }

    @Override
    public void checkSupportAlter() {
        this.innerTable().checkSupportAlter();
    }

    @Override
    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    @Override
    public Index getUniqueIndex() {
        return this.innerTable().getUniqueIndex();
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.innerTable().getScanIndex(session);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.innerTable().getIndexes();
    }

    @Override
    public boolean isLockedExclusively() {
        return this.innerTable().isLockedExclusively();
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.innerTable().isDeterministic();
    }

    @Override
    public boolean canGetRowCount() {
        return this.innerTable().canGetRowCount();
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.innerTable().getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        Table t = this.tbl.get();
        return t == null ? 0L : t.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getCreateSQL() {
        return "";
    }

    @Override
    public String getDropSQL() {
        return "";
    }

    @Override
    public void addDependencies(HashSet<DbObject> dependencies) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    public static class Engine
    implements TableEngine {
        private static ThreadLocal<GridThreadLocalTable> createdTbl = new ThreadLocal();

        public static GridThreadLocalTable getCreated() {
            GridThreadLocalTable tbl = createdTbl.get();
            assert (tbl != null);
            createdTbl.remove();
            return tbl;
        }

        @Override
        public Table createTable(CreateTableData d) {
            assert (createdTbl.get() == null);
            GridThreadLocalTable tbl = new GridThreadLocalTable(d.schema, d.id, d.tableName, d.persistIndexes, d.persistData);
            createdTbl.set(tbl);
            return tbl;
        }
    }
}

