/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ScanIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableType;

public class GridMergeTable
extends TableBase {
    private ArrayList<Index> idxs;

    public GridMergeTable(CreateTableData data) {
        super(data);
    }

    public void indexes(ArrayList<Index> idxs) {
        assert (!F.isEmpty(idxs));
        this.idxs = idxs;
    }

    public GridMergeIndex getMergeIndex() {
        return (GridMergeIndex)this.idxs.get(this.idxs.size() - 1);
    }

    public static GridH2ScanIndex<GridMergeIndex> createScanIndex(GridMergeIndex idx) {
        return new ScanIndex(idx);
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean force) {
        return false;
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void unlock(Session s2) {
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("addIndex");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("removeRow");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("addRow");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("alter");
    }

    @Override
    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.idxs.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.idxs;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session ses) {
        return this.getScanIndex(ses).getRowCount(ses);
    }

    @Override
    public long getRowCountApproximation() {
        return this.getScanIndex(null).getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    private static class ScanIndex
    extends GridH2ScanIndex<GridMergeIndex> {
        public ScanIndex(GridMergeIndex delegate) {
            super(delegate);
        }

        @Override
        public double getCost(Session session, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
            long rows = this.getRowCountApproximation();
            return this.getCostRangeIndex(masks, rows, filters, filter2, sortOrder, true, allColumnsSet);
        }
    }
}

