/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public final class GridMergeIndexSorted
extends GridMergeIndex {
    private static final IndexType TYPE = IndexType.createNonUnique(false);
    private final Comparator<RowStream> streamCmp = new Comparator<RowStream>(){

        @Override
        public int compare(RowStream o1, RowStream o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return GridMergeIndexSorted.this.compareRows(o1.get(), o2.get());
        }
    };
    private Map<UUID, RowStream[]> streamsMap;
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private GridResultPage failPage;
    private MergeStreamIterator it;

    public GridMergeIndexSorted(GridKernalContext ctx, GridMergeTable tbl, String name, IndexColumn[] cols) {
        super(ctx, tbl, name, TYPE, cols);
    }

    @Override
    public void setSources(Collection<ClusterNode> nodes2, int segmentsCnt) {
        super.setSources(nodes2, segmentsCnt);
        this.streamsMap = U.newHashMap(nodes2.size());
        RowStream[] streams = new RowStream[nodes2.size() * segmentsCnt];
        int i = 0;
        for (ClusterNode node : nodes2) {
            RowStream[] segments2 = new RowStream[segmentsCnt];
            for (int s2 = 0; s2 < segmentsCnt; ++s2) {
                streams[i++] = segments2[s2] = new RowStream();
            }
            if (this.streamsMap.put(node.id(), segments2) == null) continue;
            throw new IllegalStateException();
        }
        this.it = new MergeStreamIterator(streams);
    }

    @Override
    public boolean fetchedAll() {
        return this.it.fetchedAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addPage0(GridResultPage page) {
        if (page.isFail()) {
            this.lock.lock();
            try {
                if (this.failPage != null) return;
                this.failPage = page;
                this.notEmpty.signalAll();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            UUID src = page.source();
            this.streamsMap.get(src)[page.segmentId()].addPage(page);
        }
    }

    @Override
    protected void checkBounds(Row lastEvictedRow, SearchRow first, SearchRow last2) {
        if (lastEvictedRow != null && first != null && this.compareRows(lastEvictedRow, first) < 0) {
            return;
        }
        super.checkBounds(lastEvictedRow, first, last2);
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, SearchRow first, SearchRow last2) {
        Iterator<Object> iter2;
        if (fetched.isEmpty()) {
            iter2 = Collections.emptyIterator();
        } else if (first == null && last2 == null) {
            iter2 = fetched.iterator();
        } else {
            int low;
            int n = low = first == null ? 0 : GridMergeIndexSorted.binarySearchRow(fetched, first, this.firstRowCmp, false);
            if (low == fetched.size()) {
                iter2 = Collections.emptyIterator();
            } else {
                int high = last2 == null ? fetched.size() : GridMergeIndexSorted.binarySearchRow(fetched, last2, this.lastRowCmp, false);
                iter2 = fetched.subList(low, high).iterator();
            }
        }
        return new GridH2Cursor(iter2);
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return this.getCostRangeIndex(masks, this.getRowCountApproximation(), filters, filter2, sortOrder, false, allColumnsSet);
    }

    @Override
    protected Cursor findInStream(@Nullable SearchRow first, @Nullable SearchRow last2) {
        return new GridMergeIndex.FetchingCursor(first, last2, this.it);
    }

    private final class RowStream
    implements GridMergeIndex.Pollable<GridResultPage> {
        Iterator<Value[]> iter = Collections.emptyIterator();
        Row cur;
        GridResultPage nextPage;

        private RowStream() {
        }

        private void addPage(GridResultPage page) {
            assert (!page.isFail());
            if (page.isLast() && page.rowsInPage() == 0) {
                page = GridMergeIndexSorted.this.createDummyLastPage(page);
            }
            GridMergeIndexSorted.this.lock.lock();
            try {
                assert (this.nextPage == null);
                this.nextPage = page;
                GridMergeIndexSorted.this.notEmpty.signalAll();
            }
            finally {
                GridMergeIndexSorted.this.lock.unlock();
            }
        }

        @Override
        public GridResultPage poll(long timeout, TimeUnit unit) throws InterruptedException {
            long nanos = unit.toNanos(timeout);
            GridMergeIndexSorted.this.lock.lock();
            try {
                while (true) {
                    if (GridMergeIndexSorted.this.failPage != null) {
                        GridResultPage gridResultPage = GridMergeIndexSorted.this.failPage;
                        return gridResultPage;
                    }
                    GridResultPage page = this.nextPage;
                    if (page != null) {
                        this.nextPage = page.isLast() && page.response() != null ? GridMergeIndexSorted.this.createDummyLastPage(page) : null;
                        GridResultPage gridResultPage = page;
                        return gridResultPage;
                    }
                    nanos = GridMergeIndexSorted.this.notEmpty.awaitNanos(nanos);
                    if (nanos > 0L) continue;
                    GridResultPage gridResultPage = null;
                    return gridResultPage;
                }
            }
            finally {
                GridMergeIndexSorted.this.lock.unlock();
            }
        }

        private boolean next() {
            this.cur = null;
            this.iter = GridMergeIndexSorted.this.pollNextIterator(this, this.iter);
            if (!this.iter.hasNext()) {
                return false;
            }
            this.cur = GridH2PlainRowFactory.create(this.iter.next());
            return true;
        }

        private Row get() {
            assert (this.cur != null);
            return this.cur;
        }
    }

    private final class MergeStreamIterator
    implements Iterator<Row> {
        private boolean first = true;
        private volatile int off;
        private boolean hasNext;
        private final RowStream[] streams;

        MergeStreamIterator(RowStream[] streams) {
            assert (!F.isEmpty(streams));
            this.streams = streams;
        }

        private boolean fetchedAll() {
            return this.off == this.streams.length;
        }

        private void goFirst() {
            assert (this.first);
            this.first = false;
            for (int i = 0; i < this.streams.length; ++i) {
                RowStream s2 = this.streams[i];
                if (s2.next()) continue;
                this.streams[i] = null;
                ++this.off;
            }
            if (this.off < this.streams.length) {
                Arrays.sort(this.streams, GridMergeIndexSorted.this.streamCmp);
            }
        }

        private void goNext() {
            if (this.off == this.streams.length) {
                return;
            }
            if (this.streams[this.off].next()) {
                GridH2IndexBase.bubbleUp(this.streams, this.off, GridMergeIndexSorted.this.streamCmp);
            } else {
                this.streams[this.off++] = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            if (this.first) {
                this.goFirst();
            } else {
                this.goNext();
            }
            this.hasNext = this.off < this.streams.length;
            return this.hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.streams[this.off].get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

