/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceQueryRun;
import org.h2.index.Cursor;
import org.h2.result.Row;
import org.jetbrains.annotations.Nullable;

class GridMergeIndexIterator
implements Iterator<List<?>>,
AutoCloseable {
    private final GridReduceQueryExecutor rdcExec;
    private final Collection<ClusterNode> nodes;
    private final ReduceQueryRun run;
    private final long qryReqId;
    private final boolean distributedJoins;
    private final Iterator<GridMergeIndex> idxIter;
    private Cursor cursor;
    private List<Object> next;
    private boolean released;
    private MvccQueryTracker mvccTracker;

    GridMergeIndexIterator(GridReduceQueryExecutor rdcExec, Collection<ClusterNode> nodes2, ReduceQueryRun run2, long qryReqId, boolean distributedJoins, @Nullable MvccQueryTracker mvccTracker) throws IgniteCheckedException {
        this.rdcExec = rdcExec;
        this.nodes = nodes2;
        this.run = run2;
        this.qryReqId = qryReqId;
        this.distributedJoins = distributedJoins;
        this.mvccTracker = mvccTracker;
        this.idxIter = run2.indexes().iterator();
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<?> next() {
        List<Object> res = this.next;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.advance();
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    @Override
    public void close() throws Exception {
        this.releaseIfNeeded();
    }

    private void advance() {
        this.next = null;
        try {
            boolean hasNext = false;
            while (this.cursor == null || !(hasNext = this.cursor.next())) {
                if (this.idxIter.hasNext()) {
                    this.cursor = this.idxIter.next().findInStream(null, null);
                    continue;
                }
                this.releaseIfNeeded();
                break;
            }
            if (hasNext) {
                Row row = this.cursor.get();
                int cols = row.getColumnCount();
                ArrayList<Object> res = new ArrayList<Object>(cols);
                for (int c = 0; c < cols; ++c) {
                    res.add(row.getValue(c).getObject());
                }
                this.next = res;
            }
        }
        catch (Exception e) {
            this.releaseIfNeeded();
            throw e;
        }
    }

    private void releaseIfNeeded() {
        if (!this.released) {
            try {
                this.rdcExec.releaseRemoteResources(this.nodes, this.run, this.qryReqId, this.distributedJoins, this.mvccTracker);
            }
            finally {
                this.released = true;
            }
        }
    }
}

